/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.remoting.engine.JnlpClientDatabase;
import org.jenkinsci.remoting.engine.JnlpConnectionState;
import org.jenkinsci.remoting.engine.JnlpConnectionStateListener;
import org.jenkinsci.remoting.engine.JnlpProtocolHandler;
import org.jenkinsci.remoting.engine.LegacyJnlpConnectionState;
import org.jenkinsci.remoting.nio.NioChannelHub;
import org.jenkinsci.remoting.util.ThrowableUtils;

abstract class LegacyJnlpProtocolHandler<STATE extends LegacyJnlpConnectionState>
extends JnlpProtocolHandler<STATE> {
    public static final String GREETING_SUCCESS = "Welcome";
    static final String PROTOCOL_PREFIX = "Protocol:";
    @Nonnull
    private final ExecutorService threadPool;
    @Nullable
    private final NioChannelHub hub;

    public LegacyJnlpProtocolHandler(@Nullable JnlpClientDatabase clientDatabase, @Nonnull ExecutorService threadPool, @Nullable NioChannelHub hub, boolean preferNio) {
        super(clientDatabase, preferNio);
        this.threadPool = threadPool;
        this.hub = hub;
    }

    @Override
    @Nonnull
    protected abstract STATE createConnectionState(@Nonnull Socket var1, @Nonnull List<? extends JnlpConnectionStateListener> var2) throws IOException;

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Generics will ensure the implementation returns the correct type.")
    public Future<Channel> handle(@Nonnull Socket socket, @Nonnull Map<String, String> headers, @Nonnull List<? extends JnlpConnectionStateListener> listeners) throws IOException {
        JnlpConnectionState state = this.createConnectionState(socket, (List)listeners);
        return this.threadPool.submit(new Callable<Channel>((LegacyJnlpConnectionState)state, headers, socket){
            final /* synthetic */ LegacyJnlpConnectionState val$state;
            final /* synthetic */ Map val$headers;
            final /* synthetic */ Socket val$socket;
            {
                this.val$state = legacyJnlpConnectionState;
                this.val$headers = map;
                this.val$socket = socket;
            }

            @Override
            public Channel call() throws Exception {
                try {
                    LegacyJnlpProtocolHandler.this.receiveHandshake(this.val$state, this.val$headers);
                    ChannelBuilder builder = LegacyJnlpProtocolHandler.this.createChannelBuilder(String.format("Channel to %s", this.val$socket.getInetAddress()));
                    this.val$state.fireBeforeChannel(builder);
                    Channel channel = LegacyJnlpProtocolHandler.this.buildChannel(this.val$state);
                    this.val$state.fireAfterChannel(channel);
                    channel.addListener(new Channel.Listener(){

                        @Override
                        public void onClosed(Channel channel, IOException cause) {
                            val$state.fireChannelClosed(cause);
                            val$state.fireAfterDisconnect();
                            try {
                                val$socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                    return channel;
                }
                catch (IOException e) {
                    try {
                        this.val$socket.close();
                    }
                    catch (IOException e1) {
                        ThrowableUtils.addSuppressed(e, e1);
                    }
                    this.val$state.fireAfterDisconnect();
                    throw e;
                }
                catch (IllegalStateException e) {
                    try {
                        this.val$socket.close();
                    }
                    catch (IOException e1) {
                        ThrowableUtils.addSuppressed(e, e1);
                    }
                    this.val$state.fireAfterDisconnect();
                    throw new IOException(e);
                }
            }
        });
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Generics will ensure the implementation returns the correct type.")
    public Future<Channel> connect(@Nonnull Socket socket, @Nonnull Map<String, String> headers, @Nonnull List<? extends JnlpConnectionStateListener> listeners) throws IOException {
        JnlpConnectionState state = this.createConnectionState(socket, (List)listeners);
        return this.threadPool.submit(new Callable<Channel>((LegacyJnlpConnectionState)state, headers, socket){
            final /* synthetic */ LegacyJnlpConnectionState val$state;
            final /* synthetic */ Map val$headers;
            final /* synthetic */ Socket val$socket;
            {
                this.val$state = legacyJnlpConnectionState;
                this.val$headers = map;
                this.val$socket = socket;
            }

            @Override
            public Channel call() throws Exception {
                try {
                    LegacyJnlpProtocolHandler.this.sendHandshake(this.val$state, this.val$headers);
                    ChannelBuilder builder = LegacyJnlpProtocolHandler.this.createChannelBuilder(String.format("Channel to %s", this.val$socket.getInetAddress()));
                    this.val$state.fireBeforeChannel(builder);
                    Channel channel = LegacyJnlpProtocolHandler.this.buildChannel(this.val$state);
                    this.val$state.fireAfterChannel(channel);
                    channel.addListener(new Channel.Listener(){

                        @Override
                        public void onClosed(Channel channel, IOException cause) {
                            val$state.fireChannelClosed(cause);
                            val$state.fireAfterDisconnect();
                            try {
                                val$socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                    return channel;
                }
                catch (IOException e) {
                    try {
                        this.val$socket.close();
                    }
                    catch (IOException e1) {
                        ThrowableUtils.addSuppressed(e, e1);
                    }
                    this.val$state.fireAfterDisconnect();
                    throw e;
                }
                catch (IllegalStateException e) {
                    try {
                        this.val$socket.close();
                    }
                    catch (IOException e1) {
                        ThrowableUtils.addSuppressed(e, e1);
                    }
                    this.val$state.fireAfterDisconnect();
                    throw new IOException(e);
                }
            }
        });
    }

    abstract void sendHandshake(@Nonnull STATE var1, @Nonnull Map<String, String> var2) throws IOException;

    abstract void receiveHandshake(@Nonnull STATE var1, @Nonnull Map<String, String> var2) throws IOException;

    @Nonnull
    abstract Channel buildChannel(@Nonnull STATE var1) throws IOException;

    @Nonnull
    private ChannelBuilder createChannelBuilder(String clientName) {
        if (this.hub == null || !this.isPreferNio()) {
            return new ChannelBuilder(clientName, this.threadPool);
        }
        return this.hub.newChannelBuilder(clientName, this.threadPool);
    }
}

