/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.SocketChannelStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.jenkinsci.remoting.engine.Jnlp4ConnectionState;
import org.jenkinsci.remoting.engine.JnlpClientDatabase;
import org.jenkinsci.remoting.engine.JnlpConnectionStateListener;
import org.jenkinsci.remoting.engine.JnlpProtocolHandler;
import org.jenkinsci.remoting.protocol.IOHub;
import org.jenkinsci.remoting.protocol.NetworkLayer;
import org.jenkinsci.remoting.protocol.ProtocolStack;
import org.jenkinsci.remoting.protocol.impl.AckFilterLayer;
import org.jenkinsci.remoting.protocol.impl.AgentProtocolClientFilterLayer;
import org.jenkinsci.remoting.protocol.impl.BIONetworkLayer;
import org.jenkinsci.remoting.protocol.impl.ChannelApplicationLayer;
import org.jenkinsci.remoting.protocol.impl.ConnectionHeadersFilterLayer;
import org.jenkinsci.remoting.protocol.impl.ConnectionRefusalException;
import org.jenkinsci.remoting.protocol.impl.NIONetworkLayer;
import org.jenkinsci.remoting.protocol.impl.SSLEngineFilterLayer;

public class JnlpProtocol4Handler
extends JnlpProtocolHandler<Jnlp4ConnectionState> {
    private static final Logger LOGGER = Logger.getLogger(JnlpProtocol4Handler.class.getName());
    @Nonnull
    private final ExecutorService threadPool;
    @Nonnull
    private final IOHub ioHub;
    @Nonnull
    private final SSLContext context;
    private final boolean needClientAuth;

    public JnlpProtocol4Handler(@Nullable JnlpClientDatabase clientDatabase, @Nonnull ExecutorService threadPool, @Nonnull IOHub ioHub, @Nonnull SSLContext context, boolean needClientAuth, boolean preferNio) {
        super(clientDatabase, preferNio);
        this.threadPool = threadPool;
        this.ioHub = ioHub;
        this.context = context;
        this.needClientAuth = needClientAuth;
    }

    @Override
    public String getName() {
        return "JNLP4-connect";
    }

    @Override
    @Nonnull
    public Jnlp4ConnectionState createConnectionState(@Nonnull Socket socket, @Nonnull List<? extends JnlpConnectionStateListener> listeners) {
        return new Jnlp4ConnectionState(socket, listeners);
    }

    @Override
    @Nonnull
    public Future<Channel> handle(@Nonnull Socket socket, @Nonnull Map<String, String> headers, @Nonnull List<? extends JnlpConnectionStateListener> listeners) throws IOException {
        NetworkLayer networkLayer = this.createNetworkLayer(socket);
        SSLEngine engine = this.createSSLEngine(socket);
        engine.setWantClientAuth(true);
        engine.setNeedClientAuth(this.needClientAuth);
        engine.setUseClientMode(false);
        Handler handler = new Handler((Jnlp4ConnectionState)this.createConnectionState(socket, (List)listeners), this.getClientDatabase());
        return ProtocolStack.on(networkLayer).filter(new AckFilterLayer()).filter(new SSLEngineFilterLayer(engine, handler)).filter(new ConnectionHeadersFilterLayer(headers, handler)).named(String.format("%s connection from %s", this.getName(), socket.getRemoteSocketAddress())).listener(handler).build(new ChannelApplicationLayer(this.threadPool, handler)).get();
    }

    @Override
    @Nonnull
    public Future<Channel> connect(@Nonnull Socket socket, @Nonnull Map<String, String> headers, @Nonnull List<? extends JnlpConnectionStateListener> listeners) throws IOException {
        NetworkLayer networkLayer = this.createNetworkLayer(socket);
        SSLEngine sslEngine = this.createSSLEngine(socket);
        sslEngine.setUseClientMode(true);
        Handler handler = new Handler((Jnlp4ConnectionState)this.createConnectionState(socket, (List)listeners));
        return ProtocolStack.on(networkLayer).filter(new AgentProtocolClientFilterLayer(this.getName())).filter(new AckFilterLayer()).filter(new SSLEngineFilterLayer(sslEngine, handler)).filter(new ConnectionHeadersFilterLayer(headers, handler)).named(String.format("%s connection to %s", this.getName(), socket.getRemoteSocketAddress())).listener(handler).build(new ChannelApplicationLayer(this.threadPool, handler)).get();
    }

    private NetworkLayer createNetworkLayer(Socket socket) throws IOException {
        SocketChannel socketChannel = this.isPreferNio() ? socket.getChannel() : null;
        NetworkLayer networkLayer = socketChannel == null ? new BIONetworkLayer(this.ioHub, Channels.newChannel(SocketChannelStream.in(socket)), Channels.newChannel(SocketChannelStream.out(socket))) : new NIONetworkLayer(this.ioHub, socketChannel, socketChannel);
        return networkLayer;
    }

    private SSLEngine createSSLEngine(Socket socket) {
        SocketAddress remoteSocketAddress = socket.getRemoteSocketAddress();
        if (remoteSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress remoteInetAddress = (InetSocketAddress)remoteSocketAddress;
            return this.context.createSSLEngine(remoteInetAddress.getHostName(), remoteInetAddress.getPort());
        }
        return this.context.createSSLEngine();
    }

    private class Handler
    extends Channel.Listener
    implements SSLEngineFilterLayer.Listener,
    ConnectionHeadersFilterLayer.Listener,
    ChannelApplicationLayer.Listener,
    ProtocolStack.Listener,
    ChannelApplicationLayer.ChannelDecorator {
        @Nonnull
        private final Jnlp4ConnectionState event;
        private JnlpClientDatabase clientDatabase;
        private boolean client;

        Handler(Jnlp4ConnectionState event) {
            this.event = event;
            this.client = true;
        }

        Handler(Jnlp4ConnectionState event, JnlpClientDatabase clientDatabase) {
            this.event = event;
            this.clientDatabase = clientDatabase;
            this.client = false;
        }

        @Override
        public void onHandshakeCompleted(SSLSession session) throws ConnectionRefusalException {
            X509Certificate remoteCertificate;
            try {
                remoteCertificate = (X509Certificate)session.getPeerCertificates()[0];
            }
            catch (ClassCastException e) {
                throw new ConnectionRefusalException("Unsupported server certificate type", e);
            }
            catch (SSLPeerUnverifiedException e) {
                if (JnlpProtocol4Handler.this.needClientAuth) {
                    throw new ConnectionRefusalException("Client must provide authentication", e);
                }
                remoteCertificate = null;
            }
            this.event.fireBeforeProperties(remoteCertificate);
        }

        @Override
        public void onReceiveHeaders(Map<String, String> headers) throws ConnectionRefusalException {
            if (!this.client) {
                String clientName = headers.get("Node-Name");
                if (this.clientDatabase == null || !this.clientDatabase.exists(clientName)) {
                    throw new ConnectionRefusalException("Unknown client name: " + clientName);
                }
                X509Certificate certificate = this.event.getCertificate();
                JnlpClientDatabase.ValidationResult validation = certificate == null ? JnlpClientDatabase.ValidationResult.UNCHECKED : this.clientDatabase.validateCertificate(clientName, certificate);
                switch (validation) {
                    case IDENTITY_PROVED: {
                        break;
                    }
                    case INVALID: {
                        LOGGER.log(Level.WARNING, "An attempt was made to connect as {0} from {1} with an invalid client certificate", new Object[]{clientName, this.event.getSocket().getRemoteSocketAddress()});
                        throw new ConnectionRefusalException("Authentication failure");
                    }
                    default: {
                        String secretKey = this.clientDatabase.getSecretOf(clientName);
                        if (secretKey == null) {
                            throw new ConnectionRefusalException("Unknown client name: " + clientName);
                        }
                        if (secretKey.equals(headers.get("Secret-Key"))) break;
                        LOGGER.log(Level.WARNING, "An attempt was made to connect as {0} from {1} with an incorrect secret", new Object[]{clientName, this.event.getSocket().getRemoteSocketAddress()});
                        throw new ConnectionRefusalException("Authorization failure");
                    }
                }
            }
            this.event.fireAfterProperties(headers);
        }

        @Override
        public void onChannel(final @Nonnull Channel channel) {
            channel.addListener(this);
            JnlpProtocol4Handler.this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    if (!channel.isClosingOrClosed()) {
                        Handler.this.event.fireAfterChannel(channel);
                    }
                }
            });
        }

        @Override
        @Nonnull
        public ChannelBuilder decorate(@Nonnull ChannelBuilder builder) {
            if (!this.client) {
                builder.withMode(Channel.Mode.NEGOTIATE);
            }
            this.event.fireBeforeChannel(builder);
            return this.event.getChannelBuilder();
        }

        @Override
        public void onClosed(Channel channel, IOException cause) {
            if (channel != this.event.getChannel()) {
                return;
            }
            this.event.fireChannelClosed(cause);
            channel.removeListener(this);
            try {
                this.event.getSocket().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClosed(ProtocolStack stack, IOException cause) {
            try {
                this.event.fireAfterDisconnect();
            }
            finally {
                stack.removeListener(this);
                try {
                    this.event.getSocket().close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

