/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

abstract class URLish {
    private URLish() {
    }

    @CheckForNull
    abstract URL toURL() throws MalformedURLException;

    @Nonnull
    static URLish from(final @Nonnull URL url) {
        return new URLish(){

            @Override
            @Nonnull
            URL toURL() {
                return url;
            }
        };
    }

    @Nonnull
    static URLish from(final @Nonnull File f) {
        return new URLish(){

            @Override
            URL toURL() throws MalformedURLException {
                if (f.exists()) {
                    return f.toURI().toURL();
                }
                return null;
            }
        };
    }
}

