/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.Command;
import hudson.remoting.ErrorPropagatingOutputStream;
import hudson.remoting.PipeWindow;
import hudson.remoting.Request;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

final class ProxyOutputStream
extends OutputStream
implements ErrorPropagatingOutputStream {
    private Channel channel;
    private int oid;
    private PipeWindow window;
    private boolean closed;
    private Throwable error;
    private static final Logger LOGGER = Logger.getLogger(ProxyOutputStream.class.getName());

    public ProxyOutputStream() {
    }

    public ProxyOutputStream(@Nonnull Channel channel, int oid) throws IOException {
        this.connect(channel, oid);
    }

    synchronized void connect(@Nonnull Channel channel, int oid) throws IOException {
        if (this.channel != null) {
            throw new IllegalStateException("Cannot connect twice");
        }
        if (oid == 0) {
            throw new IllegalArgumentException("oid=0");
        }
        this.channel = channel;
        this.oid = oid;
        this.window = channel.getPipeWindow(oid);
        if (this.closed) {
            this.doClose(this.error);
        }
        this.notifyAll();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        try {
            while (this.channel == null) {
                if (this.closed) {
                    throw new IOException("stream is already closed");
                }
                this.wait();
            }
            int max = this.window.max();
            while (len > 0) {
                int sendable = Math.min(this.window.get(Math.min(max / 10, len)), len);
                sendable = Math.min(sendable, max / 2);
                this.channel.send(new Chunk(this.channel.newIoId(), this.oid, b, off, sendable));
                this.window.decrease(sendable);
                off += sendable;
                len -= sendable;
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.channel != null) {
            this.channel.send(new Flush(this.channel.newIoId(), this.oid));
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.error(null);
    }

    @Override
    public synchronized void error(Throwable e) throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.error = e;
        }
        if (this.channel != null) {
            this.doClose(e);
        }
        this.notifyAll();
    }

    private void doClose(Throwable error) throws IOException {
        this.channel.send(new EOF(this.channel.newIoId(), this.oid, error));
        this.channel = null;
        this.oid = -1;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.channel != null && this.oid != -1) {
            this.channel.send(new Unexport(this.channel.newIoId(), this.oid));
            this.oid = -1;
        }
    }

    @Deprecated
    private static void markForIoSync(Channel channel, int requestId, Future<?> ioOp) {
        Request<?, ?> call = channel.pendingCalls.get(requestId);
        if (call != null) {
            call.lastIo = ioOp;
        }
    }

    private static final class NotifyDeadWriter
    extends Command {
        private final int oid;
        private static final long serialVersionUID = 1L;

        private NotifyDeadWriter(Channel channel, Throwable cause, int oid) {
            super(channel, cause);
            this.oid = oid;
        }

        @Override
        protected void execute(Channel channel) {
            PipeWindow w = channel.getPipeWindow(this.oid);
            w.dead(this.createdAt != null ? this.createdAt.getCause() : null);
        }

        @Override
        public String toString() {
            return "ProxyOutputStream.Dead(" + this.oid + ")";
        }
    }

    private static class Ack
    extends Command {
        private final int oid;
        private final int size;
        private static final long serialVersionUID = 1L;

        private Ack(int oid, int size) {
            super(false);
            this.oid = oid;
            this.size = size;
        }

        @Override
        protected void execute(Channel channel) {
            PipeWindow w = channel.getPipeWindow(this.oid);
            w.increase(this.size);
        }

        @Override
        public String toString() {
            return "ProxyOutputStream.Ack(" + this.oid + ',' + this.size + ")";
        }
    }

    private static final class EOF
    extends Command {
        private final int oid;
        private final int requestId = Request.getCurrentRequestId();
        private final int ioId;
        private final Throwable error;
        private static final long serialVersionUID = 1L;

        public EOF(int ioId, int oid, Throwable error) {
            this.ioId = ioId;
            this.oid = oid;
            this.error = error;
        }

        @Override
        protected void execute(final Channel channel) {
            final OutputStream os = (OutputStream)channel.getExportedObjectOrNull(this.oid);
            if (os == null) {
                LOGGER.log(Level.FINE, "InputStream with oid=%s has been already unexported", this.oid);
                return;
            }
            ProxyOutputStream.markForIoSync(channel, this.requestId, channel.pipeWriter.submit(this.ioId, new Runnable(){

                @Override
                public void run() {
                    channel.unexport(oid, createdAt, false);
                    try {
                        if (error != null && os instanceof ErrorPropagatingOutputStream) {
                            ((ErrorPropagatingOutputStream)((Object)os)).error(error);
                        }
                        os.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }));
        }

        @Override
        public String toString() {
            return "ProxyOutputStream.EOF(" + this.oid + ")";
        }
    }

    private static class Unexport
    extends Command {
        private final int oid;
        private final int ioId;
        private static final long serialVersionUID = 1L;

        public Unexport(int ioId, int oid) {
            this.ioId = ioId;
            this.oid = oid;
        }

        @Override
        protected void execute(final Channel channel) {
            channel.pipeWriter.submit(this.ioId, new Runnable(){

                @Override
                public void run() {
                    channel.unexport(oid, createdAt, false);
                }
            });
        }

        @Override
        public String toString() {
            return "ProxyOutputStream.Unexport(" + this.oid + ")";
        }
    }

    private static final class Flush
    extends Command {
        private final int oid;
        private final int requestId = Request.getCurrentRequestId();
        private final int ioId;
        private static final long serialVersionUID = 1L;

        public Flush(int ioId, int oid) {
            super(false);
            this.ioId = ioId;
            this.oid = oid;
        }

        @Override
        protected void execute(Channel channel) throws ExecutionException {
            final OutputStream os = (OutputStream)channel.getExportedObject(this.oid);
            ProxyOutputStream.markForIoSync(channel, this.requestId, channel.pipeWriter.submit(this.ioId, new Runnable(){

                @Override
                public void run() {
                    try {
                        os.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }));
        }

        @Override
        public String toString() {
            return "Pipe.Flush(" + this.oid + ")";
        }
    }

    private static final class Chunk
    extends Command {
        private final int oid;
        private final int ioId;
        private final int requestId = Request.getCurrentRequestId();
        private final byte[] buf;
        private static final long serialVersionUID = 1L;

        public Chunk(int ioId, int oid, byte[] buf, int start, int len) {
            super(false);
            this.ioId = ioId;
            this.oid = oid;
            if (start == 0 && len == buf.length) {
                this.buf = buf;
            } else {
                this.buf = new byte[len];
                System.arraycopy(buf, start, this.buf, 0, len);
            }
        }

        @Override
        protected void execute(final Channel channel) throws ExecutionException {
            OutputStream os;
            try {
                os = (OutputStream)channel.getExportedObject(this.oid);
            }
            catch (ExecutionException ex) {
                throw new ExecutionException(String.format("Channel %s: Output stream object has been released before sending last chunk for oid=%s", channel.getName(), this.oid), ex);
            }
            ProxyOutputStream.markForIoSync(channel, this.requestId, channel.pipeWriter.submit(this.ioId, new Runnable(){

                @Override
                public void run() {
                    try {
                        os.write(buf);
                    }
                    catch (IOException e) {
                        try {
                            channel.send(new NotifyDeadWriter(channel, e, oid));
                        }
                        catch (ChannelClosedException channelClosedException) {
                        }
                        catch (IOException x) {
                            LOGGER.log(Level.WARNING, "Failed to notify the sender that the write end is dead", x);
                            LOGGER.log(Level.WARNING, "... the failed write was:", e);
                        }
                    }
                    finally {
                        if (channel.remoteCapability.supportsPipeThrottling()) {
                            try {
                                channel.send(new Ack(oid, buf.length));
                            }
                            catch (ChannelClosedException e) {
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.WARNING, "Failed to ack the stream", e);
                            }
                        }
                    }
                }
            }));
        }

        @Override
        public String toString() {
            return "Pipe.Chunk(" + this.oid + "," + this.buf.length + ")";
        }
    }
}

