/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Future;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;

public class AsyncFutureImpl<V>
implements Future<V> {
    private boolean completed;
    private V value;
    private Throwable problem;
    private boolean cancelled;

    public AsyncFutureImpl() {
    }

    public AsyncFutureImpl(V value) {
        this.set(value);
    }

    public AsyncFutureImpl(Throwable value) {
        this.set(value);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.completed;
    }

    @Override
    public synchronized V get() throws InterruptedException, ExecutionException {
        while (!this.completed) {
            this.wait();
        }
        if (this.problem != null) {
            throw new ExecutionException(this.problem);
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        return this.value;
    }

    @Override
    @CheckForNull
    public synchronized V get(@Nonnegative long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeToWait;
        long endWaitTime = System.nanoTime() + unit.toNanos(timeout);
        while (!this.completed && (timeToWait = endWaitTime - System.nanoTime()) >= 0L) {
            this.wait(timeToWait / 1000000L, (int)(timeToWait % 1000000L));
        }
        if (!this.completed) {
            throw new TimeoutException();
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        return this.get();
    }

    public synchronized void set(V value) {
        this.completed = true;
        this.value = value;
        this.notifyAll();
    }

    public synchronized void set(Throwable problem) {
        this.completed = true;
        this.problem = problem;
        this.notifyAll();
    }

    public synchronized void setAsCancelled() {
        this.completed = true;
        this.cancelled = true;
        this.notifyAll();
    }
}

