/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import hudson.plugins.swarm.Candidate;
import hudson.plugins.swarm.Options;
import hudson.plugins.swarm.SoftLabelUpdateException;
import hudson.plugins.swarm.SwarmClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class LabelFileWatcher
implements Runnable {
    private static String sFileName;
    private static boolean bRunning;
    private static Options opts;
    private static String sLabels;
    private static String[] sArgs;
    private static Candidate targ;
    private static final Logger logger;

    public LabelFileWatcher(Candidate target, Options options, String ... args) throws IOException {
        logger.config("LabelFileWatcher() constructed with: " + options.labelsFile + ", and " + args);
        targ = target;
        opts = options;
        sFileName = options.labelsFile;
        sLabels = new String(Files.readAllBytes(Paths.get(sFileName, new String[0])));
        sArgs = args;
        logger.config("Labels loaded: " + sLabels);
    }

    protected HttpClient createHttpClient(URL urlForAuth) {
        logger.fine("createHttpClient() invoked");
        if (LabelFileWatcher.opts.disableSslVerification) {
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new SwarmClient.DefaultTrustManager()}, new SecureRandom());
                SSLContext.setDefault(ctx);
            }
            catch (KeyManagementException e) {
                logger.log(Level.SEVERE, "KeyManagementException occurred", e);
                throw new RuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                logger.log(Level.SEVERE, "NoSuchAlgorithmException occurred", e);
                throw new RuntimeException(e);
            }
        }
        HttpClient client = SwarmClient.getGlobalHttpClient();
        if (LabelFileWatcher.opts.username != null && LabelFileWatcher.opts.password != null) {
            logger.fine("Setting HttpClient credentials based on options passed");
            client.getState().setCredentials(new AuthScope(urlForAuth.getHost(), urlForAuth.getPort()), (Credentials)new UsernamePasswordCredentials(LabelFileWatcher.opts.username, LabelFileWatcher.opts.password));
        }
        client.getParams().setAuthenticationPreemptive(true);
        return client;
    }

    private void softLabelUpdate(String sNewLabels) throws SoftLabelUpdateException, MalformedURLException {
        logger.log(Level.CONFIG, "NOTICE: " + sFileName + " has changed.  Attempting soft label update (no slave restart)");
        HttpClient h = this.createHttpClient(new URL(targ.getURL()));
        logger.log(Level.CONFIG, "Getting current labels from master");
        GetMethod get = null;
        try {
            Document xml;
            get = new GetMethod(targ.getURL() + "/plugin/swarm/getSlaveLabels?name=" + LabelFileWatcher.opts.name + "&secret=" + targ.getSecret());
            int responseCode = h.executeMethod((HttpMethod)get);
            if (responseCode != 200) {
                logger.log(Level.CONFIG, "Failed to retrieve labels from master -- Response code: " + responseCode);
                throw new SoftLabelUpdateException("Unable to acquire labels from master to begin removal process.");
            }
            try {
                xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(get.getResponseBody()));
            }
            catch (SAXException e) {
                String msg = "Invalid XML received from " + targ.getURL();
                logger.log(Level.SEVERE, msg, e);
                throw new SoftLabelUpdateException(msg);
            }
            String labelStr = SwarmClient.getChildElementString(xml.getDocumentElement(), "labels");
            labelStr = labelStr.replace("swarm", "");
            logger.log(Level.CONFIG, "Labels to be removed: " + labelStr);
            List<String> lLabels = Arrays.asList(labelStr.split("\\s+"));
            StringBuilder sb = new StringBuilder();
            for (String s : lLabels) {
                sb.append(s);
                sb.append(" ");
                if (sb.length() <= 1000) continue;
                SwarmClient.postLabelRemove(LabelFileWatcher.opts.name, sb.toString(), h, targ);
                sb = new StringBuilder();
            }
            if (sb.length() > 0) {
                SwarmClient.postLabelRemove(LabelFileWatcher.opts.name, sb.toString(), h, targ);
            }
            logger.log(Level.CONFIG, "Labels to be added: " + sNewLabels);
            lLabels = Arrays.asList(sNewLabels.split("\\s+"));
            sb = new StringBuilder();
            for (String s : lLabels) {
                sb.append(s);
                sb.append(" ");
                if (sb.length() <= 1000) continue;
                SwarmClient.postLabelAppend(LabelFileWatcher.opts.name, sb.toString(), h, targ);
                sb = new StringBuilder();
            }
            if (sb.length() > 0) {
                SwarmClient.postLabelAppend(LabelFileWatcher.opts.name, sb.toString(), h, targ);
            }
        }
        catch (Exception e) {
            throw new SoftLabelUpdateException(e.getLocalizedMessage());
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
    }

    private void hardLabelUpdate() throws IOException {
        logger.config("NOTICE: " + sFileName + " has changed.  Hard slave restart attempt initiated.");
        bRunning = false;
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        try {
            File currentJar = new File(LabelFileWatcher.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!currentJar.getName().endsWith(".jar")) {
                throw new URISyntaxException(currentJar.getName(), "Doesn't end in .jar");
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaBin);
            if (System.getProperty("java.util.logging.config.file") == null) {
                logger.warning("NOTE:  You do not have a -Djava.util.logging.config.file specified, but your labels file has changed.  You will lose logging for the new client instance. Although the client will continue to work, you will have no logging.");
            } else {
                command.add("-Djava.util.logging.config.file=" + System.getProperty("java.util.logging.config.file"));
            }
            command.add("-jar");
            command.add(currentJar.getPath());
            for (int i = 0; i < sArgs.length; ++i) {
                command.add(sArgs[i]);
            }
            String sCommandString = Arrays.toString(command.toArray());
            sCommandString = sCommandString.replaceAll("\n", "").replaceAll("\r", "").replaceAll(",", "");
            logger.config("Invoking: " + sCommandString);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.start();
            logger.config("New slave instance started, ignore subsequent warning.");
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "ERROR: LabelFileWatcher unable to determine current running jar.  Slave failure.  URISyntaxException.", e);
        }
    }

    public void run() {
        bRunning = true;
        logger.config("LabelFileWatcher running, monitoring file: " + sFileName);
        while (bRunning) {
            try {
                logger.log(Level.FINE, "LabelFileWatcher sleeping 10 secs");
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "LabelFileWatcher InterruptedException occurred.", e);
            }
            try {
                String sTempLabels = new String(Files.readAllBytes(Paths.get(sFileName, new String[0])));
                if (sTempLabels.equalsIgnoreCase(sLabels)) {
                    logger.log(Level.FINEST, "Nothing to do. " + sFileName + " has not changed.");
                    continue;
                }
                try {
                    this.softLabelUpdate(sTempLabels);
                    sLabels = new String(Files.readAllBytes(Paths.get(sFileName, new String[0])));
                }
                catch (SoftLabelUpdateException e) {
                    logger.log(Level.WARNING, "WARNING: Normal process, soft label update failed. " + e.getLocalizedMessage() + ", forcing swarm client reboot.  This can be disruptive to Jenkins jobs.  Check your swarm client log files to see why this is happening.");
                    this.hardLabelUpdate();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "WARNING: unable to read " + sFileName + ", slave may not be reporting proper labels to master.", e);
            }
        }
        logger.warning("LabelFileWatcher no longer running.  Shutting down this instance of Swarm Client.");
        System.exit(0);
    }

    public void stopLabelFileWatcher() {
        bRunning = false;
        logger.config("Stopping LabelFileWatcher thread");
    }

    static {
        bRunning = false;
        opts = null;
        targ = null;
        logger = Logger.getLogger(LabelFileWatcher.class.getPackage().getName());
    }
}

