/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.trilead.ssh2.crypto.Base64;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.plugins.svn_partial_release_mgr.api.PluginFactory;
import hudson.plugins.svn_partial_release_mgr.api.PluginService;
import hudson.plugins.svn_partial_release_mgr.api.constants.Constants;
import hudson.plugins.svn_partial_release_mgr.api.constants.PluginUtil;
import hudson.plugins.svn_partial_release_mgr.api.model.AllIssueRevisionsInfo;
import hudson.plugins.svn_partial_release_mgr.api.model.JobConfigurationUserInput;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.scm.SubversionChangeLogParser;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.SubversionWorkspaceSelector;
import hudson.util.EditDistance;
import hudson.util.FormFieldValidator;
import hudson.util.IOException2;
import hudson.util.MultipartFormDataParser;
import hudson.util.Scrambler;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.security.Roles;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Chmod;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;
import org.kohsuke.putty.PuTTYKey;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.DefaultHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SubversionReleaseSCM
extends SCM
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SubversionReleaseSCM.class.getName());
    private static final Logger LOGGER = Logger.getLogger(SubversionReleaseSCM.class.getName());
    private final JobConfigurationUserInput releaseInput;
    private final SubversionRepositoryBrowser browser;
    private ModuleLocation location;

    public SubversionReleaseSCM(JobConfigurationUserInput releaseInput, SubversionRepositoryBrowser browser) {
        this.releaseInput = releaseInput;
        this.location = releaseInput.getLocation();
        this.browser = browser;
    }

    public static SVNClientManager createSvnClientManager(ISVNAuthenticationProvider authProvider) {
        ISVNAuthenticationManager sam = SVNWCUtil.createDefaultAuthenticationManager();
        sam.setAuthenticationProvider(authProvider);
        return SVNClientManager.newInstance((ISVNOptions)SVNWCUtil.createDefaultOptions((boolean)true), (ISVNAuthenticationManager)sam);
    }

    public static SVNClientManager createSvnClientManager() {
        return SubversionReleaseSCM.createSvnClientManager(DescriptorImpl.DESCRIPTOR.createAuthenticationProvider());
    }

    private static String getLastPathComponent(String s) {
        String[] tokens = s.split("/");
        return tokens[tokens.length - 1];
    }

    public String getTagName() {
        return this.releaseInput.getTagName();
    }

    public AllIssueRevisionsInfo getIssueRevisionsInfo(String workspaceRootPath) throws IOException {
        return this.newPluginService().getAllRevisionsInfo(this.releaseInput, workspaceRootPath);
    }

    public boolean hasTagBackupSource(String workspaceRootPath) throws IOException {
        String backupTagSourceLocation = PluginUtil.getFullPathToTagBackupSource(workspaceRootPath, this.releaseInput.getTagName());
        return new File(backupTagSourceLocation).exists();
    }

    public SubversionRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public String getIssuePrefixes() {
        return StringUtils.defaultIfBlank((String)this.releaseInput.getIssuePrefixes(), (String)"PBBPMG-,VGR-");
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public ModuleLocation getLocation() {
        return this.location;
    }

    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        PluginService pluginService = this.newPluginService();
        AllIssueRevisionsInfo allIssueRevisionsInfo = this.getIssueRevisionsInfo(workspace.getRemote());
        pluginService.checkout(this.releaseInput, allIssueRevisionsInfo, build, launcher, workspace, listener, changelogFile, LOGGER);
        return true;
    }

    protected PluginService newPluginService() {
        return PluginFactory.getBean(PluginService.class);
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        AbstractBuild lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            listener.getLogger().println("No existing build. Starting a new one");
            return true;
        }
        try {
            if (!this.repositoryLocationsExist(lastBuild, listener)) {
                listener.getLogger().println("One or more repository locations do not exist anymore for " + project + ", project will be disabled.");
                project.makeDisabled(true);
                return false;
            }
        }
        catch (SVNException e) {
            e.printStackTrace(listener.error(e.getMessage()));
            return false;
        }
        Thread.sleep(60000L);
        return false;
    }

    public ChangeLogParser createChangeLogParser() {
        return new SubversionChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        if (this.location != null) {
            return workspace.child(this.location.local);
        }
        return workspace;
    }

    public FilePath[] getModuleRoots(FilePath workspace) {
        ModuleLocation moduleLocation = this.getLocation();
        if (moduleLocation != null) {
            FilePath[] moduleRoots = new FilePath[]{workspace.child(moduleLocation.local)};
            return moduleRoots;
        }
        return new FilePath[]{this.getModuleRoot(workspace)};
    }

    public boolean repositoryLocationsExist(AbstractBuild<?, ?> build, TaskListener listener) throws SVNException {
        PrintStream out = listener.getLogger();
        ModuleLocation l = this.getLocation();
        if (this.getDescriptor().checkRepositoryPath(l.getSVNURL()) == SVNNodeKind.NONE) {
            out.println("Location '" + l.remote + "' does not exist");
            ParametersAction params = (ParametersAction)build.getAction(ParametersAction.class);
            if (params != null) {
                out.println("Location could be expanded on build '" + build + "' parameters values:");
                for (ParameterValue paramValue : params) {
                    out.println("  " + paramValue);
                }
            }
            return false;
        }
        return true;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return null;
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        return null;
    }

    static {
        new Initializer();
    }

    public static final class ModuleLocation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String remote;
        public final String local;

        public ModuleLocation(String remote, String local) {
            if (local == null) {
                local = SubversionReleaseSCM.getLastPathComponent(remote);
            }
            this.remote = remote.trim();
            this.local = local.trim();
        }

        public String getURL() {
            int idx = this.remote.lastIndexOf(64);
            if (idx > 0) {
                try {
                    String n = this.remote.substring(idx + 1);
                    Long.parseLong(n);
                    return this.remote.substring(0, idx);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.remote;
        }

        public SVNURL getSVNURL() throws SVNException {
            return SVNURL.parseURIEncoded((String)this.getURL());
        }

        public SVNRevision getRevision(SVNRevision defaultValue) {
            int idx = this.remote.lastIndexOf(64);
            if (idx > 0) {
                try {
                    String n = this.remote.substring(idx + 1);
                    return SVNRevision.create((long)Long.parseLong(n));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }

        private String getExpandedRemote(AbstractBuild<?, ?> build) {
            String outRemote = this.remote;
            ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
            if (parameters != null) {
                outRemote = parameters.substitute(build, this.remote);
            }
            return outRemote;
        }

        public ModuleLocation getExpandedLocation(AbstractBuild<?, ?> build) {
            return new ModuleLocation(this.getExpandedRemote(build), this.local);
        }

        public String toString() {
            return this.remote;
        }
    }

    private static final class Initializer {
        private Initializer() {
        }

        static {
            if (Boolean.getBoolean("hudson.spool-svn")) {
                DAVRepositoryFactory.setup((IHTTPConnectionFactory)new DefaultHTTPConnectionFactory(null, true, null));
            } else {
                DAVRepositoryFactory.setup();
            }
            SVNRepositoryFactoryImpl.setup();
            FSRepositoryFactory.setup();
            if (System.getProperty("svnkit.symlinks") == null) {
                System.setProperty("svnkit.symlinks", "false");
            }
            if (System.getProperty("svnkit.ssh2.persistent") == null) {
                System.setProperty("svnkit.ssh2.persistent", "false");
            }
            SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new SubversionWorkspaceSelector());
        }
    }

    public static class DescriptorImpl
    extends SCMDescriptor<SubversionReleaseSCM> {
        @Extension
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
        private final Map<String, Credential> credentials = new Hashtable<String, Credential>();
        private final transient RemotableSVNAuthenticationProviderImpl remotableProvider = new RemotableSVNAuthenticationProviderImpl();

        private DescriptorImpl() {
            super(SubversionReleaseSCM.class, SubversionRepositoryBrowser.class);
            this.load();
        }

        protected DescriptorImpl(Class clazz, Class<? extends RepositoryBrowser> repositoryBrowser) {
            super(clazz, repositoryBrowser);
        }

        public static String getRelativePath(SVNURL repoURL, SVNRepository repository) throws SVNException {
            String repoPath = repoURL.getPath().substring(repository.getRepositoryRoot(false).getPath().length());
            if (!repoPath.startsWith("/")) {
                repoPath = "/" + repoPath;
            }
            return repoPath;
        }

        public String getDisplayName() {
            return "Svn-Partial Release Manager";
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JobConfigurationUserInput releaseInput = new JobConfigurationUserInput(req.getParameter("svn-r.location_remote"), req.getParameter("tagName"), req.getParameter("issuePrefixes"));
            return new SubversionReleaseSCM(releaseInput, (SubversionRepositoryBrowser)RepositoryBrowsers.createInstance(SubversionRepositoryBrowser.class, (StaplerRequest)req, (JSONObject)formData, (String)"browser"));
        }

        public ISVNAuthenticationProvider createAuthenticationProvider() {
            return new SVNAuthenticationProviderImpl(this.remotableProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doPostCredential(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            File keyFile;
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);
            String url = parser.get("url");
            String kind = parser.get("kind");
            int idx = Arrays.asList("", "password", "publickey", "certificate").indexOf(kind);
            final String username = parser.get("username" + idx);
            final String password = parser.get("password" + idx);
            FileItem item = null;
            if (idx <= 1) {
                keyFile = null;
            } else {
                item = parser.getFileItem(kind.equals("publickey") ? "privateKey" : "certificate");
                keyFile = File.createTempFile("hudson", "key");
                if (item != null) {
                    try {
                        item.write(keyFile);
                    }
                    catch (Exception e) {
                        throw new IOException2((Throwable)e);
                    }
                    if (PuTTYKey.isPuTTYKeyFile((File)keyFile)) {
                        LOGGER.info("Converting " + keyFile + " from PuTTY format to OpenSSH format");
                        new PuTTYKey(keyFile, null).toOpenSSH(keyFile);
                    }
                }
            }
            StringWriter log = new StringWriter();
            final PrintWriter logWriter = new PrintWriter(log);
            final boolean[] authenticationAttemped = new boolean[1];
            final boolean[] authenticationAcknowled = new boolean[1];
            SVNRepository repository = null;
            try {
                repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)url));
                repository.setAuthenticationManager((ISVNAuthenticationManager)new DefaultSVNAuthenticationManager(SVNWCUtil.getDefaultConfigurationDirectory(), true, username, password, keyFile, password){
                    Credential cred;
                    {
                        super(x0, x1, x2, x3, x4, x5);
                        this.cred = null;
                    }

                    public SVNAuthentication getFirstAuthentication(String kind, String realm, SVNURL url) throws SVNException {
                        authenticationAttemped[0] = true;
                        if (kind.equals("svn.username")) {
                            return new SVNUserNameAuthentication(username, false);
                        }
                        if (kind.equals("svn.simple")) {
                            logWriter.println("Passing user name " + username + " and password you entered");
                            this.cred = new PasswordCredential(username, password);
                        }
                        if (kind.equals("svn.ssh")) {
                            if (keyFile == null) {
                                logWriter.println("Passing user name " + username + " and password you entered to SSH");
                                this.cred = new PasswordCredential(username, password);
                            } else {
                                logWriter.println("Attempting a public key authentication with username " + username);
                                this.cred = new SshPublicKeyCredential(username, password, keyFile);
                            }
                        }
                        if (kind.equals("svn.ssl.client-passphrase")) {
                            logWriter.println("Attempting an SSL client certificate authentcation");
                            this.cred = new SslClientCertificateCredential(keyFile, password);
                        }
                        if (this.cred == null) {
                            logWriter.println("Unknown authentication method: " + kind);
                            return null;
                        }
                        return this.cred.createSVNAuthentication(kind);
                    }

                    public SVNAuthentication getNextAuthentication(String kind, String realm, SVNURL url) throws SVNException {
                        SVNErrorManager.authenticationFailed((String)("Authentication failed for " + url), null);
                        return null;
                    }

                    public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication) throws SVNException {
                        authenticationAcknowled[0] = true;
                        if (accepted) {
                            assert (this.cred != null);
                            DescriptorImpl.this.credentials.put(realm, this.cred);
                            DescriptorImpl.this.save();
                        } else {
                            logWriter.println("Failed to authenticate: " + errorMessage);
                            if (errorMessage.getCause() != null) {
                                errorMessage.getCause().printStackTrace(logWriter);
                            }
                        }
                        super.acknowledgeAuthentication(accepted, kind, realm, errorMessage, authentication);
                    }
                });
                repository.testConnection();
                if (!authenticationAttemped[0]) {
                    logWriter.println("No authentication was attemped.");
                    throw new SVNCancelException();
                }
                if (!authenticationAcknowled[0]) {
                    logWriter.println("Authentication was not acknowledged.");
                    throw new SVNCancelException();
                }
                rsp.sendRedirect("credentialOK");
            }
            catch (SVNException e) {
                logWriter.println("FAILED: " + e.getErrorMessage());
                req.setAttribute("message", (Object)log.toString());
                req.setAttribute("pre", (Object)true);
                req.setAttribute("exception", (Object)e);
                rsp.forward((Object)Hudson.getInstance(), "error", req);
            }
            finally {
                if (keyFile != null) {
                    keyFile.delete();
                }
                if (item != null) {
                    item.delete();
                }
                if (repository != null) {
                    repository.closeSession();
                }
            }
        }

        public void doSvnRemoteLocationCheck(final StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void check() throws IOException, ServletException {
                    block14: {
                        String url = Util.nullify((String)this.request.getParameter("value"));
                        if (url == null) {
                            this.ok();
                            return;
                        }
                        if (!Constants.URL_PATTERN.matcher(url = url.trim()).matches()) {
                            this.errorWithMarkup("Invalid URL syntax. See <a href=\"http://svnbook.red-bean.com/en/1.2/svn-book.html#svn.basic.in-action.wc.tbl-1\">this</a> for information about valid URLs.");
                            return;
                        }
                        if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                            this.ok();
                        } else {
                            try {
                                SVNURL repoURL = SVNURL.parseURIDecoded((String)url);
                                if (DescriptorImpl.this.checkRepositoryPath(repoURL) == SVNNodeKind.NONE) {
                                    SVNRepository repository = null;
                                    try {
                                        String repoPath;
                                        repository = DescriptorImpl.this.getRepository(repoURL);
                                        long rev = repository.getLatestRevision();
                                        String p = repoPath = DescriptorImpl.getRelativePath(repoURL, repository);
                                        while (p.length() > 0) {
                                            if (repository.checkPath(p = SVNPathUtil.removeTail((String)p), rev) != SVNNodeKind.DIR) continue;
                                            ArrayList entries = new ArrayList();
                                            repository.getDir(p, rev, false, entries);
                                            ArrayList<String> paths = new ArrayList<String>();
                                            for (SVNDirEntry e : entries) {
                                                if (e.getKind() != SVNNodeKind.DIR) continue;
                                                paths.add(e.getName());
                                            }
                                            String head = SVNPathUtil.head((String)repoPath.substring(p.length() + 1));
                                            String candidate = EditDistance.findNearest((String)head, paths);
                                            this.error("'%1$s/%2$s' doesn't exist in the repository. Maybe you meant '%1$s/%3$s'?", new Object[]{p, head, candidate});
                                            return;
                                        }
                                        this.error(repoPath + " doesn't exist in the repository");
                                        break block14;
                                    }
                                    finally {
                                        if (repository != null) {
                                            repository.closeSession();
                                        }
                                    }
                                }
                                this.ok();
                            }
                            catch (SVNException e) {
                                String message = "";
                                message = message + "Unable to access " + Util.escape((String)url) + " : " + Util.escape((String)e.getErrorMessage().getFullMessage());
                                message = message + " <a href='#' id=svnerrorlink onclick='javascript:document.getElementById(\"svnerror\").style.display=\"block\";document.getElementById(\"svnerrorlink\").style.display=\"none\";return false;'>(show details)</a>";
                                message = message + "<pre id=svnerror style='display:none'>" + Functions.printThrowable((Throwable)e) + "</pre>";
                                message = message + " (Maybe you need to <a target='_new' href='" + req.getContextPath() + "/scm/SubversionReleaseSCM/enterCredential?" + url + "'>enter credential</a>?)";
                                message = message + "<br>";
                                logger.log(Level.INFO, "Failed to access subversion repository " + url, e);
                                this.errorWithMarkup(message);
                            }
                        }
                    }
                }
            }.process();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SVNNodeKind checkRepositoryPath(SVNURL repoURL) throws SVNException {
            SVNRepository repository = null;
            try {
                repository = this.getRepository(repoURL);
                repository.testConnection();
                long rev = repository.getLatestRevision();
                String repoPath = DescriptorImpl.getRelativePath(repoURL, repository);
                SVNNodeKind sVNNodeKind = repository.checkPath(repoPath, rev);
                return sVNNodeKind;
            }
            finally {
                if (repository != null) {
                    repository.closeSession();
                }
            }
        }

        protected SVNRepository getRepository(SVNURL repoURL) throws SVNException {
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)repoURL);
            ISVNAuthenticationManager sam = SVNWCUtil.createDefaultAuthenticationManager();
            sam.setAuthenticationProvider(this.createAuthenticationProvider());
            repository.setAuthenticationManager(sam);
            return repository;
        }

        public void doSvnLocalLocationCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String v = Util.nullify((String)this.request.getParameter("value"));
                    if (v == null) {
                        this.ok();
                        return;
                    }
                    if ((v = v.trim()).startsWith("/") || v.startsWith("\\") || v.startsWith("..") || v.matches("^[A-Za-z]:")) {
                        this.error("absolute path is not allowed");
                    }
                    this.ok();
                }
            }.process();
        }

        static {
            new Initializer();
        }

        private final class RemotableSVNAuthenticationProviderImpl
        implements RemotableSVNAuthenticationProvider,
        Serializable {
            private RemotableSVNAuthenticationProviderImpl() {
            }

            @Override
            public Credential getCredential(String realm) {
                LOGGER.fine(String.format("getCredential(%s)=>%s", realm, DescriptorImpl.this.credentials.get(realm)));
                return (Credential)DescriptorImpl.this.credentials.get(realm);
            }

            private Object writeReplace() {
                return Channel.current().export(RemotableSVNAuthenticationProvider.class, (Object)this);
            }
        }

        private static final class SVNAuthenticationProviderImpl
        implements ISVNAuthenticationProvider,
        Serializable {
            private static final long serialVersionUID = 1L;
            private final RemotableSVNAuthenticationProvider source;

            public SVNAuthenticationProviderImpl(RemotableSVNAuthenticationProvider source) {
                this.source = source;
            }

            public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
                Credential cred = this.source.getCredential(realm);
                LOGGER.fine(String.format("requestClientAuthentication(%s,%s,%s)=>%s", kind, url, realm, cred));
                try {
                    SVNAuthentication auth = null;
                    if (cred != null) {
                        auth = cred.createSVNAuthentication(kind);
                    }
                    if (auth == null && "svn.username".equals(kind)) {
                        return new SVNUserNameAuthentication("", false);
                    }
                    return auth;
                }
                catch (SVNException e) {
                    logger.log(Level.SEVERE, "Failed to authorize", e);
                    throw new RuntimeException("Failed to authorize", e);
                }
            }

            public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
                return 1;
            }
        }

        private static final class SslClientCertificateCredential
        extends Credential {
            private final String password;
            private final File certificate;

            public SslClientCertificateCredential(File certificate, String password) {
                this.certificate = certificate;
                this.password = Scrambler.scramble((String)password);
            }

            @Override
            SVNAuthentication createSVNAuthentication(String kind) {
                if (kind.equals("svn.ssl.client-passphrase")) {
                    try {
                        Secret certificateSecret = Secret.fromString((String)new String(Base64.encode((byte[])FileUtils.readFileToByteArray((File)this.certificate))));
                        SVNSSLAuthentication authentication = SVNSSLAuthentication.newInstance((byte[])Base64.decode((char[])certificateSecret.getPlainText().toCharArray()), (char[])Scrambler.descramble((String)this.password).toCharArray(), (boolean)false, null, (boolean)false);
                        return authentication;
                    }
                    catch (IOException e) {
                        throw new Error(e);
                    }
                }
                return null;
            }
        }

        private static final class SshPublicKeyCredential
        extends Credential {
            private final String userName;
            private final String passphrase;
            private final String id;

            public SshPublicKeyCredential(String userName, String passphrase, File keyFile) throws SVNException {
                this.userName = userName;
                this.passphrase = Scrambler.scramble((String)passphrase);
                Random r = new Random();
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < 16; ++i) {
                    buf.append(Integer.toHexString(r.nextInt(16)));
                }
                this.id = buf.toString();
                try {
                    FileUtils.copyFile((File)keyFile, (File)this.getKeyFile());
                }
                catch (IOException e) {
                    throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"Unable to save private key"), (Throwable)e);
                }
            }

            private File getKeyFile() {
                File dir = new File(Hudson.getInstance().getRootDir(), "subversion-credentials");
                if (dir.mkdirs()) {
                    try {
                        Chmod chmod = new Chmod();
                        chmod.setProject(new Project());
                        chmod.setFile(dir);
                        chmod.setPerm("600");
                        chmod.execute();
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.WARNING, "Failed to set directory permission of " + dir, e);
                    }
                }
                return new File(dir, this.id);
            }

            SVNSSHAuthentication createSVNAuthentication(String kind) throws SVNException {
                if (kind.equals("svn.ssh")) {
                    try {
                        Channel channel = Channel.current();
                        String privateKey = channel != null ? (String)channel.call((Callable)new Callable<String, IOException>(){

                            public String call() throws IOException {
                                return FileUtils.readFileToString((File)SshPublicKeyCredential.this.getKeyFile(), (String)"iso-8859-1");
                            }

                            public void checkRoles(RoleChecker roleChecker) throws SecurityException {
                                roleChecker.check((RoleSensitive)this, Roles.SLAVE);
                            }
                        }) : FileUtils.readFileToString((File)this.getKeyFile(), (String)"iso-8859-1");
                        return new SVNSSHAuthentication(this.userName, privateKey.toCharArray(), Scrambler.descramble((String)this.passphrase), -1, false);
                    }
                    catch (IOException e) {
                        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"Unable to load private key"), (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"Unable to load private key"), (Throwable)e);
                    }
                }
                return null;
            }
        }

        private static final class PasswordCredential
        extends Credential {
            private final String userName;
            private final String password;

            public PasswordCredential(String userName, String password) {
                this.userName = userName;
                this.password = Scrambler.scramble((String)password);
            }

            @Override
            SVNAuthentication createSVNAuthentication(String kind) {
                if (kind.equals("svn.ssh")) {
                    return new SVNSSHAuthentication(this.userName, Scrambler.descramble((String)this.password), -1, false);
                }
                return new SVNPasswordAuthentication(this.userName, Scrambler.descramble((String)this.password), false);
            }
        }

        private static abstract class Credential
        implements Serializable {
            private Credential() {
            }

            abstract SVNAuthentication createSVNAuthentication(String var1) throws SVNException;
        }

        private static interface RemotableSVNAuthenticationProvider {
            public Credential getCredential(String var1);
        }
    }
}

