/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.ui;

import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ProminentProjectAction;
import hudson.model.StringParameterValue;
import hudson.model.TopLevelItem;
import hudson.plugins.svn_partial_release_mgr.api.constants.Constants;
import hudson.plugins.svn_partial_release_mgr.api.constants.PluginUtil;
import hudson.plugins.svn_partial_release_mgr.api.model.AllIssueRevisionsInfo;
import hudson.plugins.svn_partial_release_mgr.ui.JobPropertyImpl;
import hudson.scm.SubversionReleaseSCM;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ProjectReleaseAction
implements ProminentProjectAction {
    private AbstractProject<?, ?> owner;
    private JobPropertyImpl property;

    public ProjectReleaseAction(AbstractProject<?, ?> owner, JobPropertyImpl property) {
        this.owner = owner;
        this.property = property;
    }

    public String getUrlName() {
        return "releases";
    }

    private SubversionReleaseSCM.ModuleLocation getLocation() {
        return this.getSubversion().getLocation();
    }

    public AllIssueRevisionsInfo getAllIssueRevisionsInfo() throws IOException {
        FilePath workspaceDir = Jenkins.getInstance().getWorkspaceFor((TopLevelItem)this.owner.getRootProject());
        return this.getSubversion().getIssueRevisionsInfo(workspaceDir.getRemote());
    }

    public String getDisplayName() {
        return "Svn-Partial Release Manager";
    }

    public String getIconFileName() {
        return "clipboard.gif";
    }

    public AbstractProject<?, ?> getOwner() {
        return this.owner;
    }

    public void setOwner(AbstractProject<?, ?> owner) {
        this.owner = owner;
    }

    public JobPropertyImpl getProperty() {
        return this.property;
    }

    public void setProperty(JobPropertyImpl property) {
        this.property = property;
    }

    public SubversionReleaseSCM getSubversion() {
        return (SubversionReleaseSCM)this.owner.getScm();
    }

    public boolean hasTagSource() throws IOException {
        FilePath workspaceDir = Jenkins.getInstance().getWorkspaceFor((TopLevelItem)this.owner.getRootProject());
        return this.getSubversion().hasTagBackupSource(workspaceDir.getRemote());
    }

    public void doBuild(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        Object[] selectedRevisionIds = req.getParameterValues("includeInPatch");
        String toStringRevisionIds = StringUtils.join((Object[])selectedRevisionIds, (String)",");
        List<ParameterValue> buildParameters = new ArrayList<ParameterValue>();
        PluginUtil.setJobStarted();
        System.setProperty("hudson.model.ParametersAction.keepUndefinedParameters", "true");
        buildParameters.add((ParameterValue)new StringParameterValue("RELEASE_REVISIONS", toStringRevisionIds));
        buildParameters = this.getAdditionalParameters(buildParameters, req);
        this.owner.makeDisabled(false);
        this.owner.scheduleBuild(0, (Cause)new Cause.UserCause(), new Action[]{new ParametersAction(buildParameters)});
        rsp.sendRedirect(req.getContextPath());
    }

    protected List<ParameterValue> getAdditionalParameters(List<ParameterValue> buildParameters, StaplerRequest req) {
        for (Map.Entry<String, String> entry : Constants.additionalUserInputParameters.entrySet()) {
            String parameterName = entry.getValue();
            String parameterValue = req.getParameter(parameterName);
            if (StringUtils.isBlank((String)parameterValue)) continue;
            String environmentVariable = entry.getKey();
            buildParameters.add((ParameterValue)new StringParameterValue(environmentVariable, parameterValue));
        }
        return buildParameters;
    }
}

