/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.ui;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.svn_partial_release_mgr.api.constants.PluginUtil;
import hudson.plugins.svn_partial_release_mgr.ui.ProjectReleaseAction;
import hudson.scm.SubversionReleaseSCM;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public final class JobPropertyImpl
extends JobProperty<AbstractProject<?, ?>> {
    @DataBoundConstructor
    public JobPropertyImpl() {
    }

    public Collection<? extends Action> getJobActions(AbstractProject<?, ?> job) {
        if (SubversionReleaseSCM.class.equals(job.getScm().getClass())) {
            this.checkDisableJob(job);
            return Collections.singletonList(new ProjectReleaseAction(job, this));
        }
        return super.getJobActions(job);
    }

    protected void checkDisableJob(AbstractProject<?, ?> job) {
        boolean isStartedBuild = PluginUtil.isJobStarted();
        if (isStartedBuild) {
            return;
        }
        try {
            job.makeDisabled(true);
        }
        catch (IOException e) {
            System.out.println("Could not disable job....." + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public DescriptorImpl() {
            super(JobPropertyImpl.class);
            this.load();
        }

        public String getDisplayName() {
            return "Subversion Releases";
        }
    }
}

