/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.impl.functions.initview;

import hudson.plugins.svn_partial_release_mgr.api.constants.Constants;
import hudson.plugins.svn_partial_release_mgr.api.constants.PluginUtil;
import hudson.plugins.svn_partial_release_mgr.api.functions.initview.Function3PrevDeploymentsCollector;
import hudson.plugins.svn_partial_release_mgr.api.model.JobConfigurationUserInput;
import hudson.plugins.svn_partial_release_mgr.api.model.TagDeploymentInfo;
import hudson.plugins.svn_partial_release_mgr.api.model.redeploy.TagPreviousDeploymentsInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Function3PrevDeploymentsCollectorImpl
implements Function3PrevDeploymentsCollector {
    @Override
    public TagPreviousDeploymentsInfo resolveTagExistingDeploymentsInfo(JobConfigurationUserInput releaseInput, String workspaceRootPath) throws IOException {
        List<TagDeploymentInfo> existingDeployments = this.resolveTagExistingDeployments(releaseInput, workspaceRootPath);
        return new TagPreviousDeploymentsInfo(existingDeployments);
    }

    protected List<TagDeploymentInfo> resolveTagExistingDeployments(JobConfigurationUserInput releaseInput, String workspaceRootPath) throws IOException {
        String deploymentsDirPath = PluginUtil.getWorkspaceDeploymentPath(workspaceRootPath, releaseInput.getTagName());
        File deploymentsDir = new File(deploymentsDirPath);
        if (!deploymentsDir.exists()) {
            return null;
        }
        List<File> allJsonFiles = PluginUtil.getAllFilesInAllSubDirectories(deploymentsDir, new Constants.XmlFileFilter());
        if (allJsonFiles == null || allJsonFiles.isEmpty()) {
            return null;
        }
        ArrayList<TagDeploymentInfo> existingDeployments = new ArrayList<TagDeploymentInfo>(allJsonFiles.size());
        for (File jsonFile : allJsonFiles) {
            TagDeploymentInfo tagDeploymentInfo = TagDeploymentInfo.readFromFile(jsonFile);
            existingDeployments.add(tagDeploymentInfo);
        }
        return existingDeployments;
    }
}

