/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.impl.functions.initview;

import hudson.plugins.svn_partial_release_mgr.api.constants.PluginUtil;
import hudson.plugins.svn_partial_release_mgr.api.functions.initview.Function1TagRevisionResolver;
import hudson.plugins.svn_partial_release_mgr.api.model.JobConfigurationUserInput;
import hudson.scm.SubversionReleaseSCM;
import java.io.IOException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;

public class Function1TagRevisionResolverImpl
implements Function1TagRevisionResolver {
    @Override
    public long resolveTagNameRevision(JobConfigurationUserInput releaseInput) throws IOException {
        try {
            SVNURL svnurl = releaseInput.getLocation().getSVNURL();
            SVNURL tagURL = SVNURL.parseURIDecoded((String)PluginUtil.pathToTag(svnurl, releaseInput.getTagName()));
            SVNRepository repository = SubversionReleaseSCM.createSvnClientManager().createRepository(tagURL, false);
            SVNDirEntry entry = repository.info(".", -1L);
            long latestRevisionOfTag = entry.getRevision();
            System.out.println("LATEST_REVISION [" + latestRevisionOfTag + "] of [" + tagURL.toString() + "]");
            return latestRevisionOfTag;
        }
        catch (SVNException e) {
            throw new IOException("Error while trying to get the tag [" + releaseInput.getTagName() + "] revision number !!" + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

