/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.impl.functions.build;

import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.svn_partial_release_mgr.api.constants.PluginUtil;
import hudson.plugins.svn_partial_release_mgr.api.functions.build.Function5BackupDeploymentInfoFile;
import hudson.plugins.svn_partial_release_mgr.api.model.ReleaseDeployInput;
import hudson.plugins.svn_partial_release_mgr.api.model.TagDeploymentInfo;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.w3c.dom.Document;

public class Function5BackupDeploymentInfoFileImpl
implements Function5BackupDeploymentInfoFile {
    @Override
    public void storeTheDeploymentInfoToBuildNumberDirectory(AbstractBuild<?, ?> build, TaskListener listener, ReleaseDeployInput releaseDeployInput) throws IOException {
        String tagName = releaseDeployInput.getReleaseInput().getTagName();
        String deploymentDate = DateFormatUtils.format((Date)build.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
        TagDeploymentInfo tagDeploymentInfo = new TagDeploymentInfo(tagName, deploymentDate, releaseDeployInput.getUserInput());
        File buildDeploymentDir = new File(build.getRootDir(), "deployments");
        FileUtils.forceMkdir((File)buildDeploymentDir);
        String path = buildDeploymentDir.getAbsolutePath() + "/" + "deploymentInfo.xml";
        path = FilenameUtils.separatorsToUnix((String)path);
        PluginUtil.log(listener, "STORING DEPLOYMENT INFO XML FILE [" + path + "]..........");
        try {
            Document xmlDocument = tagDeploymentInfo.toXml();
            PluginUtil.toFile(xmlDocument, new File(path));
        }
        catch (Exception e) {
            throw new IOException("Error saving the XML file!!" + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

