/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.impl.functions.build;

import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.svn_partial_release_mgr.api.constants.PluginUtil;
import hudson.plugins.svn_partial_release_mgr.api.functions.build.Function4BackupReleaseFilesAsSrcPatches;
import hudson.plugins.svn_partial_release_mgr.api.model.ReleaseDeployInput;
import hudson.plugins.svn_partial_release_mgr.api.model.UserInput;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class Function4BackupReleaseFilesAsSrcPatchesImpl
implements Function4BackupReleaseFilesAsSrcPatches {
    @Override
    public void copyToBuildNumberDirectoryTheFileSources(File ws, AbstractBuild<?, ?> build, ReleaseDeployInput releaseDeployInput, TaskListener listener) throws IOException {
        UserInput userInput = releaseDeployInput.getUserInput();
        if (!PluginUtil.isGeneratePartialPatch(userInput)) {
            return;
        }
        PluginUtil.log(listener, "CREATING THE SOURCE PATCHES ............");
        Map<String, Long> releaseFiles = releaseDeployInput.getReleaseFiles();
        if (releaseFiles == null || releaseFiles.isEmpty()) {
            return;
        }
        File buildDeploymentDir = new File(build.getRootDir(), "deployments");
        boolean includePreviousDeploymentsFiles = PluginUtil.isIncludePreviousPatchSources(userInput);
        Map<String, Long> previousDeploymentFiles = includePreviousDeploymentsFiles ? releaseDeployInput.getFilesToReDeploy() : null;
        this.copyFullPatchSrc(ws, buildDeploymentDir, releaseFiles, previousDeploymentFiles);
        if (PluginUtil.isGeneratePatchForEveryIssue(userInput)) {
            this.copyPerIssuePatchSrc(ws, buildDeploymentDir, releaseDeployInput);
        }
    }

    protected void copyFullPatchSrc(File ws, File buildDeploymentDir, Map<String, Long> releaseFiles, Map<String, Long> previousDeploymentFiles) throws IOException {
        File buildFullPatchDir = new File(buildDeploymentDir, "full_patch");
        this.copyFilesIntoTheRootDir(ws, buildFullPatchDir, releaseFiles);
        this.copyFilesIntoTheRootDir(ws, buildFullPatchDir, previousDeploymentFiles);
    }

    protected void copyPerIssuePatchSrc(File ws, File buildDeploymentDir, ReleaseDeployInput releaseDeployInput) throws IOException {
        File buildPerIssuePatchDir = new File(buildDeploymentDir, "issues_patch");
        Map<String, Map<String, Long>> issueReleaseFiles = releaseDeployInput.getIssueReleaseFiles();
        if (issueReleaseFiles == null || issueReleaseFiles.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, Long>> entry : issueReleaseFiles.entrySet()) {
            String issueNumber = entry.getKey();
            Map<String, Long> filesForIssue = entry.getValue();
            File issuePatchDir = new File(buildPerIssuePatchDir, issueNumber);
            this.copyFilesIntoTheRootDir(ws, issuePatchDir, filesForIssue);
        }
    }

    protected void copyFilesIntoTheRootDir(File ws, File rootDir, Map<String, Long> releaseFiles) throws IOException {
        if (releaseFiles == null || releaseFiles.isEmpty()) {
            return;
        }
        File buildFullSrcPatchDir = new File(rootDir, "patch-src");
        for (Map.Entry<String, Long> entry : releaseFiles.entrySet()) {
            String relativePath = entry.getKey();
            long revisionNumber = entry.getValue();
            String localLocation = "checkout/revisions/" + revisionNumber;
            String relativeLocal = localLocation + relativePath;
            File localFile = new File(ws, relativeLocal = FilenameUtils.separatorsToUnix((String)relativeLocal));
            if (localFile.isDirectory()) continue;
            File targetFileDeployment = new File(buildFullSrcPatchDir, relativePath);
            FileUtils.copyFile((File)localFile, (File)targetFileDeployment);
        }
    }
}

