/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.impl.functions.build;

import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.svn_partial_release_mgr.api.constants.PluginUtil;
import hudson.plugins.svn_partial_release_mgr.api.functions.build.Function3GetReleaseFileSources;
import hudson.plugins.svn_partial_release_mgr.api.model.ReleaseDeployInput;
import hudson.scm.SubversionReleaseSCM;
import hudson.util.IOException2;
import hudson.util.StreamCopyThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class Function3GetReleaseFileSourcesImpl
implements Function3GetReleaseFileSources {
    @Override
    public void checkoutAndCopyToBuildDirectoryTheFileSource(File ws, AbstractBuild<?, ?> build, SVNUpdateClient svnClient, File buildRootDir, ReleaseDeployInput releaseDeployInput, TaskListener listener) throws IOException {
        this.checkoutAndCopyToBuildDirectoryTheFileSource(ws, build, svnClient, buildRootDir, releaseDeployInput, listener, releaseDeployInput.getReleaseFiles(), "RELEASE");
    }

    protected void checkoutAndCopyToBuildDirectoryTheFileSource(File ws, AbstractBuild<?, ?> build, SVNUpdateClient svnClient, File buildRootDir, ReleaseDeployInput releaseDeployInput, TaskListener listener, Map<String, Long> filesToUpdate, String message) throws IOException {
        PluginUtil.log(listener, "GETTING THE " + message + " FILE SOURCES ( SVN or BACKUP )............");
        this.checkoutTheReleaseFilesSources(ws, releaseDeployInput, listener, svnClient, filesToUpdate);
        PluginUtil.log(listener, "COPYING THE " + message + " FILES INTO THE BUILD DIRECTORY............");
        this.copyTheSourceIntoTheBuildDirectory(buildRootDir, ws, listener, filesToUpdate);
    }

    protected void checkoutTheReleaseFilesSources(File ws, ReleaseDeployInput releaseDeployInput, TaskListener listener, SVNUpdateClient svnClient, Map<String, Long> filesToUpdate) throws IOException {
        try {
            this.doGetTheFilesInTheMaxRevisionInSvn(ws, releaseDeployInput, listener, svnClient, filesToUpdate);
        }
        catch (SVNException e) {
            PluginUtil.log(listener, "Could not revert the files!!" + ExceptionUtils.getStackTrace((Throwable)e));
            throw new IOException("Could not revert the files!!" + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    protected void doGetTheFilesInTheMaxRevisionInSvn(File ws, ReleaseDeployInput releaseDeployInput, TaskListener listener, SVNUpdateClient svnClient, Map<String, Long> filesToUpdate) throws IOException, SVNException {
        if (filesToUpdate == null || filesToUpdate.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Long> entry : filesToUpdate.entrySet()) {
            String relativePath = entry.getKey();
            long revisionNumber = entry.getValue();
            String localLocation = "checkout/revisions/" + revisionNumber;
            String relativeLocal = localLocation + relativePath;
            File localFile = new File(ws, relativeLocal = FilenameUtils.separatorsToUnix((String)relativeLocal));
            if (localFile.exists()) {
                PluginUtil.log(listener, "File [" + relativePath + "] [r=" + revisionNumber + "] exists in backup.....");
                continue;
            }
            PluginUtil.log(listener, "Will update file ......[" + relativePath + "] to revision [" + revisionNumber + "] at local path [" + relativeLocal + "]");
            String svnRemoteLocation = releaseDeployInput.getReleaseInput().getLocation().remote;
            String remoteForFile = FilenameUtils.separatorsToUnix((String)(svnRemoteLocation + relativePath));
            SubversionReleaseSCM.ModuleLocation fileLocation = new SubversionReleaseSCM.ModuleLocation(remoteForFile, relativeLocal);
            SVNRevision revision = SVNRevision.create((long)revisionNumber);
            this.doExportTheFile(ws, listener, revision, svnClient, fileLocation);
        }
    }

    protected void doExportTheFile(File ws, TaskListener listener, SVNRevision fileRevisionNumber, SVNUpdateClient svnClient, SubversionReleaseSCM.ModuleLocation fileLocation) throws IOException {
        File local = new File(ws, fileLocation.local);
        PipedOutputStream pos = new PipedOutputStream();
        StreamCopyThread sct = new StreamCopyThread("svn log copier", (InputStream)new PipedInputStream(pos), (OutputStream)listener.getLogger());
        sct.start();
        try {
            PluginUtil.log(listener, "Checking out[" + fileLocation.remote + "] to [" + fileLocation.local + "]");
            svnClient.doExport(fileLocation.getSVNURL(), local.getCanonicalFile(), fileLocation.getRevision(fileRevisionNumber), fileLocation.getRevision(fileRevisionNumber), null, true, SVNDepth.INFINITY);
        }
        catch (SVNException e) {
            e.printStackTrace(listener.error("Failed to check out " + fileLocation.remote));
        }
        pos.close();
        try {
            sct.join();
        }
        catch (InterruptedException e) {
            throw new IOException2("interrupted", (Throwable)e);
        }
    }

    protected void copyTheSourceIntoTheBuildDirectory(File buildRootDir, File ws, TaskListener listener, Map<String, Long> filesToUpdate) throws IOException {
        if (filesToUpdate == null || filesToUpdate.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Long> entry : filesToUpdate.entrySet()) {
            String relativePath = entry.getKey();
            long revisionNumber = entry.getValue();
            String localLocation = "checkout/revisions/" + revisionNumber;
            String relativeLocal = localLocation + relativePath;
            File localFile = new File(ws, relativeLocal = FilenameUtils.separatorsToUnix((String)relativeLocal));
            if (localFile.isDirectory()) continue;
            File targetFile = new File(buildRootDir, relativePath);
            PluginUtil.log(listener, "Copying the file [" + localFile + "] to [" + targetFile + "] ..........");
            if (targetFile.exists()) {
                targetFile.delete();
            }
            FileUtils.copyFile((File)localFile, (File)targetFile);
        }
    }
}

