/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.impl.functions.build;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.svn_partial_release_mgr.api.constants.PluginUtil;
import hudson.plugins.svn_partial_release_mgr.api.functions.build.Function1GetTagSource;
import hudson.plugins.svn_partial_release_mgr.api.model.ReleaseDeployInput;
import hudson.scm.SubversionEventHandlerImpl;
import hudson.scm.SubversionReleaseSCM;
import hudson.scm.subversion.Messages;
import hudson.util.IOException2;
import hudson.util.StreamCopyThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class Function1GetTagSourceImpl
implements Function1GetTagSource {
    @Override
    public void getTheTagSourceIntoTheBuildDirectory(File ws, AbstractBuild<?, ?> build, SVNClientManager manager, SVNUpdateClient svnClient, TaskListener listener, ReleaseDeployInput releaseDeployInput) throws IOException {
        SubversionReleaseSCM.ModuleLocation location = releaseDeployInput.getReleaseInput().getLocation();
        String tagName = releaseDeployInput.getReleaseInput().getTagName();
        File buildDir = new File(ws, location.local);
        String backupTagSourceLocation = PluginUtil.getFullPathToTagBackupSource(ws.getAbsolutePath(), tagName);
        File backupDir = new File(backupTagSourceLocation);
        if (this.getBackupFiles(buildDir, backupDir, listener)) {
            return;
        }
        this.doCheckoutTheTag(ws, build, manager, svnClient, listener, releaseDeployInput);
        this.doBackUpTheTagSources(buildDir, backupDir, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getBackupFiles(File buildDir, File backupDir, TaskListener listener) throws IOException {
        if (!backupDir.exists()) {
            return false;
        }
        long t1 = System.currentTimeMillis();
        try {
            PluginUtil.log(listener, "Will copy the files from already checked out folder [" + backupDir.getAbsolutePath() + "]..........");
            this.copyTheBackupSource(backupDir, buildDir, listener);
        }
        finally {
            long t2 = System.currentTimeMillis();
            PluginUtil.log(listener, "Copy took [" + (t2 - t1) + "ms] ################### ");
        }
        return true;
    }

    protected void copyTheBackupSource(File backupDir, File buildDir, TaskListener listener) throws IOException {
        FileUtils.copyDirectory((File)backupDir, (File)buildDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBackUpTheTagSources(File svnCheckoutDir, File backupDir, TaskListener listener) throws IOException {
        FileUtils.forceMkdir((File)backupDir);
        long t1 = System.currentTimeMillis();
        try {
            PluginUtil.log(listener, "Will backup the tag source files into [" + backupDir.getAbsolutePath() + "]..........");
            FileUtils.copyDirectory((File)svnCheckoutDir, (File)backupDir);
        }
        finally {
            long t2 = System.currentTimeMillis();
            PluginUtil.log(listener, "Backup copy took [" + (t2 - t1) + "ms] ################### ");
        }
    }

    protected SubversionReleaseSCM.ModuleLocation toTagLocation(ReleaseDeployInput releaseDeployInput) {
        String remote;
        String tagName = releaseDeployInput.getReleaseInput().getTagName();
        SubversionReleaseSCM.ModuleLocation location = releaseDeployInput.getReleaseInput().getLocation();
        try {
            remote = PluginUtil.pathToTag(location.getSVNURL(), tagName);
        }
        catch (SVNException e) {
            remote = PluginUtil.pathToTagWithSvnUrl(location.getURL(), tagName);
        }
        return new SubversionReleaseSCM.ModuleLocation(Util.removeTrailingSlash((String)remote), StringUtils.trimToNull((String)location.local));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCheckoutTheTag(File ws, AbstractBuild<?, ?> build, SVNClientManager manager, SVNUpdateClient svnClient, TaskListener listener, ReleaseDeployInput releaseDeployInput) throws IOException {
        long t1 = System.currentTimeMillis();
        String tagName = releaseDeployInput.getReleaseInput().getTagName();
        PluginUtil.log(listener, "Will check out the tag [" + tagName + "]..........");
        Date timestamp = build.getTimestamp().getTime();
        try {
            SubversionReleaseSCM.ModuleLocation tagLocation = this.toTagLocation(releaseDeployInput);
            SVNRevision revision = SVNRevision.create((Date)timestamp);
            this.doCheckoutTheTag(ws, revision, manager, svnClient, listener, tagLocation);
        }
        finally {
            long t2 = System.currentTimeMillis();
            PluginUtil.log(listener, "Check out took [" + (t2 - t1) + "ms] ################### ");
        }
    }

    protected void doCheckoutTheTag(File ws, SVNRevision revision, SVNClientManager manager, SVNUpdateClient svnClient, TaskListener listener, SubversionReleaseSCM.ModuleLocation rootLocation) throws IOException {
        File local = new File(ws, rootLocation.local);
        PipedOutputStream pos = new PipedOutputStream();
        StreamCopyThread sct = new StreamCopyThread("svn log copier", (InputStream)new PipedInputStream(pos), (OutputStream)listener.getLogger());
        sct.start();
        try {
            PluginUtil.log(listener, "Checking out [" + rootLocation.remote + "] to [" + rootLocation.local + "]");
            svnClient.setEventHandler((ISVNEventHandler)new SubversionEventHandlerImpl(new PrintStream(pos), local));
            svnClient.doCheckout(rootLocation.getSVNURL(), local.getCanonicalFile(), rootLocation.getRevision(revision), rootLocation.getRevision(revision), true);
        }
        catch (SVNException e) {
            e.printStackTrace(listener.error("Failed to check out " + rootLocation.remote));
            return;
        }
        pos.close();
        try {
            sct.join();
        }
        catch (InterruptedException e) {
            throw new IOException2("interrupted", (Throwable)e);
        }
        try {
            SVNDirEntry dir = manager.createRepository(rootLocation.getSVNURL(), true).info("/", -1L);
            if (dir != null && dir.getDate().after(new Date())) {
                listener.getLogger().println(Messages.SubversionSCM_ClockOutOfSync());
            }
        }
        catch (SVNException e) {
            listener.getLogger().println("Failed to estimate the remote time stamp" + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

