/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.impl.functions.build;

import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.svn_partial_release_mgr.api.constants.Constants;
import hudson.plugins.svn_partial_release_mgr.api.constants.PluginUtil;
import hudson.plugins.svn_partial_release_mgr.api.functions.build.Function0GetReleaseDeployInput;
import hudson.plugins.svn_partial_release_mgr.api.model.AllIssueRevisionsInfo;
import hudson.plugins.svn_partial_release_mgr.api.model.IssueInfo;
import hudson.plugins.svn_partial_release_mgr.api.model.JobConfigurationUserInput;
import hudson.plugins.svn_partial_release_mgr.api.model.ReleaseDeployInput;
import hudson.plugins.svn_partial_release_mgr.api.model.Revision;
import hudson.plugins.svn_partial_release_mgr.api.model.UserInput;
import hudson.scm.SubversionReleaseSCM;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.tmatesoft.svn.core.SVNLogEntryPath;

public class Function0GetReleaseDeployInputImpl
implements Function0GetReleaseDeployInput {
    @Override
    public ReleaseDeployInput toReleaseDeployInput(AbstractBuild<?, ?> build, TaskListener listener, JobConfigurationUserInput releaseInput, AllIssueRevisionsInfo allIssueRevisionsInfo) throws IOException, InterruptedException {
        UserInput userInput = this.createUserInputFromEnvParameters(build, listener);
        long tagRevision = allIssueRevisionsInfo.getTagRevisionNumber();
        SubversionReleaseSCM.ModuleLocation location = releaseInput.getLocation();
        Set<Long> includeRevisionsIntoTheRelease = userInput.getIncludedRevisionsInRelease();
        Map<String, FileRevisionsInfo> fileRevisionsInfoMap = this.markAllFileRevisions(location, allIssueRevisionsInfo, includeRevisionsIntoTheRelease);
        Map<String, Long> releaseFiles = this.resolveIncludedFileRevisions(fileRevisionsInfoMap, tagRevision);
        Map<String, Map<String, Long>> issueReleaseFiles = this.getIssueReleaseFiles(allIssueRevisionsInfo, releaseFiles);
        Map<String, Long> filesToReDeploy = null;
        Set<Long> tagPreviouslyDeployedRevisions = allIssueRevisionsInfo.getTagPreviouslyDeployedRevisions();
        if (tagPreviouslyDeployedRevisions != null && !tagPreviouslyDeployedRevisions.isEmpty()) {
            filesToReDeploy = this.resolveIncludedFilesRevisionNumber(location, tagRevision, allIssueRevisionsInfo, tagPreviouslyDeployedRevisions);
        }
        String conflictWarnings = this.resolveConflictsWarnings(fileRevisionsInfoMap, allIssueRevisionsInfo, releaseFiles, includeRevisionsIntoTheRelease, tagPreviouslyDeployedRevisions);
        this.printConflicts(listener, conflictWarnings);
        return new ReleaseDeployInput(releaseInput, userInput, issueReleaseFiles, releaseFiles, filesToReDeploy, conflictWarnings);
    }

    protected void printConflicts(TaskListener listener, String conflictWarnings) {
        if (!StringUtils.isBlank((String)conflictWarnings)) {
            PluginUtil.log(listener, "###################### CONFLICT WARNINGS START #################");
            listener.getLogger().println();
            listener.getLogger().println(conflictWarnings);
            listener.getLogger().println();
            PluginUtil.log(listener, "###################### CONFLICT WARNINGS END   #################");
        } else {
            PluginUtil.log(listener, " ###################### NO CONFLICTS ####################");
        }
    }

    protected UserInput createUserInputFromEnvParameters(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        String releaseVersions = (String)build.getEnvironment(listener).get((Object)"RELEASE_REVISIONS");
        Set<Long> includeRevisionsIntoTheRelease = this.toRevisionIdsSet(releaseVersions);
        if (includeRevisionsIntoTheRelease == null || includeRevisionsIntoTheRelease.isEmpty()) {
            throw new IOException("No revisions have been checked for deployment!!!");
        }
        LinkedHashMap<String, String> additionalParameters = new LinkedHashMap<String, String>();
        for (String environmentVariable : Constants.additionalUserInputParameters.keySet()) {
            String environmentVariableValue = (String)build.getEnvironment(listener).get((Object)environmentVariable);
            additionalParameters.put(environmentVariable, environmentVariableValue);
        }
        return new UserInput(includeRevisionsIntoTheRelease, additionalParameters);
    }

    protected Set<Long> toRevisionIdsSet(String revisionIdsAsString) {
        String[] revisionIdsArray = StringUtils.split((String)revisionIdsAsString, (String)",");
        TreeSet<Long> revisionIds = new TreeSet<Long>();
        for (String revisionId : revisionIdsArray) {
            long id = NumberUtils.toLong((String)revisionId);
            if (id <= 0L) continue;
            revisionIds.add(id);
        }
        return revisionIds;
    }

    protected Map<String, Long> resolveIncludedFilesRevisionNumber(SubversionReleaseSCM.ModuleLocation location, long latestTagRevision, AllIssueRevisionsInfo allIssueRevisionsInfo, Set<Long> includedRevisionsInRelease) throws IOException {
        Map<String, FileRevisionsInfo> fileRevisionsInfoMap = this.markAllFileRevisions(location, allIssueRevisionsInfo, includedRevisionsInRelease);
        return this.resolveIncludedFileRevisions(fileRevisionsInfoMap, latestTagRevision);
    }

    protected Map<String, Map<String, Long>> getIssueReleaseFiles(AllIssueRevisionsInfo allIssueRevisionsInfo, Map<String, Long> includedFilesInRelease) throws IOException {
        Collection<IssueInfo> issueInfoCollection = allIssueRevisionsInfo.getIssues();
        if (issueInfoCollection == null || issueInfoCollection.isEmpty()) {
            return null;
        }
        Map<Long, Set<String>> mapByRevisions = this.reverseMap(includedFilesInRelease);
        if (mapByRevisions == null || mapByRevisions.isEmpty()) {
            return null;
        }
        Map<String, Map<String, Long>> issueFiles = null;
        for (IssueInfo issueInfo : issueInfoCollection) {
            issueFiles = this.updateFilesForIssue(issueFiles, mapByRevisions, issueInfo);
        }
        return issueFiles;
    }

    protected Map<String, Map<String, Long>> updateFilesForIssue(Map<String, Map<String, Long>> issueFiles, Map<Long, Set<String>> mapByRevisions, IssueInfo issueInfo) {
        Collection<Long> issueRevisionIds = issueInfo.getRevisionIds();
        for (Long issueRevisionId : issueRevisionIds) {
            Set<String> revisionFiles = mapByRevisions.get(issueRevisionId);
            if (revisionFiles == null || revisionFiles.isEmpty()) continue;
            String issueNumber = issueInfo.getNumber();
            for (String revisionFile : revisionFiles) {
                issueFiles = PluginUtil.putCheckedObjectInInnerMap(issueFiles, issueNumber, revisionFile, issueRevisionId);
            }
        }
        return issueFiles;
    }

    protected Map<Long, Set<String>> reverseMap(Map<String, Long> includedFilesInRelease) {
        if (includedFilesInRelease == null || includedFilesInRelease.isEmpty()) {
            return null;
        }
        Map<Long, Set<String>> mapByRevisions = new HashMap<Long, Set<String>>(includedFilesInRelease.size());
        for (Map.Entry<String, Long> entry : includedFilesInRelease.entrySet()) {
            String filePath = entry.getKey();
            Long revisionId = entry.getValue();
            mapByRevisions = PluginUtil.putCheckedObjectInInnerSet(mapByRevisions, revisionId, filePath);
        }
        return mapByRevisions;
    }

    protected Map<String, FileRevisionsInfo> markAllFileRevisions(SubversionReleaseSCM.ModuleLocation location, AllIssueRevisionsInfo allIssueRevisionsInfo, Set<Long> includedRevisionsInRelease) {
        Map<String, FileRevisionsInfo> fileRevisions = new LinkedHashMap<String, FileRevisionsInfo>();
        Collection<Revision> revisions = allIssueRevisionsInfo.getRevisions();
        for (Revision revision : revisions) {
            boolean isRevisionIncluded = includedRevisionsInRelease != null && includedRevisionsInRelease.contains(revision.getRevision());
            fileRevisions = this.handleRevision(fileRevisions, location, revision, isRevisionIncluded);
        }
        return fileRevisions;
    }

    protected Map<String, FileRevisionsInfo> handleRevision(Map<String, FileRevisionsInfo> fileRevisions, SubversionReleaseSCM.ModuleLocation location, Revision revision, boolean isIncluded) {
        long revisionID = revision.getLogEntry().getRevision();
        Map logEntryPathMap = revision.getLogEntry().getChangedPaths();
        if (logEntryPathMap == null || logEntryPathMap.isEmpty()) {
            return fileRevisions;
        }
        for (SVNLogEntryPath logEntryPath : logEntryPathMap.values()) {
            char type = logEntryPath.getType();
            if ('D' == type) continue;
            String fileRelativePath = this.toRelativePath(location.getURL(), logEntryPath.getPath());
            FileRevisionsInfo fileRevisionsInfo = fileRevisions.get(fileRelativePath);
            if (fileRevisionsInfo == null) {
                fileRevisionsInfo = new FileRevisionsInfo(fileRelativePath, logEntryPath.getPath());
            }
            fileRevisionsInfo.addRevision(revisionID, isIncluded);
            fileRevisions.put(fileRelativePath, fileRevisionsInfo);
        }
        return fileRevisions;
    }

    protected Map<String, Long> resolveIncludedFileRevisions(Map<String, FileRevisionsInfo> fileRevisions, long latestTagRevision) {
        LinkedHashMap<String, Long> filesToUpdate = new LinkedHashMap<String, Long>();
        for (FileRevisionsInfo fileRevisionsInfo : fileRevisions.values()) {
            long updateRevision = fileRevisionsInfo.getMaxIncludedRevision();
            if (updateRevision <= 0L || updateRevision <= latestTagRevision) continue;
            filesToUpdate.put(fileRevisionsInfo.getFilePath(), updateRevision);
        }
        return filesToUpdate;
    }

    protected String resolveConflictsWarnings(Map<String, FileRevisionsInfo> fileRevisions, AllIssueRevisionsInfo allIssueRevisionsInfo, Map<String, Long> releaseFiles, Set<Long> includedRevisionsInRelease, Set<Long> tagPreviouslyDeployedRevisions) {
        StringBuilder sb = null;
        for (Map.Entry<String, Long> entry : releaseFiles.entrySet()) {
            Set<Long> revisionsInConflict;
            String filePath = entry.getKey();
            Long releaseRevision = entry.getValue();
            FileRevisionsInfo fileRevisionsInfo = fileRevisions.get(filePath);
            if (fileRevisionsInfo == null || (revisionsInConflict = this.getConflictRevisionsForFile(fileRevisionsInfo, releaseRevision, includedRevisionsInRelease, tagPreviouslyDeployedRevisions)) == null || revisionsInConflict.isEmpty()) continue;
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(Constants.LINE_SEPARATOR);
            }
            sb.append(this.toConflictMessage(fileRevisionsInfo, allIssueRevisionsInfo, releaseRevision, revisionsInConflict));
        }
        return sb != null ? sb.toString() : null;
    }

    protected Set<Long> getConflictRevisionsForFile(FileRevisionsInfo fileRevisionsInfo, Long releaseRevision, Set<Long> includedRevisionsInRelease, Set<Long> tagPreviouslyDeployedRevisions) {
        Set conflictRevisionIds = null;
        Set<Long> allFileRevisions = fileRevisionsInfo.getAllRevisions();
        for (Long fileRevision : allFileRevisions) {
            boolean isRevisionIncluded;
            if (fileRevision >= releaseRevision || (isRevisionIncluded = includedRevisionsInRelease != null && includedRevisionsInRelease.contains(fileRevision))) continue;
            boolean bl = isRevisionIncluded = tagPreviouslyDeployedRevisions != null && tagPreviouslyDeployedRevisions.contains(fileRevision);
            if (isRevisionIncluded) continue;
            conflictRevisionIds = PluginUtil.addCheckedObjectInSet(conflictRevisionIds, fileRevision);
        }
        return conflictRevisionIds;
    }

    protected String toConflictMessage(FileRevisionsInfo fileRevisionsInfo, AllIssueRevisionsInfo allIssueRevisionsInfo, Long releaseRevision, Set<Long> revisionsInConflict) {
        StringBuilder sb = new StringBuilder();
        String msg = "#### CONFLICT FILE ########### [" + fileRevisionsInfo.getFilePath() + "] ################################";
        sb.append(msg).append(Constants.LINE_SEPARATOR);
        IssueInfo issueInfo = allIssueRevisionsInfo.getIssueInfoForRevision(releaseRevision);
        sb.append("Revision [" + releaseRevision + "] (" + issueInfo.getUserName() + ") will be deployed [ For issue " + issueInfo.getMessage() + "]").append(Constants.LINE_SEPARATOR);
        sb.append("---------------------------------------------------------------------------------").append(Constants.LINE_SEPARATOR);
        sb.append("Conflict revisions that are not included into the release").append(Constants.LINE_SEPARATOR);
        for (Long revisionId : revisionsInConflict) {
            Revision revision = allIssueRevisionsInfo.getRevision(revisionId);
            String date = DateFormatUtils.format((Date)revision.getLogEntry().getDate(), (String)"yyyy-MM-dd HH:mm:ss");
            IssueInfo issue = allIssueRevisionsInfo.getIssueInfoForRevision(revisionId);
            sb.append("Revision [" + revisionId + "] (" + revision.getLogEntry().getAuthor() + " , " + date + ")  [ For issue " + issue.getMessage() + "]");
            sb.append(Constants.LINE_SEPARATOR);
        }
        sb.append(StringUtils.repeat((String)"#", (int)msg.length()));
        return sb.toString();
    }

    protected String toRelativePath(String baseSVNURL, String filePathInSvn) {
        if (filePathInSvn.startsWith("/")) {
            filePathInSvn = filePathInSvn.substring(1, filePathInSvn.length());
        }
        String[] parts = StringUtils.split((String)filePathInSvn, (String)"/");
        for (int i = 1; i < parts.length; ++i) {
            Object[] prefixArray = Arrays.copyOfRange(parts, 0, i);
            String searchPart = StringUtils.join((Object[])prefixArray, (String)"/");
            if (!baseSVNURL.endsWith(searchPart)) continue;
            Object[] suffixArray = Arrays.copyOfRange(parts, i, parts.length);
            return "/" + StringUtils.join((Object[])suffixArray, (String)"/");
        }
        return filePathInSvn;
    }

    public static class FileRevisionsInfo {
        private final String filePath;
        private final String fullFilePath;
        private Set<Long> allRevisions = new LinkedHashSet<Long>();
        private long maxIncludedRevision;

        public FileRevisionsInfo(String filePath, String fullFilePath) {
            this.fullFilePath = fullFilePath;
            this.filePath = filePath;
        }

        public void addRevision(long revision, boolean isIncluded) {
            this.allRevisions.add(revision);
            if (isIncluded) {
                this.maxIncludedRevision = Math.max(this.maxIncludedRevision, revision);
            }
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getFullFilePath() {
            return this.fullFilePath;
        }

        public long getMaxIncludedRevision() {
            return this.maxIncludedRevision;
        }

        public Set<Long> getAllRevisions() {
            return this.allRevisions;
        }
    }
}

