/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.impl.functions.afterbuild;

import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.svn_partial_release_mgr.api.constants.PluginUtil;
import hudson.plugins.svn_partial_release_mgr.api.functions.afterbuild.Function1StoreTagDeploymentInfoFile;
import hudson.plugins.svn_partial_release_mgr.api.model.TagDeploymentInfo;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class Function1StoreTagDeploymentInfoFileImpl
implements Function1StoreTagDeploymentInfoFile {
    @Override
    public TagDeploymentInfo moveTheDeploymentInfoFileToTagDeployments(Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException {
        String jsonPath = build.getRootDir() + "/" + "deployments" + "/" + "deploymentInfo.xml";
        File jsonDeploymentInfoFile = new File(FilenameUtils.separatorsToUnix((String)jsonPath));
        if (!jsonDeploymentInfoFile.exists()) {
            return null;
        }
        TagDeploymentInfo tagDeploymentInfo = TagDeploymentInfo.readFromFile(jsonDeploymentInfoFile);
        if (PluginUtil.isTestBuild(tagDeploymentInfo.getUserInput())) {
            return tagDeploymentInfo;
        }
        File destDir = new File(PluginUtil.getWorkspaceTagDeploymentDatePath(workspace, tagDeploymentInfo));
        if (!destDir.exists()) {
            FileUtils.forceMkdir((File)destDir);
        }
        PluginUtil.log(listener, "COPY THE JSON DEPLOYMENT INFO FILE TO [" + destDir.getAbsolutePath() + "]..........");
        FileUtils.copyFileToDirectory((File)jsonDeploymentInfoFile, (File)destDir);
        return tagDeploymentInfo;
    }
}

