/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.impl;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.svn_partial_release_mgr.api.PluginFactory;
import hudson.plugins.svn_partial_release_mgr.api.PluginService;
import hudson.plugins.svn_partial_release_mgr.api.constants.PluginUtil;
import hudson.plugins.svn_partial_release_mgr.api.functions.afterbuild.Function1StoreTagDeploymentInfoFile;
import hudson.plugins.svn_partial_release_mgr.api.functions.afterbuild.Function2PartialPatchCreator;
import hudson.plugins.svn_partial_release_mgr.api.functions.build.Function0GetReleaseDeployInput;
import hudson.plugins.svn_partial_release_mgr.api.functions.build.Function1GetTagSource;
import hudson.plugins.svn_partial_release_mgr.api.functions.build.Function2GetPrevDeploymentsFileSources;
import hudson.plugins.svn_partial_release_mgr.api.functions.build.Function3GetReleaseFileSources;
import hudson.plugins.svn_partial_release_mgr.api.functions.build.Function4BackupReleaseFilesAsSrcPatches;
import hudson.plugins.svn_partial_release_mgr.api.functions.build.Function5BackupDeploymentInfoFile;
import hudson.plugins.svn_partial_release_mgr.api.functions.initview.Function1TagRevisionResolver;
import hudson.plugins.svn_partial_release_mgr.api.functions.initview.Function2RevisionsAfterTagCollector;
import hudson.plugins.svn_partial_release_mgr.api.functions.initview.Function3PrevDeploymentsCollector;
import hudson.plugins.svn_partial_release_mgr.api.model.AllIssueRevisionsInfo;
import hudson.plugins.svn_partial_release_mgr.api.model.JobConfigurationUserInput;
import hudson.plugins.svn_partial_release_mgr.api.model.ReleaseDeployInput;
import hudson.plugins.svn_partial_release_mgr.api.model.Revision;
import hudson.plugins.svn_partial_release_mgr.api.model.TagDeploymentInfo;
import hudson.plugins.svn_partial_release_mgr.api.model.redeploy.TagPreviousDeploymentsInfo;
import hudson.plugins.svn_partial_release_mgr.impl.task.ReleaseDeploymentTask;
import hudson.scm.SubversionReleaseSCM;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class ReleaseDeploymentService
implements PluginService {
    @Override
    public void doAfterSuccessfullBuild(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException {
        TagDeploymentInfo tagDeploymentInfo = PluginFactory.getBean(Function1StoreTagDeploymentInfoFile.class).moveTheDeploymentInfoFileToTagDeployments(build, workspace, listener);
        PluginFactory.getBean(Function2PartialPatchCreator.class).createThePartialPatch(build, tagDeploymentInfo, workspace, listener);
        PluginUtil.log(listener, "END OF RELEASE TOOL ACTION ========================");
    }

    @Override
    public AllIssueRevisionsInfo getAllRevisionsInfo(JobConfigurationUserInput releaseInput, String workspaceRootPath) throws IOException {
        long latestTagRevision = PluginFactory.getBean(Function1TagRevisionResolver.class).resolveTagNameRevision(releaseInput);
        return this.getIssueRevisionsResolver(releaseInput, workspaceRootPath, latestTagRevision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkout(JobConfigurationUserInput releaseInput, AllIssueRevisionsInfo allIssueRevisionsInfo, AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile, Logger LOGGER) throws IOException, InterruptedException {
        try {
            listener.getLogger().println("STARTING THE PARTIAL-RELEASE-MGR ACTIONS............");
            ReleaseDeployInput releaseDeployInput = PluginFactory.getBean(Function0GetReleaseDeployInput.class).toReleaseDeployInput(build, (TaskListener)listener, releaseInput, allIssueRevisionsInfo);
            ReleaseDeploymentTask releaseDeploymentTask = new ReleaseDeploymentTask(build, this, releaseDeployInput, workspace, (TaskListener)listener, LOGGER);
            workspace.act((FilePath.FileCallable)releaseDeploymentTask);
        }
        finally {
            PluginUtil.setJobEnded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTheAsynchJobLogic(File ws, AbstractBuild<?, ?> build, ReleaseDeployInput releaseDeployInput, FilePath workspace, TaskListener listener, Logger LOGGER) throws IOException {
        SubversionReleaseSCM.ModuleLocation location = releaseDeployInput.getReleaseInput().getLocation();
        String tagName = releaseDeployInput.getReleaseInput().getTagName();
        ISVNAuthenticationProvider authProvider = SubversionReleaseSCM.DescriptorImpl.DESCRIPTOR.createAuthenticationProvider();
        SVNClientManager manager = SubversionReleaseSCM.createSvnClientManager(authProvider);
        try {
            SVNUpdateClient svnClient = manager.getUpdateClient();
            File buildRootDir = new File(ws, location.local);
            if (!PluginUtil.isFastBuild(releaseDeployInput.getUserInput())) {
                this.cleanBuildDirectory(buildRootDir, listener);
                PluginUtil.log(listener, "GETTING THE TAG [" + tagName + "] SOURCE ............");
                Function1GetTagSource function1GetTagSource = PluginFactory.getBean(Function1GetTagSource.class);
                function1GetTagSource.getTheTagSourceIntoTheBuildDirectory(ws, build, manager, svnClient, listener, releaseDeployInput);
            }
            PluginFactory.getBean(Function2GetPrevDeploymentsFileSources.class).checkoutAndCopyToBuildDirectoryTheFileSource(ws, build, svnClient, buildRootDir, releaseDeployInput, listener);
            PluginFactory.getBean(Function3GetReleaseFileSources.class).checkoutAndCopyToBuildDirectoryTheFileSource(ws, build, svnClient, buildRootDir, releaseDeployInput, listener);
            PluginFactory.getBean(Function4BackupReleaseFilesAsSrcPatches.class).copyToBuildNumberDirectoryTheFileSources(ws, build, releaseDeployInput, listener);
            PluginFactory.getBean(Function5BackupDeploymentInfoFile.class).storeTheDeploymentInfoToBuildNumberDirectory(build, listener, releaseDeployInput);
            PluginUtil.log(listener, "END - WILL START REGULAR MAVEN BUILD NOW.....");
        }
        finally {
            manager.dispose();
        }
    }

    protected AllIssueRevisionsInfo getIssueRevisionsResolver(JobConfigurationUserInput releaseInput, String workspaceRootPath, long latestTagRevision) throws IOException {
        Collection<Revision> revisions = this.getRevisions(releaseInput, latestTagRevision);
        TagPreviousDeploymentsInfo existingDeployments = this.resolveTagExistingDeploymentsInfo(releaseInput, workspaceRootPath);
        return new AllIssueRevisionsInfo(releaseInput.getIssuePrefixes(), latestTagRevision, existingDeployments, revisions);
    }

    protected TagPreviousDeploymentsInfo resolveTagExistingDeploymentsInfo(JobConfigurationUserInput releaseInput, String workspaceRootPath) throws IOException {
        return PluginFactory.getBean(Function3PrevDeploymentsCollector.class).resolveTagExistingDeploymentsInfo(releaseInput, workspaceRootPath);
    }

    protected void cleanBuildDirectory(File buildRootDir, TaskListener listener) throws IOException {
        if (buildRootDir.exists() && buildRootDir.isDirectory()) {
            PluginUtil.log(listener, "CLEANING THE BUILD DIRECTORY [" + buildRootDir + "] ............");
            FileUtils.cleanDirectory((File)buildRootDir);
        }
    }

    protected Collection<Revision> getRevisions(JobConfigurationUserInput releaseInput, long end) throws IOException {
        return PluginFactory.getBean(Function2RevisionsAfterTagCollector.class).getRevisions(releaseInput, end);
    }
}

