/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.api.model.redeploy;

import hudson.plugins.svn_partial_release_mgr.api.model.TagDeploymentInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TagPreviousDeploymentsInfo {
    private final List<TagDeploymentInfo> existingDeployments;

    public TagPreviousDeploymentsInfo(List<TagDeploymentInfo> existingDeployments) {
        this.existingDeployments = existingDeployments;
    }

    public List<TagDeploymentInfo> getExistingDeployments() {
        return this.existingDeployments;
    }

    public Set<Long> getAllTagPreviouslyDeployedRevisions() {
        if (this.existingDeployments == null || this.existingDeployments.isEmpty()) {
            return null;
        }
        HashSet<Long> set = new HashSet<Long>();
        for (TagDeploymentInfo existingDeployment : this.existingDeployments) {
            set.addAll(existingDeployment.getDeploymentRevisionIds());
        }
        return set;
    }

    public boolean isRevisionAlreadyDeployed(long revisionId) {
        if (this.existingDeployments == null || this.existingDeployments.isEmpty()) {
            return false;
        }
        for (TagDeploymentInfo existingDeployment : this.existingDeployments) {
            if (!existingDeployment.isRevisionAlreadyDeployed(revisionId)) continue;
            return true;
        }
        return false;
    }

    public String getRevisionDeployedDate(long revisionId) {
        if (this.existingDeployments == null || this.existingDeployments.isEmpty()) {
            return null;
        }
        for (TagDeploymentInfo existingDeployment : this.existingDeployments) {
            if (!existingDeployment.isRevisionAlreadyDeployed(revisionId)) continue;
            return existingDeployment.getDeploymentDate();
        }
        return null;
    }
}

