/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.api.model;

import hudson.plugins.svn_partial_release_mgr.api.constants.PluginUtil;
import hudson.plugins.svn_partial_release_mgr.api.model.UserInput;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TagDeploymentInfo {
    private final String tagName;
    private final String deploymentDate;
    private final UserInput userInput;

    public TagDeploymentInfo(String tagName, String deploymentDate, UserInput userInput) {
        this.tagName = tagName;
        this.deploymentDate = deploymentDate;
        this.userInput = userInput;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getDeploymentDate() {
        return this.deploymentDate;
    }

    public Set<Long> getDeploymentRevisionIds() {
        return this.userInput.getIncludedRevisionsInRelease();
    }

    public UserInput getUserInput() {
        return this.userInput;
    }

    public boolean isRevisionAlreadyDeployed(long revisionId) {
        Set<Long> deploymentRevisionIds = this.getDeploymentRevisionIds();
        return deploymentRevisionIds != null && deploymentRevisionIds.contains(revisionId);
    }

    public static TagDeploymentInfo readFromFile(File xmlFile) throws IOException {
        try {
            Document xmlDocument = PluginUtil.buildW3CDocumentFromFile(xmlFile, "UTF-8");
            Node rootNode = xmlDocument.getFirstChild();
            String tagName = PluginUtil.getValueFromChildElement(rootNode, "tagName");
            String deploymentDate = PluginUtil.getValueFromChildElement(rootNode, "deploymentDate");
            UserInput userInput = UserInput.fromXML(rootNode);
            return new TagDeploymentInfo(tagName, deploymentDate, userInput);
        }
        catch (Exception e) {
            throw new IOException("Error reading the xml file [" + xmlFile.getAbsolutePath() + "]!!" + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public Document toXml() {
        Document document = PluginUtil.buildNewW3CDocument();
        Element rootNode = document.createElement("deployment");
        document.appendChild(rootNode);
        PluginUtil.addNodeInNode(rootNode, "tagName", this.tagName);
        PluginUtil.addNodeInNode(rootNode, "deploymentDate", this.deploymentDate);
        Node userInputXML = this.userInput.toXML(document);
        rootNode.appendChild(userInputXML);
        return document;
    }
}

