/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.api.model;

import hudson.model.Run;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.tmatesoft.svn.core.SVNLogEntry;

public class Revision {
    private final Map<Long, Run> builds;
    private final SVNLogEntry logEntry;
    private final boolean alreadyDeployed;
    private final String deployedDate;

    public Revision(SVNLogEntry logEntry) {
        this.builds = new HashMap<Long, Run>();
        this.logEntry = logEntry;
        this.alreadyDeployed = false;
        this.deployedDate = null;
    }

    private Revision(Map<Long, Run> builds, SVNLogEntry logEntry, boolean alreadyDeployed, String deployedDate) {
        this.builds = builds;
        this.logEntry = logEntry;
        this.alreadyDeployed = alreadyDeployed;
        this.deployedDate = deployedDate;
    }

    public Revision asAlreadyDeployed(String deployedDate) {
        return new Revision(this.builds, this.logEntry, true, deployedDate);
    }

    public long getRevision() {
        return this.logEntry.getRevision();
    }

    public SVNLogEntry getLogEntry() {
        return this.logEntry;
    }

    public Map<Long, Run> getBuilds() {
        return this.builds;
    }

    public boolean isAlreadyDeployed() {
        return this.alreadyDeployed;
    }

    public String getDeployedDate() {
        return StringUtils.defaultString((String)this.deployedDate);
    }

    public String getStyle() {
        return this.isAlreadyDeployed() ? "border-bottom:1px solid lightgrey;background:#EBE8E8" : "border-bottom:1px solid lightgrey";
    }
}

