/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.api.model;

import hudson.Util;
import hudson.scm.SubversionReleaseSCM;
import org.apache.commons.lang.StringUtils;

public class JobConfigurationUserInput {
    private final String remoteLocation;
    private final String tagName;
    private final String issuePrefixes;
    private final SubversionReleaseSCM.ModuleLocation location;

    public JobConfigurationUserInput(String remoteLocation, String tagName, String issuePrefixes) {
        this.remoteLocation = remoteLocation;
        this.tagName = tagName;
        this.issuePrefixes = issuePrefixes;
        this.location = this.toModuleLocation();
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getIssuePrefixes() {
        return this.issuePrefixes;
    }

    public String getRemoteLocation() {
        return this.remoteLocation;
    }

    public SubversionReleaseSCM.ModuleLocation getLocation() {
        return this.location;
    }

    private SubversionReleaseSCM.ModuleLocation toModuleLocation() {
        String remoteLoc = StringUtils.trimToNull((String)this.remoteLocation);
        String localLocation = "build/" + this.tagName;
        remoteLoc = Util.removeTrailingSlash((String)remoteLoc.trim());
        return new SubversionReleaseSCM.ModuleLocation(remoteLoc, StringUtils.trimToNull((String)localLocation));
    }
}

