/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.api.model;

import hudson.plugins.svn_partial_release_mgr.api.model.Revision;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class IssueInfo {
    private final String number;
    private final String userName;
    private final String message;
    private Map<Long, Revision> revisions;

    public IssueInfo(String number, String userName, String message) {
        this.number = number;
        this.userName = userName;
        this.message = message;
    }

    public String getNumber() {
        return this.number;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<Long, Revision> getRevisions() {
        return this.revisions;
    }

    public Collection<Long> getRevisionIds() {
        if (this.revisions == null || this.revisions.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        return this.revisions.keySet();
    }

    public boolean isAlreadyDeployed() {
        if (this.revisions == null || this.revisions.isEmpty()) {
            return false;
        }
        long maxDeployedRevision = 0L;
        long maxUnDeployedRevision = 0L;
        for (Revision revision : this.revisions.values()) {
            if (revision.isAlreadyDeployed()) {
                maxDeployedRevision = Math.max(maxDeployedRevision, revision.getRevision());
                continue;
            }
            maxUnDeployedRevision = Math.max(maxUnDeployedRevision, revision.getRevision());
        }
        return maxDeployedRevision > maxUnDeployedRevision;
    }

    public String getDeployedDate() {
        if (!this.isAlreadyDeployed()) {
            return "";
        }
        for (Revision revision : this.revisions.values()) {
            String deployedDate = revision.getDeployedDate();
            if (StringUtils.isBlank((String)deployedDate)) continue;
            return deployedDate;
        }
        return "";
    }

    public String getRevisionsArray() {
        return StringUtils.join(this.getRevisionIds(), (String)",");
    }

    public void addRevisionId(Revision revision) {
        if (this.revisions == null) {
            this.revisions = new LinkedHashMap<Long, Revision>();
        }
        this.revisions.put(revision.getLogEntry().getRevision(), revision);
    }

    public String getStyle() {
        return this.isAlreadyDeployed() ? "border-bottom:1px solid lightgrey;background:#EBE8E8" : "border-bottom:1px solid lightgrey";
    }
}

