/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.api.model;

import hudson.plugins.svn_partial_release_mgr.api.model.IssueInfo;
import hudson.plugins.svn_partial_release_mgr.api.model.Revision;
import hudson.plugins.svn_partial_release_mgr.api.model.redeploy.TagPreviousDeploymentsInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class AllIssueRevisionsInfo {
    public static final String COMMIT_NO_ISSUE = "COMMIT_NO_ISSUE";
    private final long tagRevisionNumber;
    private final Map<Long, Revision> revisions;
    private final Map<String, IssueInfo> issues;
    private final Map<Long, String> revisionToIssueMap;
    private final String[] issuePrefixesArr;
    private final Set<Long> tagPreviouslyDeployedRevisions;

    public AllIssueRevisionsInfo(String issuePrefixes, long tagRevisionNumber, TagPreviousDeploymentsInfo existingDeployments, Collection<Revision> revisions) {
        this.issuePrefixesArr = StringUtils.split((String)issuePrefixes, (String)",");
        this.tagRevisionNumber = tagRevisionNumber;
        this.revisions = this.toRevisionList(revisions, existingDeployments);
        this.tagPreviouslyDeployedRevisions = this.getAllTagPreviouslyDeployedRevisions(existingDeployments);
        this.issues = this.toIssueMap();
        this.revisionToIssueMap = this.toRevisionIssueMap();
    }

    public long getTagRevisionNumber() {
        return this.tagRevisionNumber;
    }

    public Collection<IssueInfo> getIssues() {
        return this.issues.values();
    }

    public Collection<Revision> getRevisions() {
        return this.revisions != null ? this.revisions.values() : null;
    }

    public String getIssueNumberForRevision(long revisionID) {
        return this.revisionToIssueMap.get(revisionID);
    }

    public Revision getRevision(long revisionID) {
        return this.revisions != null ? this.revisions.get(revisionID) : null;
    }

    public String getIssueMessageForRevision(long revisionID) {
        String issueNumber = this.getIssueNumberForRevision(revisionID);
        IssueInfo issueInfo = this.getIssueInfo(issueNumber);
        return issueInfo != null ? issueInfo.getMessage() : null;
    }

    public IssueInfo getIssueInfo(String issueNumber) {
        return this.issues != null ? this.issues.get(issueNumber) : null;
    }

    public IssueInfo getIssueInfoForRevision(long revisionID) {
        String issueNumber = this.getIssueNumberForRevision(revisionID);
        if (StringUtils.isBlank((String)issueNumber)) {
            return null;
        }
        return this.getIssueInfo(issueNumber);
    }

    public boolean hasPreviousDeployments() {
        return this.tagPreviouslyDeployedRevisions != null && !this.tagPreviouslyDeployedRevisions.isEmpty();
    }

    public Set<Long> getTagPreviouslyDeployedRevisions() {
        return this.tagPreviouslyDeployedRevisions;
    }

    protected Set<Long> getAllTagPreviouslyDeployedRevisions(TagPreviousDeploymentsInfo existingDeployments) {
        if (existingDeployments == null) {
            return null;
        }
        return existingDeployments.getAllTagPreviouslyDeployedRevisions();
    }

    protected Map<Long, Revision> toRevisionList(Collection<Revision> revisions, TagPreviousDeploymentsInfo existingDeployments) {
        if (revisions == null || revisions.isEmpty()) {
            return null;
        }
        LinkedHashMap<Long, Revision> revisionList = new LinkedHashMap<Long, Revision>(revisions.size());
        for (Revision revision : revisions) {
            Revision revisionForList = this.checkRevisionAlreadyDeployed(revision, existingDeployments);
            revisionList.put(revisionForList.getRevision(), revisionForList);
        }
        return revisionList;
    }

    protected Revision checkRevisionAlreadyDeployed(Revision revision, TagPreviousDeploymentsInfo existingDeployments) {
        if (existingDeployments == null) {
            return revision;
        }
        String dateDeployed = existingDeployments.getRevisionDeployedDate(revision.getRevision());
        if (!StringUtils.isBlank((String)dateDeployed)) {
            return revision.asAlreadyDeployed(dateDeployed);
        }
        return revision;
    }

    protected Map<Long, String> toRevisionIssueMap() {
        HashMap<Long, String> revisionToIssueMap = new HashMap<Long, String>();
        for (IssueInfo issueInfo : this.issues.values()) {
            Collection<Long> revisionIds = issueInfo.getRevisionIds();
            for (Long revisionId : revisionIds) {
                revisionToIssueMap.put(revisionId, issueInfo.getNumber());
            }
        }
        return revisionToIssueMap;
    }

    protected Map<String, IssueInfo> toIssueMap() {
        LinkedHashMap<String, IssueInfo> issues = new LinkedHashMap<String, IssueInfo>();
        if (this.revisions == null || this.revisions.isEmpty()) {
            return issues;
        }
        for (Revision revision : this.revisions.values()) {
            String msg = revision.getLogEntry().getMessage();
            String issueNumber = StringUtils.defaultIfBlank((String)this.resolveIssueNumber(msg), (String)COMMIT_NO_ISSUE);
            IssueInfo issueInfo = (IssueInfo)issues.get(issueNumber);
            if (issueInfo == null) {
                issueInfo = new IssueInfo(issueNumber, revision.getLogEntry().getAuthor(), msg);
            }
            issueInfo.addRevisionId(revision);
            issues.put(issueNumber, issueInfo);
        }
        return issues;
    }

    protected String resolveIssueNumber(String msg) {
        for (String prefix : this.issuePrefixesArr) {
            String issueNumber;
            if (!msg.contains(prefix) || StringUtils.isBlank((String)(issueNumber = this.resolveIssueFromPrefix(msg, prefix)))) continue;
            return issueNumber;
        }
        return COMMIT_NO_ISSUE;
    }

    protected String resolveIssueFromPrefix(String msg, String prefix) {
        int index = msg.indexOf(prefix);
        if (index < 0) {
            return null;
        }
        String rightPart = msg.substring(index + prefix.length(), msg.length());
        StringBuilder sb = new StringBuilder(prefix);
        sb.append(this.getNumbersPart(rightPart));
        return sb.toString();
    }

    protected String getNumbersPart(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isDigit(c)) {
                return sb.toString();
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

