/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.svn_partial_release_mgr.api.constants;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.svn_partial_release_mgr.api.constants.Constants;
import hudson.plugins.svn_partial_release_mgr.api.model.TagDeploymentInfo;
import hudson.plugins.svn_partial_release_mgr.api.model.UserInput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.tmatesoft.svn.core.SVNURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PluginUtil {
    public static final Properties configurationProperties = PluginUtil.loadConfigurationProperties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadConfigurationProperties() {
        InputStream fis = null;
        try {
            fis = PluginUtil.class.getResourceAsStream("/configuration.properties");
            if (fis == null) {
                Properties properties = null;
                return properties;
            }
            Properties applicationProperties = new Properties();
            applicationProperties.load(fis);
            Properties properties = applicationProperties;
            return properties;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String getConfiguration(String property) {
        return configurationProperties != null ? configurationProperties.getProperty(property) : null;
    }

    public static String pathToTag(SVNURL svnurl, String tagName) {
        return PluginUtil.pathToTagWithSvnUrl(svnurl.toDecodedString(), tagName);
    }

    public static String pathToTagWithSvnUrl(String svnurlFullPath, String tagName) {
        String pathToTag = PluginUtil.pathToTag("trunk", svnurlFullPath, tagName);
        if (!StringUtils.isBlank((String)pathToTag)) {
            return pathToTag;
        }
        return PluginUtil.pathToTag("branches", svnurlFullPath, tagName);
    }

    protected static String pathToTag(String prefix, String fullPath, String tagName) {
        if (!fullPath.contains(prefix)) {
            return null;
        }
        fullPath = fullPath.substring(0, fullPath.lastIndexOf(prefix));
        fullPath = fullPath + "tags" + "/" + tagName;
        return fullPath;
    }

    public static void log(TaskListener listener, String message) {
        String dateString = "[" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "]";
        listener.getLogger().println(dateString + " " + "PARTIAL-RELEASE-MGR TOOL : " + message);
    }

    public static String getWorkspaceDeploymentPath(String workspaceRootPath, String tagName) {
        return FilenameUtils.separatorsToUnix((String)(workspaceRootPath + "/" + "deployments" + "/" + tagName));
    }

    public static String getWorkspaceBuildRootPath(String workspaceRootPath, String tagName) {
        return FilenameUtils.separatorsToUnix((String)(workspaceRootPath + "/" + "build" + "/" + tagName));
    }

    public static String getFullPathToTagBackupSource(String workspaceRootPath, String tagName) {
        return FilenameUtils.separatorsToUnix((String)(workspaceRootPath + "/" + PluginUtil.getRelativePathToTagBackupSource(tagName)));
    }

    public static String getRelativePathToTagBackupSource(String tagName) {
        return "checkout/tags/" + tagName;
    }

    public static String getWorkspaceTagDeploymentDatePath(FilePath workspace, TagDeploymentInfo tagDeploymentInfo) throws IOException {
        String deploymentWorkspaceDirPath = PluginUtil.getWorkspaceDeploymentPath(workspace.getRemote(), tagDeploymentInfo.getTagName());
        String dirDateName = DateFormatUtils.format((Date)PluginUtil.parse(tagDeploymentInfo.getDeploymentDate(), "yyyy-MM-dd HH:mm:ss"), (String)"yyyyMMdd_HHmmss");
        return FilenameUtils.separatorsToUnix((String)(deploymentWorkspaceDirPath + "/" + dirDateName));
    }

    public static String getWorkspaceTagBuildRootDirectory(FilePath workspace, TagDeploymentInfo tagDeploymentInfo) throws IOException {
        return PluginUtil.getWorkspaceBuildRootPath(workspace.getRemote(), tagDeploymentInfo.getTagName());
    }

    public static Date parse(String dateString, String dateFormat) throws IOException {
        try {
            return new SimpleDateFormat(dateFormat).parse(dateString);
        }
        catch (ParseException e) {
            throw new IOException("Could not parse the date [" + dateString + "] with format [" + dateFormat + "]");
        }
    }

    public static Document buildNewW3CDocument() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document buildW3CDocumentFromFile(File file, String encoding) throws Exception {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setValidating(false);
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        BufferedReader lnr = null;
        Document doc = null;
        try {
            lnr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            InputSource inSource = new InputSource(lnr);
            doc = domBuilder.parse(inSource);
        }
        finally {
            if (lnr != null) {
                try {
                    lnr.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return doc;
    }

    public static String getValueFromChildElement(Node element, String tagChild) {
        Node valueNode = PluginUtil.findNextNode(element, tagChild);
        return valueNode != null ? PluginUtil.getValueFromTextNode(valueNode) : null;
    }

    public static Map<String, String> getChildNodeValues(Node element) {
        if (element == null) {
            return null;
        }
        if (!element.hasChildNodes()) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        NodeList nl = element.getChildNodes();
        if (nl == null || nl.getLength() <= 0) {
            return null;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node nd = nl.item(i);
            String xmlValue = PluginUtil.getValueFromTextNode(nd);
            if (StringUtils.isBlank((String)xmlValue)) continue;
            result.put(nd.getNodeName(), xmlValue);
        }
        return result;
    }

    public static List<Node> getNodesInNode(Node node, String name) {
        if (node == null) {
            return null;
        }
        if (!node.hasChildNodes()) {
            return null;
        }
        NodeList childrenNodes = node.getChildNodes();
        if (childrenNodes == null || childrenNodes.getLength() <= 0) {
            return null;
        }
        ArrayList<Node> nodes = null;
        for (int i = 0; i < childrenNodes.getLength(); ++i) {
            Node nd = childrenNodes.item(i);
            if (nd == null || nd.getNodeName() == null || !nd.getNodeName().equals(name)) continue;
            if (nodes == null) {
                nodes = new ArrayList<Node>();
            }
            nodes.add(nd);
        }
        return nodes;
    }

    public static Node findNextNode(Node node, String tagName) {
        if (node == null) {
            return null;
        }
        if (!node.hasChildNodes()) {
            return null;
        }
        NodeList childrenNodes = node.getChildNodes();
        if (childrenNodes == null || childrenNodes.getLength() <= 0) {
            return null;
        }
        Node _retNode = null;
        for (int i = 0; i < childrenNodes.getLength(); ++i) {
            Node nd = childrenNodes.item(i);
            if (nd.getNodeName().equals(tagName)) {
                return nd;
            }
            _retNode = PluginUtil.findNextNode(nd, tagName);
        }
        return _retNode;
    }

    public static String getValueFromTextNode(Node element) {
        if (element == null) {
            return null;
        }
        NodeList childrenNodes = element.getChildNodes();
        if (childrenNodes == null || childrenNodes.getLength() <= 0) {
            return null;
        }
        StringBuilder text = null;
        for (int i = 0; i < childrenNodes.getLength(); ++i) {
            Node childNode = childrenNodes.item(i);
            if (childNode == null || 3 != childNode.getNodeType()) continue;
            if (text == null) {
                text = new StringBuilder();
            }
            text.append(childNode.getNodeValue());
        }
        return text != null ? text.toString() : null;
    }

    public static Node addNodeInNode(Node rootNode, String elementName, String value) {
        Document document = rootNode.getOwnerDocument();
        Element newElement = document.createElement(elementName);
        PluginUtil.setNodeValue(newElement, value);
        rootNode.appendChild(newElement);
        return newElement;
    }

    public static void setNodeValue(Node element, String textValue) {
        if (StringUtils.isBlank((String)textValue)) {
            return;
        }
        if (element == null) {
            return;
        }
        if (element.hasChildNodes()) {
            Node vFirstChild = element.getFirstChild();
            if (vFirstChild.getNodeType() == 3) {
                vFirstChild.setNodeValue(textValue);
                return;
            }
            if (vFirstChild.getNodeType() == 4) {
                element.removeChild(vFirstChild);
                Document doc = element.getOwnerDocument();
                element.appendChild(doc.createTextNode(textValue));
            }
            return;
        }
        Document doc = element.getOwnerDocument();
        element.appendChild(doc.createTextNode(textValue));
    }

    public static void toFile(Document document, File file) throws Exception {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            PluginUtil.toOutputStream(document, fos);
        }
    }

    public static <O extends OutputStream> O toOutputStream(Document document, O out) throws Exception {
        PluginUtil.transform(document, Constants.XML_OUTPUT_PROPERTIES, new StreamResult(out));
        return out;
    }

    public static void transform(Document document, Properties outputProperties, StreamResult streamResult) throws Exception {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        if (outputProperties != null) {
            Enumeration<?> propertyNames = outputProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propName = propertyNames.nextElement().toString();
                String propValue = outputProperties.getProperty(propName);
                if (propValue == null) continue;
                transformer.setOutputProperty(propName, propValue);
            }
        }
        transformer.transform(new DOMSource(document), streamResult);
    }

    public static List<File> getAllFilesInAllSubDirectories(File parentDir, FileFilter filter) {
        List<File> filesList = null;
        return PluginUtil.getAllFilesInAllSubDirectories(filesList, parentDir, filter);
    }

    public static List<File> getAllFilesInAllSubDirectories(List<File> filesList, File parentDir, FileFilter filter) {
        File[] directories;
        if (parentDir == null || !parentDir.exists()) {
            return filesList;
        }
        File[] files = parentDir.listFiles(filter);
        if (files != null) {
            for (File vFile : files) {
                if (filesList == null) {
                    filesList = new ArrayList<File>();
                }
                filesList.add(vFile);
            }
        }
        if ((directories = parentDir.listFiles()) != null) {
            for (File vDirectory : directories) {
                filesList = PluginUtil.getAllFilesInAllSubDirectories(filesList, vDirectory, filter);
            }
        }
        return filesList;
    }

    public static <K, V> Map<K, Set<V>> putCheckedObjectInInnerSet(Map<K, Set<V>> mapValues, K key, V obj) {
        Set<Object> innerSet = null;
        if (mapValues != null && mapValues.containsKey(key)) {
            innerSet = mapValues.get(key);
        }
        innerSet = PluginUtil.addCheckedObjectInSet(innerSet, obj);
        mapValues = PluginUtil.addCheckedObjectInMap(mapValues, key, innerSet);
        return mapValues;
    }

    public static <T, O extends T> Set<T> addCheckedObjectInSet(Set<T> existingObjectsSet, O obj) {
        if (obj != null) {
            if (existingObjectsSet == null) {
                existingObjectsSet = new HashSet<T>();
            }
            existingObjectsSet.add(obj);
        }
        return existingObjectsSet;
    }

    public static <K, V, O extends V> Map<K, V> addCheckedObjectInMap(Map<K, V> mapValues, K key, O obj) {
        if (obj != null) {
            if (mapValues == null) {
                mapValues = new HashMap();
            }
            mapValues.put(key, obj);
        }
        return mapValues;
    }

    public static <A, K, V> Map<A, Map<K, V>> putCheckedObjectInInnerMap(Map<A, Map<K, V>> mapValues, A key, K innerKey, V obj) {
        Map<K, V> innerMap = null;
        if (mapValues != null && mapValues.containsKey(key)) {
            innerMap = mapValues.get(key);
        }
        innerMap = PluginUtil.addCheckedObjectInMap(innerMap, innerKey, obj);
        mapValues = PluginUtil.addCheckedObjectInMap(mapValues, key, innerMap);
        return mapValues;
    }

    public static boolean isJobStarted() {
        String systemFlag = System.getProperty("SYSTEM_PROPERTY_BUILD_STARTED");
        return Boolean.TRUE.toString().equalsIgnoreCase(systemFlag);
    }

    public static void setJobStarted() {
        System.setProperty("SYSTEM_PROPERTY_BUILD_STARTED", String.valueOf(Boolean.TRUE));
    }

    public static void setJobEnded() {
        System.setProperty("SYSTEM_PROPERTY_BUILD_STARTED", String.valueOf(Boolean.FALSE));
    }

    public static Method getReflectionMethodInAnySuperClass(Class clazz, String methodName, Class[] classParams) {
        Method mainMethod = PluginUtil.getClassMethod(clazz, methodName, classParams);
        while (mainMethod == null) {
            Class superClass = clazz.getSuperclass();
            mainMethod = PluginUtil.getClassMethod(superClass, methodName, classParams);
        }
        return mainMethod;
    }

    protected static Method getClassMethod(Class clazz, String methodName, Class[] classParams) {
        try {
            return clazz.getDeclaredMethod(methodName, classParams);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Object reflectionCallMethod(Object instanceOfClass, String methodName, Class[] paramClasses, Object[] paramObjects) throws Exception {
        return PluginUtil.reflectionCallMethod(instanceOfClass, methodName, paramClasses, paramObjects, true);
    }

    public static Object reflectionCallMethod(Object instanceOfClass, String methodName, Class[] paramClasses, Object[] paramObjects, boolean searchSuperClasses) throws Exception {
        Method mainMethod;
        Method method = mainMethod = searchSuperClasses ? PluginUtil.getReflectionMethodInAnySuperClass(instanceOfClass.getClass(), methodName, paramClasses) : PluginUtil.getClassMethod(instanceOfClass.getClass(), methodName, paramClasses);
        if (mainMethod == null) {
            throw new NoSuchMethodException("Error! " + instanceOfClass.getClass().getName() + " class does not contain a [" + methodName + "] method.");
        }
        return mainMethod.invoke(instanceOfClass, paramObjects);
    }

    public static boolean isEqualsSafe(String s, String target) {
        return PluginUtil.isEqualsSafe(s, target, false);
    }

    public static boolean isEqualsSafe(String s, String target, boolean ignoreCase) {
        if (s == null && target == null) {
            return true;
        }
        if (s == null) {
            return false;
        }
        return ignoreCase ? s.equalsIgnoreCase(target) : s.equals(target);
    }

    public static boolean isGeneratePartialPatch(UserInput userInput) {
        return PluginUtil.isBooleanAdditionParameterTrue(userInput, "GENERATE_PARTIAL_PATCH");
    }

    public static boolean isGenerateSourcePartialPatch(UserInput userInput) {
        return PluginUtil.isBooleanAdditionParameterTrue(userInput, "GENERATE_SRC_PARTIAL_PATCH");
    }

    public static boolean isGeneratePatchForEveryIssue(UserInput userInput) {
        return PluginUtil.isBooleanAdditionParameterTrue(userInput, "GENERATE_PATCH_FOR_EVERY_ISSUE");
    }

    public static boolean isFastBuild(UserInput userInput) {
        return PluginUtil.isBooleanAdditionParameterTrue(userInput, "IS_FAST_BUILD");
    }

    public static boolean isTestBuild(UserInput userInput) {
        return PluginUtil.isBooleanAdditionParameterTrue(userInput, "IS_TEST_BUILD");
    }

    public static boolean isIncludePreviousPatchSources(UserInput userInput) {
        return PluginUtil.isBooleanAdditionParameterTrue(userInput, "INCLUDE_PREV_PATCH_SOURCES");
    }

    private static boolean isBooleanAdditionParameterTrue(UserInput userInput, String attributeName) {
        String value = userInput.getAdditionalParameterValue(attributeName);
        return NumberUtils.toInt((String)value) == 1;
    }
}

