/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Util;
import hudson.model.TaskListener;
import hudson.scm.SVNLogFilter;
import hudson.scm.subversion.Messages;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSVNLogFilter
implements SVNLogFilter {
    private TaskListener listener;
    private Pattern[] excludedPatterns;
    private Pattern[] includedPatterns;
    private Set<String> excludedUsers;
    private String excludedRevprop;
    private Pattern[] excludedCommitMessages;
    private boolean ignoreDirPropChanges;
    private static final long serialVersionUID = 1L;

    public DefaultSVNLogFilter(Pattern[] excludedPatterns, Pattern[] includedPatterns, Set<String> excludedUsers, String excludedRevProp, Pattern[] excludedCommitMessages, boolean ignoreDirPropChanges) {
        this.excludedPatterns = excludedPatterns;
        this.includedPatterns = includedPatterns;
        this.excludedUsers = excludedUsers;
        this.excludedRevprop = excludedRevProp;
        this.excludedCommitMessages = excludedCommitMessages;
        this.ignoreDirPropChanges = ignoreDirPropChanges;
    }

    @Override
    public void setTaskListener(TaskListener listener) {
        this.listener = listener;
    }

    private PrintStream getLog() {
        return this.listener != null ? this.listener.getLogger() : null;
    }

    @Override
    public boolean hasExclusionRule() {
        return this.excludedPatterns.length > 0 || !this.excludedUsers.isEmpty() || this.excludedRevprop != null || this.excludedCommitMessages.length > 0 || this.includedPatterns.length > 0 || this.ignoreDirPropChanges;
    }

    @Override
    public boolean isIncluded(SVNLogEntry logEntry) {
        Map changedPaths;
        SVNProperties revprops;
        if (this.excludedRevprop != null && (revprops = logEntry.getRevisionProperties()) != null && revprops.containsName(this.excludedRevprop)) {
            if (this.getLog() != null) {
                this.getLog().println(Messages.SubversionSCM_pollChanges_ignoredRevision(logEntry.getRevision(), Messages.SubversionSCM_pollChanges_ignoredRevision_revprop(this.excludedRevprop)));
            }
            return false;
        }
        String author = logEntry.getAuthor();
        if (this.excludedUsers.contains(author)) {
            if (this.getLog() != null) {
                this.getLog().println(Messages.SubversionSCM_pollChanges_ignoredRevision(logEntry.getRevision(), Messages.SubversionSCM_pollChanges_ignoredRevision_author(author)));
            }
            return false;
        }
        if (this.excludedCommitMessages != null) {
            String commitMessage = logEntry.getMessage();
            for (Pattern pattern : this.excludedCommitMessages) {
                if (!pattern.matcher(commitMessage).find()) continue;
                return false;
            }
        }
        if ((changedPaths = logEntry.getChangedPaths()).isEmpty()) {
            return false;
        }
        if (this.ignoreDirPropChanges) {
            boolean contentChanged = false;
            for (SVNLogEntryPath path : changedPaths.values()) {
                if (path.getType() == 'M' && path.getKind() == SVNNodeKind.DIR) continue;
                contentChanged = true;
                break;
            }
            if (!contentChanged) {
                if (this.getLog() != null) {
                    this.getLog().println(Messages.SubversionSCM_pollChanges_ignoredRevision(logEntry.getRevision(), Messages.SubversionSCM_pollChanges_ignoredRevision_onlydirprops()));
                }
                return false;
            }
        }
        ArrayList<Object> includedPaths = new ArrayList();
        if (this.includedPatterns.length > 0) {
            block2: for (String path : changedPaths.keySet()) {
                for (Pattern pattern : this.includedPatterns) {
                    if (!pattern.matcher(path).matches()) continue;
                    includedPaths.add(path);
                    continue block2;
                }
            }
        } else {
            includedPaths = new ArrayList(changedPaths.keySet());
        }
        if (includedPaths.isEmpty()) {
            if (this.getLog() != null) {
                this.getLog().println(Messages.SubversionSCM_pollChanges_ignoredRevision(logEntry.getRevision(), Messages.SubversionSCM_pollChanges_ignoredRevision_noincpath()));
            }
            return false;
        }
        ArrayList<String> excludedPaths = new ArrayList<String>();
        if (this.excludedPatterns.length > 0) {
            block4: for (String string : includedPaths) {
                for (Pattern pattern : this.excludedPatterns) {
                    if (!pattern.matcher(string).matches()) continue;
                    excludedPaths.add(string);
                    continue block4;
                }
            }
        }
        if (includedPaths.size() == excludedPaths.size()) {
            if (this.getLog() != null) {
                this.getLog().println(Messages.SubversionSCM_pollChanges_ignoredRevision(logEntry.getRevision(), Messages.SubversionSCM_pollChanges_ignoredRevision_path(Util.join(excludedPaths, (String)", "))));
            }
            return false;
        }
        return true;
    }
}

