/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.listtagsparameter;

import hudson.Util;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;

public class SimpleSVNDirEntryHandler
implements ISVNDirEntryHandler {
    private final List<SVNDirEntry> dirs = new ArrayList<SVNDirEntry>();
    private final Pattern filterPattern;

    public SimpleSVNDirEntryHandler(String filter) {
        this.filterPattern = Util.fixEmpty((String)filter) != null ? Pattern.compile(filter) : null;
    }

    public List<String> getDirs() {
        return this.getDirs(false, false);
    }

    @Nonnull
    public List<String> getDirs(boolean reverseByDate, boolean reverseByName) {
        if (reverseByDate) {
            this.dirs.sort(Comparator.comparing(SVNDirEntry::getDate).reversed());
        } else if (reverseByName) {
            this.dirs.sort(Comparator.comparing(SVNDirEntry::getName).reversed());
        } else {
            this.dirs.sort(Comparator.comparing(SVNDirEntry::getName));
        }
        ArrayList<String> sortedDirs = new ArrayList<String>();
        for (SVNDirEntry dirEntry : this.dirs) {
            sortedDirs.add(dirEntry.getName());
        }
        return sortedDirs;
    }

    public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
        if (this.filterPattern == null || this.filterPattern.matcher(dirEntry.getName()).matches()) {
            this.dirs.add(dirEntry);
        }
    }
}

