/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.subversion;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import jenkins.scm.api.SCMFile;
import jenkins.scm.impl.subversion.SubversionSCMFileSystem;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;

public class SubversionSCMFile
extends SCMFile {
    private SubversionSCMFileSystem fs;

    SubversionSCMFile(SubversionSCMFileSystem fs) {
        this.fs = fs;
    }

    SubversionSCMFile(SubversionSCMFile parent, String name, SubversionSCMFileSystem fs) {
        super((SCMFile)parent, name);
        this.fs = fs;
    }

    protected SCMFile newChild(String name, boolean assumeIsDirectory) {
        return new SubversionSCMFile(this, name, this.fs);
    }

    public Iterable<SCMFile> children() throws IOException, InterruptedException {
        try {
            ArrayList<SCMFile> result = new ArrayList<SCMFile>();
            ArrayList dirEntries = new ArrayList();
            this.fs.getRepository().getDir(this.getPath(), this.fs.getLatestRevision(), null, 0, dirEntries);
            for (SVNDirEntry e : dirEntries) {
                result.add(this.newChild(e.getName(), false));
            }
            return result;
        }
        catch (SVNException e) {
            throw new IOException("failed to list children for " + this.getPath(), e);
        }
    }

    public long lastModified() throws IOException, InterruptedException {
        return this.getInfo().getDate().getTime();
    }

    protected SCMFile.Type type() throws IOException, InterruptedException {
        if (this.isRoot()) {
            return SCMFile.Type.DIRECTORY;
        }
        try {
            SVNNodeKind nodeKind = this.fs.getRepository().checkPath(this.getPath(), this.fs.getLatestRevision());
            switch (nodeKind.toString()) {
                case "file": {
                    return SCMFile.Type.REGULAR_FILE;
                }
                case "dir": {
                    return SCMFile.Type.DIRECTORY;
                }
                case "none": {
                    return SCMFile.Type.NONEXISTENT;
                }
            }
            return SCMFile.Type.OTHER;
        }
        catch (SVNException e) {
            throw new IOException("failed to get file type for " + this.getPath(), e);
        }
    }

    public InputStream content() throws IOException, InterruptedException {
        ByteArrayOutputStream contents = new ByteArrayOutputStream();
        try {
            this.fs.getRepository().getFile(this.getPath(), this.fs.getLatestRevision(), null, (OutputStream)contents);
            return new ByteArrayInputStream(contents.toByteArray());
        }
        catch (SVNException e) {
            throw new IOException("failed to fetch file: " + this.getPath(), e);
        }
    }

    private SVNDirEntry getInfo() throws IOException {
        try {
            return this.fs.getRepository().info(this.getPath(), this.fs.getLatestRevision());
        }
        catch (SVNException e) {
            throw new IOException("failed to get file info for " + this.getPath(), e);
        }
    }
}

