/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.browsers.AbstractSventon;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Sventon2
extends AbstractSventon {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public Sventon2(URL url, String repositoryInstance) throws MalformedURLException {
        super(url, repositoryInstance);
    }

    @Override
    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        int r = path.getLogEntry().getRevision();
        return new URL(this.url, String.format("repos/%s/diff/%s?revision=%d", Sventon2.encodePath(this.repositoryInstance), Sventon2.encodePath(this.getPath(path)), r));
    }

    @Override
    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() == EditType.DELETE) {
            return null;
        }
        int r = path.getLogEntry().getRevision();
        return new URL(this.url, String.format("repos/%s/goto/%s?revision=%d", Sventon2.encodePath(this.repositoryInstance), Sventon2.encodePath(this.getPath(path)), r));
    }

    private String getPath(SubversionChangeLogSet.Path path) {
        String s = Sventon2.trimHeadSlash((String)path.getValue());
        return s;
    }

    private static String encodePath(String path) throws UnsupportedEncodingException {
        StringBuilder buf = new StringBuilder();
        if (path.startsWith("/")) {
            buf.append('/');
        }
        boolean first = true;
        for (String pathElement : path.split("/")) {
            if (first) {
                first = false;
            } else {
                buf.append('/');
            }
            buf.append(URLEncoder.encode(pathElement, "UTF-8"));
        }
        if (path.endsWith("/")) {
            buf.append('/');
        }
        return buf.toString().replace("%20", "+");
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        return new URL(this.url, String.format("repos/%s/info?revision=%d", Sventon2.encodePath(this.repositoryInstance), changeSet.getRevision()));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "Sventon 2.x";
        }

        public FormValidation doCheckUrl(@AncestorInPath Item project, final @QueryParameter(fixEmpty=true) String value) throws IOException, ServletException {
            if (project == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || project != null && !project.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if (value == null) {
                return FormValidation.ok();
            }
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String v = value;
                    if (!v.endsWith("/")) {
                        v = v + '/';
                    }
                    try {
                        if (this.findText(this.open(new URL(v)), "sventon 2")) {
                            return FormValidation.ok();
                        }
                        if (this.findText(this.open(new URL(v)), "sventon")) {
                            return FormValidation.error((String)"This is a valid Sventon URL but it doesn't look like Sventon 2.x");
                        }
                        return FormValidation.error((String)"This is a valid URL but it doesn't look like Sventon");
                    }
                    catch (IOException e) {
                        return this.handleIOException(v, e);
                    }
                }
            }.check();
        }
    }
}

