/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.remoting.DelegatingCallable;
import hudson.scm.PollingResult;
import hudson.scm.SCMRevisionState;
import hudson.scm.SVNRevisionState;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.Messages;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jenkins.security.MasterToSlaveCallable;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.wc.SVNInfo;

final class CompareAgainstBaselineCallable
extends MasterToSlaveCallable<PollingResult, IOException>
implements DelegatingCallable<PollingResult, IOException> {
    private final SubversionSCM.SVNLogHandler logHandler;
    private final String projectName;
    private final SVNRevisionState baseline;
    private final TaskListener listener;
    private final ISVNAuthenticationProvider defaultAuthProvider;
    private final Map<String, ISVNAuthenticationProvider> authProviders;
    private final String nodeName;
    private static final long serialVersionUID = 8200959096894789583L;

    CompareAgainstBaselineCallable(SVNRevisionState baseline, SubversionSCM.SVNLogHandler logHandler, String projectName, TaskListener listener, ISVNAuthenticationProvider defaultAuthProvider, Map<String, ISVNAuthenticationProvider> authProviders, String nodeName) {
        this.logHandler = logHandler;
        this.projectName = projectName;
        this.baseline = baseline;
        this.listener = listener;
        this.defaultAuthProvider = defaultAuthProvider;
        this.authProviders = authProviders;
        this.nodeName = nodeName;
    }

    public ClassLoader getClassLoader() {
        return Hudson.getInstance().getPluginManager().uberClassLoader;
    }

    public PollingResult call() throws IOException {
        this.listener.getLogger().println("Received SCM poll call on " + this.nodeName + " for " + this.projectName + " on " + DateFormat.getDateTimeInstance().format(new Date()));
        HashMap<String, Long> revs = new HashMap<String, Long>();
        boolean changes = false;
        boolean significantChanges = false;
        for (Map.Entry<String, Long> baselineInfo : this.baseline.revisions.entrySet()) {
            String url = baselineInfo.getKey();
            long baseRev = baselineInfo.getValue();
            revs.put(url, baseRev);
            try {
                ISVNAuthenticationProvider authProvider = this.authProviders.get(url);
                if (authProvider == null) {
                    authProvider = this.defaultAuthProvider;
                }
                SVNURL svnurl = SVNURL.parseURIDecoded((String)url);
                long nowRev = new SubversionSCM.SvnInfo((SVNInfo)SubversionSCM.parseSvnInfo((SVNURL)svnurl, (ISVNAuthenticationProvider)authProvider)).revision;
                changes |= nowRev > baseRev;
                this.listener.getLogger().println(Messages.SubversionSCM_pollChanges_remoteRevisionAt(url, nowRev));
                revs.put(url, nowRev);
                if (!this.logHandler.findNonExcludedChanges(svnurl, baseRev + 1L, nowRev, authProvider)) continue;
                this.listener.getLogger().println(Messages.SubversionSCM_pollChanges_changedFrom(baseRev));
                significantChanges = true;
            }
            catch (SVNException e) {
                e.printStackTrace(this.listener.error(Messages.SubversionSCM_pollChanges_exception(url)));
            }
        }
        assert (revs.size() == this.baseline.revisions.size());
        return new PollingResult((SCMRevisionState)this.baseline, (SCMRevisionState)new SVNRevisionState(revs), significantChanges ? PollingResult.Change.SIGNIFICANT : (changes ? PollingResult.Change.INSIGNIFICANT : PollingResult.Change.NONE));
    }
}

