/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsmith.jenkins.stackhammer.deployment;

import hudson.Functions;
import hudson.model.AbstractBuild;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.cloudsmith.jenkins.stackhammer.common.StackOpResult;
import org.cloudsmith.stackhammer.api.model.CatalogGraph;
import org.cloudsmith.stackhammer.api.model.LogEntry;
import org.cloudsmith.stackhammer.api.model.ResultWithDiagnostic;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class DeploymentResult
extends StackOpResult<List<CatalogGraph>> {
    private static final long serialVersionUID = 6226198097084585053L;
    private List<LogEntry> logEntries;
    private transient List<HostEntry> hostEntries;

    public DeploymentResult(AbstractBuild<?, ?> build) {
        super(build);
    }

    public synchronized void addLogEntries(List<LogEntry> newLogEntries) {
        if (this.logEntries == null) {
            this.logEntries = new ArrayList<LogEntry>(newLogEntries);
        } else {
            this.logEntries.addAll(newLogEntries);
        }
        this.hostEntries = null;
    }

    public DeploymentResult clone() {
        DeploymentResult clone;
        try {
            clone = (DeploymentResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning BuildData", e);
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCatalogGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String name = req.getRestOfPath();
        if (name != null && !name.isEmpty()) {
            name = name.substring(1);
            for (HostEntry he : this.getHostEntries()) {
                CatalogGraph graph;
                if (!name.equals(he.getName()) || (graph = he.getCatalogGraph()) == null) continue;
                rsp.setContentType("image/svg+xml");
                ServletOutputStream out = rsp.getOutputStream();
                try {
                    byte[] svgData = Base64.decodeBase64((String)graph.getCatalogGraph());
                    rsp.setContentLength(svgData.length);
                    out.write(svgData);
                    return;
                }
                finally {
                    out.close();
                }
            }
        }
        rsp.sendError(404);
    }

    public String getDisplayName() {
        return "Deployment Results";
    }

    public synchronized List<HostEntry> getHostEntries() {
        if (this.hostEntries != null) {
            return this.hostEntries;
        }
        ArrayList<HostEntry> result = new ArrayList<HostEntry>();
        List graphs = (List)this.getResult();
        for (Map.Entry<String, List<LogEntry>> logEntries : this.getLogEntriesPerHost().entrySet()) {
            String hostName = logEntries.getKey();
            String machineName = null;
            CatalogGraph catalogGraph = null;
            if (graphs != null) {
                for (CatalogGraph cg : graphs) {
                    if (!hostName.equals(cg.getNodeName())) continue;
                    catalogGraph = cg;
                    machineName = cg.getInstanceID();
                    break;
                }
            }
            List<LogEntry> les = logEntries.getValue();
            if (machineName == null) {
                LogEntry le;
                Iterator<LogEntry> i$ = les.iterator();
                while (i$.hasNext() && (machineName = (le = i$.next()).getPhysicalOrigin()) == null) {
                }
            }
            result.add(new HostEntry(hostName, machineName, catalogGraph, les));
        }
        if (graphs != null) {
            for (CatalogGraph cg : graphs) {
                if (this.getLogEntriesPerHost().containsKey(cg.getNodeName())) continue;
                result.add(new HostEntry(cg.getNodeName(), cg.getInstanceID(), cg, Collections.<LogEntry>emptyList()));
            }
        }
        this.hostEntries = result;
        return result;
    }

    public int getHostEntryCount() {
        return this.getHostEntries().size();
    }

    @Override
    public String getIconFileName() {
        return Functions.getResourcePath() + "/plugin/stackhammer/icons/hammer-32x32.png";
    }

    @Override
    public String getLargeIconFileName() {
        return "/plugin/stackhammer/icons/hammer-48x48.png";
    }

    public List<LogEntry> getLogEntries() {
        return this.logEntries == null ? Collections.emptyList() : this.logEntries;
    }

    private synchronized Map<String, List<LogEntry>> getLogEntriesPerHost() {
        String hostName;
        Map<String, List<LogEntry>> logEntriesPerHost = null;
        List<LogEntry> les = this.getLogEntries();
        List graphs = (List)this.getResult();
        for (LogEntry le : les) {
            List<LogEntry> hostEntries;
            hostName = le.getLogicalOrigin();
            if (hostName == null) continue;
            if (graphs != null && le.getPhysicalOrigin() == null) {
                for (CatalogGraph cg : graphs) {
                    if (!hostName.equals(cg.getNodeName())) continue;
                    le.setPhysicalOrigin(cg.getInstanceID());
                    break;
                }
            }
            if (logEntriesPerHost == null) {
                logEntriesPerHost = new HashMap<String, List<LogEntry>>();
            }
            if ((hostEntries = logEntriesPerHost.get(hostName)) == null) {
                hostEntries = new ArrayList<LogEntry>();
                logEntriesPerHost.put(hostName, hostEntries);
            }
            hostEntries.add(le);
        }
        block2: for (LogEntry le : les) {
            String machineName;
            hostName = le.getLogicalOrigin();
            if (hostName != null || (machineName = le.getPhysicalOrigin()) == null) continue;
            if (logEntriesPerHost != null) {
                for (Map.Entry<String, List<LogEntry>> entry : logEntriesPerHost.entrySet()) {
                    hostName = entry.getKey();
                    List<LogEntry> hostEntries = entry.getValue();
                    int idx = hostEntries.size();
                    while (--idx >= 0) {
                        LogEntry hostEntry = hostEntries.get(idx);
                        if (!machineName.equals(hostEntry.getPhysicalOrigin())) continue;
                        le.setLogicalOrigin(hostName);
                        hostEntries.add(le);
                        continue block2;
                    }
                }
            }
            hostName = "Unknown";
            le.setLogicalOrigin(hostName);
            List<LogEntry> hostEntries = logEntriesPerHost.get(hostName);
            if (hostEntries == null) {
                hostEntries = new ArrayList<LogEntry>();
                logEntriesPerHost.put(hostName, hostEntries);
            }
            hostEntries.add(le);
        }
        if (logEntriesPerHost == null) {
            logEntriesPerHost = Collections.emptyMap();
        }
        return logEntriesPerHost;
    }

    public String getSummary() {
        int hostsWithErrors = 0;
        int hostsWithWarnings = 0;
        List<HostEntry> hosts = this.getHostEntries();
        int hostCount = hosts.size();
        if (hostCount == 0) {
            return "No hosts deployed";
        }
        for (int idx = 0; idx < hostCount; ++idx) {
            boolean hasErrors = false;
            boolean hasWarnings = false;
            for (LogEntry le : hosts.get(idx).getLogEntries()) {
                switch (le.getSeverity()) {
                    case 4: 
                    case 5: {
                        hasErrors = true;
                        break;
                    }
                    case 3: {
                        hasWarnings = true;
                    }
                }
                if (!hasErrors || !hasWarnings) continue;
                break;
            }
            if (hasErrors) {
                ++hostsWithErrors;
            }
            if (!hasWarnings) continue;
            ++hostsWithWarnings;
        }
        StringBuilder bld = new StringBuilder();
        bld.append(hostCount);
        bld.append(" host");
        if (hostCount > 1) {
            bld.append('s');
        }
        bld.append(" deployed");
        if (hostsWithErrors > 0 || hostsWithWarnings > 0) {
            bld.append(" (");
            if (hostsWithErrors > 0) {
                bld.append(hostsWithErrors);
                bld.append(" with errors");
                if (hostsWithWarnings > 0) {
                    bld.append(", ");
                }
            }
            if (hostsWithWarnings > 0) {
                bld.append(hostsWithWarnings);
                bld.append(" with warnings");
            }
            bld.append(')');
        }
        return bld.toString();
    }

    @Override
    public String getTitle() {
        return "Deployment Result";
    }

    public String getUrlName() {
        return "deploymentReport";
    }

    @Override
    public void setResult(ResultWithDiagnostic<List<CatalogGraph>> resultDiagnostic) {
        super.setResult(resultDiagnostic);
        this.hostEntries = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HostEntry {
        private final CatalogGraph catalogGraph;
        private final List<LogEntry> logEntries;
        private final String name;
        private final String machineName;

        public HostEntry(String name, String machineName, CatalogGraph catalogGraph, List<LogEntry> logEntries) {
            this.name = name;
            this.machineName = machineName;
            this.catalogGraph = catalogGraph;
            this.logEntries = logEntries;
        }

        public CatalogGraph getCatalogGraph() {
            return this.catalogGraph;
        }

        public String getCatalogGraphURL() {
            return this.catalogGraph == null ? null : "catalogGraph/" + this.getName();
        }

        public String getDisplayName() {
            return "Host \"" + this.getName() + '\"';
        }

        public List<LogEntry> getLogEntries() {
            return this.logEntries == null ? Collections.emptyList() : this.logEntries;
        }

        public int getLogEntryCount() {
            return this.logEntries == null ? 0 : this.logEntries.size();
        }

        public String getMachineName() {
            return this.machineName;
        }

        public String getName() {
            if (this.machineName == null) {
                return this.name;
            }
            return this.name + " [" + this.machineName + ']';
        }
    }
}

