/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsmith.jenkins.stackhammer.common;

import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StackOpDescriptor<T extends BuildStep & Describable<T>>
extends BuildStepDescriptor<T> {
    public static String getParameter(JSONObject formData, String attributeName) {
        String value = formData.getString(attributeName);
        if (value == null) {
            return null;
        }
        return (value = value.trim()).isEmpty() ? null : value;
    }

    public StackOpDescriptor(Class<? extends T> builderClass) {
        super(builderClass);
    }

    public FormValidation doCheckStack(@QueryParameter String value) throws IOException, ServletException {
        if (value.length() == 0) {
            return FormValidation.error((String)"Please specify a stack");
        }
        String[] split = value.trim().split("/");
        if (split.length == 2) {
            String owner = split[0].trim();
            String name = split[1].trim();
            if (!owner.isEmpty() && !name.isEmpty()) {
                return FormValidation.ok();
            }
        }
        return FormValidation.error((String)"Stack must be in the form <owner>/<name>");
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return true;
    }
}

