/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUser;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnamePortRequirement;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.Session;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.JavaVersionChecker;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.PluginImpl;
import hudson.plugins.sshslaves.SFTPClient;
import hudson.plugins.sshslaves.SSHConnector;
import hudson.plugins.sshslaves.verifiers.HostKey;
import hudson.plugins.sshslaves.verifiers.NonVerifyingKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.SlaveComputer;
import hudson.tools.JDKInstaller;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.NamingThreadFactory;
import hudson.util.NullStream;
import hudson.util.Secret;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.putty.PuTTYKey;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SSHLauncher
extends ComputerLauncher {
    public static final SchemeRequirement SSH_SCHEME = new SchemeRequirement("ssh");
    private static final List<String> RECOVERABLE_FAILURES = Arrays.asList("Connection refused", "Connection reset", "Connection timed out", "No route to host", "Premature connection close");
    public static final Integer DEFAULT_MAX_NUM_RETRIES = 10;
    public static final Integer DEFAULT_RETRY_WAIT_TIME = 15;
    public static final Integer DEFAULT_LAUNCH_TIMEOUT_SECONDS = DEFAULT_MAX_NUM_RETRIES * DEFAULT_RETRY_WAIT_TIME + 60;
    public static final String AGENT_JAR = "remoting.jar";
    public static final String SLASH_AGENT_JAR = "/remoting.jar";
    public static final String WORK_DIR_PARAM = " -workDir ";
    private final String host;
    private final int port;
    private String credentialsId;
    private transient StandardUsernameCredentials credentials;
    @Deprecated
    private transient String username;
    @Deprecated
    private transient Secret password;
    @Deprecated
    private transient String privatekey;
    private final String jvmOptions;
    public final String javaPath;
    private volatile transient Connection connection;
    private volatile transient boolean tearingDownConnection;
    private transient Session session;
    public final String prefixStartSlaveCmd;
    public final String suffixStartSlaveCmd;
    public Integer launchTimeoutSeconds;
    public Integer maxNumRetries;
    public Integer retryWaitTime;
    @CheckForNull
    private volatile transient ExecutorService launcherExecutorService;
    @CheckForNull
    private final SshHostKeyVerificationStrategy sshHostKeyVerificationStrategy;
    private Boolean tcpNoDelay;
    private String workDir;
    private static final Logger LOGGER = Logger.getLogger(SSHLauncher.class.getName());

    @DataBoundConstructor
    public SSHLauncher(String host, int port, String credentialsId, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime, SshHostKeyVerificationStrategy sshHostKeyVerificationStrategy) {
        this(host, port, credentialsId, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, maxNumRetries, retryWaitTime, sshHostKeyVerificationStrategy);
    }

    @Deprecated
    public SSHLauncher(String host, int port, String credentialsId, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime) {
        this(host, port, credentialsId, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, maxNumRetries, retryWaitTime, null);
        LOGGER.warning("This constructor is deprecated and will be removed on next versions, please do not use it.");
    }

    @Deprecated
    public SSHLauncher(String host, int port, String credentialsId, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds) {
        this(host, port, credentialsId, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, null, null, null);
        LOGGER.warning("This constructor is deprecated and will be removed on next versions, please do not use it.");
    }

    @Deprecated
    public SSHLauncher(String host, int port, String credentialsId, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(host, port, credentialsId, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, null, null, null, null);
        LOGGER.warning("This constructor is deprecated and will be removed on next versions, please do not use it.");
    }

    public static StandardUsernameCredentials lookupSystemCredentials(String credentialsId) {
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{SSH_SCHEME}), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public static StandardUsernameCredentials lookupSystemCredentials(String credentialsId, String host, int port) {
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{SSH_SCHEME, new HostnamePortRequirement(host, port)}), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public SSHLauncher(String host, int port, StandardUsernameCredentials credentials, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime) {
        this(host, port, credentials, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, maxNumRetries, retryWaitTime, null);
        LOGGER.warning("This constructor is deprecated and will be removed on next versions, please do not use it.");
    }

    @Deprecated
    public SSHLauncher(String host, int port, StandardUsernameCredentials credentials, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds) {
        this(host, port, credentials, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, null, null, null);
        LOGGER.warning("This constructor is deprecated and will be removed on next versions, please do not use it.");
    }

    @Deprecated
    public SSHLauncher(String host, int port, StandardUsernameCredentials credentials, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(host, port, credentials, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, null, null, null, null);
        LOGGER.warning("This constructor is deprecated and will be removed on next versions, please do not use it.");
    }

    @Deprecated
    public SSHLauncher(String host, int port, SSHUser credentials, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(host, port, (StandardUsernameCredentials)credentials, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, null, null, null, null);
        LOGGER.warning("This constructor is deprecated and will be removed on next versions, please do not use it.");
    }

    @Deprecated
    public SSHLauncher(String host, int port, String username, String password, String privatekey, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(host, port, username, password, privatekey, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd);
        LOGGER.warning("This constructor is deprecated and will be removed on next versions, please do not use it.");
    }

    @Deprecated
    public SSHLauncher(String host, int port, String username, String password, String privatekey, String jvmOptions, String javaPath, JDKInstaller jdkInstaller, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this.host = Util.fixEmptyAndTrim((String)host);
        this.jvmOptions = Util.fixEmpty((String)jvmOptions);
        this.port = port == 0 ? 22 : port;
        this.username = Util.fixEmpty((String)username);
        this.password = Secret.fromString((String)Util.fixEmpty((String)password));
        this.privatekey = Util.fixEmpty((String)privatekey);
        this.credentials = null;
        this.credentialsId = null;
        this.javaPath = Util.fixEmpty((String)javaPath);
        this.prefixStartSlaveCmd = Util.fixEmpty((String)prefixStartSlaveCmd);
        this.suffixStartSlaveCmd = Util.fixEmpty((String)suffixStartSlaveCmd);
        this.launchTimeoutSeconds = DEFAULT_LAUNCH_TIMEOUT_SECONDS;
        this.maxNumRetries = DEFAULT_MAX_NUM_RETRIES;
        this.retryWaitTime = DEFAULT_RETRY_WAIT_TIME;
        this.sshHostKeyVerificationStrategy = null;
        LOGGER.warning("This constructor is deprecated and will be removed on next versions, please do not use it.");
    }

    @Deprecated
    public SSHLauncher(String host, int port, StandardUsernameCredentials credentials, String jvmOptions, String javaPath, JDKInstaller jdkInstaller, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(host, port, credentials, jvmOptions, javaPath, jdkInstaller, prefixStartSlaveCmd, suffixStartSlaveCmd, null, null, null);
        LOGGER.warning("This constructor is deprecated and will be removed on next versions, please do not use it.");
    }

    @Deprecated
    public SSHLauncher(String host, int port, StandardUsernameCredentials credentials, String jvmOptions, String javaPath, JDKInstaller jdkInstaller, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime) {
        this(host, port, credentials, jvmOptions, javaPath, jdkInstaller, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, maxNumRetries, retryWaitTime, null);
        LOGGER.warning("This constructor is deprecated and will be removed on next versions, please do not use it.");
    }

    @Deprecated
    public SSHLauncher(String host, int port, StandardUsernameCredentials credentials, String jvmOptions, String javaPath, JDKInstaller jdkInstaller, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime, SshHostKeyVerificationStrategy sshHostKeyVerificationStrategy) {
        this(host, port, credentials != null ? credentials.getId() : null, jvmOptions, javaPath, null, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, maxNumRetries, retryWaitTime, sshHostKeyVerificationStrategy);
        this.credentials = credentials;
    }

    public SSHLauncher(String host, int port, String credentialsId, String jvmOptions, String javaPath, JDKInstaller jdkInstaller, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime, SshHostKeyVerificationStrategy sshHostKeyVerificationStrategy) {
        this.host = Util.fixEmptyAndTrim((String)host);
        this.jvmOptions = Util.fixEmpty((String)jvmOptions);
        this.port = port == 0 ? 22 : port;
        this.credentialsId = credentialsId;
        this.javaPath = Util.fixEmpty((String)javaPath);
        this.prefixStartSlaveCmd = Util.fixEmpty((String)prefixStartSlaveCmd);
        this.suffixStartSlaveCmd = Util.fixEmpty((String)suffixStartSlaveCmd);
        this.launchTimeoutSeconds = launchTimeoutSeconds == null || launchTimeoutSeconds <= 0 ? DEFAULT_LAUNCH_TIMEOUT_SECONDS : launchTimeoutSeconds;
        this.maxNumRetries = maxNumRetries != null && maxNumRetries > 0 ? maxNumRetries : DEFAULT_MAX_NUM_RETRIES;
        this.retryWaitTime = retryWaitTime != null && retryWaitTime > 0 ? retryWaitTime : DEFAULT_RETRY_WAIT_TIME;
        this.sshHostKeyVerificationStrategy = sshHostKeyVerificationStrategy;
    }

    @Deprecated
    public SSHLauncher(String host, int port, SSHUser credentials, String jvmOptions, String javaPath, JDKInstaller jdkInstaller, String prefixStartSlaveCmd, String suffixStartSlaveCmd) {
        this(host, port, (StandardUsernameCredentials)credentials, jvmOptions, javaPath, jdkInstaller, prefixStartSlaveCmd, suffixStartSlaveCmd);
        LOGGER.warning("This constructor is deprecated and will be removed on next versions, please do not use it.");
    }

    @Deprecated
    public SSHLauncher(String host, int port, String username, String password, String privatekey, String jvmOptions) {
        this(host, port, username, password, privatekey, jvmOptions, null, null, null);
        LOGGER.warning("This constructor is deprecated and will be removed on next versions, please do not use it.");
    }

    public Object readResolve() {
        if (this.tcpNoDelay == null) {
            this.tcpNoDelay = true;
        }
        if (this.launchTimeoutSeconds == null || this.launchTimeoutSeconds <= 0) {
            this.launchTimeoutSeconds = DEFAULT_LAUNCH_TIMEOUT_SECONDS;
        }
        if (this.maxNumRetries == null) {
            this.maxNumRetries = DEFAULT_MAX_NUM_RETRIES;
        }
        if (this.retryWaitTime == null) {
            this.retryWaitTime = DEFAULT_RETRY_WAIT_TIME;
        }
        return this;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @CheckForNull
    public SshHostKeyVerificationStrategy getSshHostKeyVerificationStrategy() {
        return this.sshHostKeyVerificationStrategy;
    }

    @NonNull
    SshHostKeyVerificationStrategy getSshHostKeyVerificationStrategyDefaulted() {
        return this.sshHostKeyVerificationStrategy != null ? this.sshHostKeyVerificationStrategy : new NonVerifyingKeyVerificationStrategy();
    }

    public StandardUsernameCredentials getCredentials() {
        String credentialsId = this.credentialsId == null ? (this.credentials == null ? null : this.credentials.getId()) : this.credentialsId;
        try {
            StandardUsernameCredentials credentials;
            StandardUsernameCredentials standardUsernameCredentials = credentials = credentialsId != null ? SSHLauncher.lookupSystemCredentials(credentialsId) : null;
            if (credentials != null) {
                this.credentials = credentials;
                return credentials;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.credentials == null && credentialsId == null && (this.username != null || this.password != null || this.privatekey != null)) {
            this.credentials = SSHLauncher.upgrade(this.username, this.password, this.privatekey, this.host);
            this.credentialsId = this.credentials.getId();
        }
        return this.credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static synchronized StandardUsernameCredentials upgrade(String username, Secret password, String privatekey, String description) {
        Object u = SSHLauncher.retrieveExistingCredentials(username = StringUtils.isEmpty((String)username) ? System.getProperty("user.name") : username, password, privatekey);
        if (u != null) {
            return u;
        }
        u = StringUtils.isEmpty((String)privatekey) && (password == null || StringUtils.isEmpty((String)password.getPlainText())) ? new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, null, username, (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.UsersPrivateKeySource(), null, description) : (StringUtils.isNotEmpty((String)privatekey) ? new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, null, username, (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.FileOnMasterPrivateKeySource(privatekey), password == null ? null : password.getEncryptedValue(), MessageFormat.format("{0} - key file: {1}", description, privatekey)) : new UsernamePasswordCredentialsImpl(CredentialsScope.SYSTEM, null, description, username, password == null ? null : password.getEncryptedValue()));
        SecurityContext securityContext = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            CredentialsStore s = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance()).iterator().next();
            try {
                s.addCredentials(Domain.global(), (Credentials)u);
                StandardUsernameCredentials standardUsernameCredentials = u;
                return standardUsernameCredentials;
            }
            catch (IOException iOException) {
                SecurityContextHolder.setContext((SecurityContext)securityContext);
            }
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)securityContext);
        }
        return u;
    }

    private static StandardUsernameCredentials retrieveExistingCredentials(String username, final Secret password, String privatekey) {
        final String privatekeyContent = SSHLauncher.getPrivateKeyContent(password, privatekey);
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)Hudson.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{SSH_SCHEME}), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withUsername((String)username), new CredentialsMatcher(){

            public boolean matches(@NonNull Credentials item) {
                if (item instanceof StandardUsernamePasswordCredentials && password != null && ((StandardUsernamePasswordCredentials)StandardUsernamePasswordCredentials.class.cast(item)).getPassword().equals((Object)password)) {
                    return true;
                }
                if (privatekeyContent != null && item instanceof SSHUserPrivateKey) {
                    for (String key : ((SSHUserPrivateKey)SSHUserPrivateKey.class.cast(item)).getPrivateKeys()) {
                        if (!SSHLauncher.pemKeyEquals(key, privatekeyContent)) continue;
                        return true;
                    }
                }
                return false;
            }
        }}));
    }

    private static boolean pemKeyEquals(String key1, String key2) {
        key1 = StringUtils.trim((String)key1);
        key2 = StringUtils.trim((String)key2);
        return StringUtils.equals((String)key1.replaceAll("\\s+", ""), (String)key2.replace("\\s+", "")) || Arrays.equals(SSHLauncher.quickNDirtyExtract(key1), SSHLauncher.quickNDirtyExtract(key2));
    }

    private static byte[] quickNDirtyExtract(String key) {
        StringBuilder builder = new StringBuilder(key.length());
        boolean begin = false;
        boolean header = false;
        for (String line : StringUtils.split((String)key, (String)"\n")) {
            if ((line = line.trim()).startsWith("---") && line.endsWith("---")) {
                if (begin && line.contains("---END")) break;
                if (!begin && line.contains("---BEGIN")) {
                    header = true;
                    begin = true;
                    continue;
                }
            }
            if (StringUtils.isBlank((String)line)) {
                header = false;
                continue;
            }
            if (header) continue;
            builder.append(line);
        }
        return Base64.decodeBase64((String)builder.toString());
    }

    private static String getPrivateKeyContent(Secret password, String privatekey) {
        if ((privatekey = Util.fixEmpty((String)privatekey)) != null) {
            try {
                File key = new File(privatekey);
                if (key.exists()) {
                    if (PuTTYKey.isPuTTYKeyFile((File)key)) {
                        return Util.fixEmptyAndTrim((String)new PuTTYKey(key, password.getPlainText()).toOpenSSH());
                    }
                    return Util.fixEmptyAndTrim((String)FileUtils.readFileToString((File)key));
                }
            }
            catch (Throwable t) {
                LOGGER.warning("invalid private key file " + privatekey);
            }
        }
        return null;
    }

    public boolean isLaunchSupported() {
        return true;
    }

    public String getJvmOptions() {
        return this.jvmOptions == null ? "" : this.jvmOptions;
    }

    @Restricted(value={NoExternalUse.class})
    public static String getTimestamp() {
        return String.format("[%1$tD %1$tT]", new Date());
    }

    @CheckForNull
    public static String getWorkingDirectory(SlaveComputer computer) {
        return SSHLauncher.getWorkingDirectory(computer.getNode());
    }

    @CheckForNull
    private static String getWorkingDirectory(@CheckForNull Slave agent) {
        if (agent == null) {
            return null;
        }
        String workingDirectory = agent.getRemoteFS();
        while (workingDirectory.endsWith("/")) {
            workingDirectory = workingDirectory.substring(0, workingDirectory.length() - 1);
        }
        return workingDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void launch(final SlaveComputer computer, final TaskListener listener) throws InterruptedException {
        String nodeName;
        this.connection = new Connection(this.host, this.port);
        this.launcherExecutorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamingThreadFactory(Executors.defaultThreadFactory(), "SSHLauncher.launch for '" + computer.getName() + "' node"));
        HashSet<2> callables = new HashSet<2>();
        callables.add(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws InterruptedException {
                Boolean rval = Boolean.FALSE;
                try {
                    String[] preferredKeyAlgorithms = SSHLauncher.this.getSshHostKeyVerificationStrategyDefaulted().getPreferredKeyAlgorithms(computer);
                    if (preferredKeyAlgorithms != null && preferredKeyAlgorithms.length > 0) {
                        SSHLauncher.this.connection.setServerHostKeyAlgorithms(preferredKeyAlgorithms);
                    } else {
                        listener.getLogger().println("Warning: no key algorithms provided; JENKINS-42959 disabled");
                    }
                    listener.getLogger().println(SSHLauncher.this.logConfiguration());
                    SSHLauncher.this.openConnection(listener, computer);
                    SSHLauncher.this.verifyNoHeaderJunk(listener);
                    SSHLauncher.this.reportEnvironment(listener);
                    String workingDirectory = SSHLauncher.getWorkingDirectory(computer);
                    if (workingDirectory == null) {
                        listener.error("Cannot get the working directory for " + computer);
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    String java = null;
                    if (StringUtils.isNotBlank((String)SSHLauncher.this.javaPath)) {
                        java = SSHLauncher.this.expandExpression(computer, SSHLauncher.this.javaPath);
                    } else {
                        JavaVersionChecker javaVersionChecker = new JavaVersionChecker(computer, listener, SSHLauncher.this.getJvmOptions(), SSHLauncher.this.connection);
                        java = javaVersionChecker.resolveJava();
                    }
                    SSHLauncher.this.copyAgentJar(listener, workingDirectory);
                    SSHLauncher.this.startAgent(computer, listener, java, workingDirectory);
                    PluginImpl.register(SSHLauncher.this.connection);
                    rval = Boolean.TRUE;
                    return rval;
                }
                catch (RuntimeException e) {
                    e.printStackTrace(listener.error(Messages.SSHLauncher_UnexpectedError()));
                }
                catch (Error e) {
                    e.printStackTrace(listener.error(Messages.SSHLauncher_UnexpectedError()));
                }
                catch (AbortException e) {
                    listener.getLogger().println(e.getMessage());
                }
                catch (IOException e) {
                    e.printStackTrace(listener.getLogger());
                }
                finally {
                    return rval;
                }
            }
        });
        Slave node = computer.getNode();
        String string = nodeName = node != null ? node.getNodeName() : "unknown";
        if (node != null && this.getTrackCredentials()) {
            CredentialsProvider.track((Node)node, (Credentials)this.getCredentials());
        }
        try {
            Boolean res;
            long time = System.currentTimeMillis();
            ExecutorService srv = this.launcherExecutorService;
            if (srv == null) {
                throw new IllegalStateException("Launcher Executor Service should be always non-null here, because the task allocates and closes service on its own");
            }
            List results = this.getLaunchTimeoutMillis() > 0L ? srv.invokeAll(callables, this.getLaunchTimeoutMillis(), TimeUnit.MILLISECONDS) : srv.invokeAll(callables);
            long duration = System.currentTimeMillis() - time;
            try {
                res = (Boolean)results.get(0).get();
            }
            catch (CancellationException | ExecutionException e) {
                res = Boolean.FALSE;
                e.printStackTrace(listener.error(e.getMessage()));
            }
            if (!res.booleanValue()) {
                System.out.println(Messages.SSHLauncher_LaunchFailedDuration(SSHLauncher.getTimestamp(), nodeName, this.host, duration));
                listener.getLogger().println(SSHLauncher.getTimestamp() + " Launch failed - cleaning up connection");
                this.cleanupConnection(listener);
            } else {
                System.out.println(Messages.SSHLauncher_LaunchCompletedDuration(SSHLauncher.getTimestamp(), nodeName, this.host, duration));
            }
        }
        catch (InterruptedException e) {
            System.out.println(Messages.SSHLauncher_LaunchFailed(SSHLauncher.getTimestamp(), nodeName, this.host));
        }
        finally {
            ExecutorService srv = this.launcherExecutorService;
            if (srv != null) {
                srv.shutdownNow();
                this.launcherExecutorService = null;
            }
        }
    }

    private void cleanupConnection(TaskListener listener) {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
            listener.getLogger().println(Messages.SSHLauncher_ConnectionClosed(SSHLauncher.getTimestamp()));
        }
    }

    private String expandExpression(SlaveComputer computer, String expression) {
        return this.getEnvVars(computer).expand(expression);
    }

    private EnvVars getEnvVars(SlaveComputer computer) {
        EnvVars local;
        EnvVars global = this.getEnvVars(Jenkins.getActiveInstance());
        Slave node = computer.getNode();
        EnvVars envVars = local = node != null ? this.getEnvVars((Node)node) : null;
        if (global != null) {
            if (local != null) {
                EnvVars merged = new EnvVars(global);
                merged.overrideAll((Map)local);
                return merged;
            }
            return global;
        }
        if (local != null) {
            return local;
        }
        return new EnvVars();
    }

    private EnvVars getEnvVars(Jenkins h) {
        return this.getEnvVars(h.getGlobalNodeProperties());
    }

    private EnvVars getEnvVars(Node n) {
        return this.getEnvVars(n.getNodeProperties());
    }

    private EnvVars getEnvVars(DescribableList<NodeProperty<?>, NodePropertyDescriptor> dl) {
        EnvironmentVariablesNodeProperty evnp = (EnvironmentVariablesNodeProperty)dl.get(EnvironmentVariablesNodeProperty.class);
        if (evnp == null) {
            return null;
        }
        return evnp.getEnvVars();
    }

    private void verifyNoHeaderJunk(TaskListener listener) throws IOException, InterruptedException {
        String s;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.connection.exec("exit 0", (OutputStream)baos);
        try {
            s = baos.toString(Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException("Default encoding is unsupported", ex);
        }
        if (s.length() != 0) {
            listener.getLogger().println(Messages.SSHLauncher_SSHHeaderJunkDetected());
            listener.getLogger().println(s);
            throw new AbortException();
        }
    }

    private void startAgent(SlaveComputer computer, TaskListener listener, String java, String workingDirectory) throws IOException {
        this.session = this.connection.openSession();
        this.expandChannelBufferSize(this.session, listener);
        String cmd = "cd \"" + workingDirectory + "\" && " + java + " " + this.getJvmOptions() + " -jar " + AGENT_JAR + this.getWorkDirParam(workingDirectory);
        cmd = this.getPrefixStartSlaveCmd() + cmd + this.getSuffixStartSlaveCmd();
        listener.getLogger().println(Messages.SSHLauncher_StartingAgentProcess(SSHLauncher.getTimestamp(), cmd));
        this.session.execCommand(cmd);
        this.session.pipeStderr((OutputStream)new DelegateNoCloseOutputStream(listener.getLogger()));
        try {
            computer.setChannel(this.session.getStdout(), this.session.getStdin(), (OutputStream)listener.getLogger(), null);
        }
        catch (InterruptedException e) {
            this.session.close();
            throw new IOException(Messages.SSHLauncher_AbortedDuringConnectionOpen(), e);
        }
        catch (IOException e) {
            try {
                throw new AbortException(this.getSessionOutcomeMessage(this.session, false));
            }
            catch (InterruptedException x) {
                throw new IOException(e);
            }
        }
    }

    private void expandChannelBufferSize(Session session, TaskListener listener) {
        int sz = 4;
        session.setWindowSize(sz * 1024 * 1024);
        listener.getLogger().println("Expanded the channel window size to " + sz + "MB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAgentJar(TaskListener listener, String workingDirectory) throws IOException, InterruptedException {
        block22: {
            String fileName = workingDirectory + SLASH_AGENT_JAR;
            listener.getLogger().println(Messages.SSHLauncher_StartingSFTPClient(SSHLauncher.getTimestamp()));
            try (SFTPClient sftpClient = null;){
                sftpClient = new SFTPClient(this.connection);
                try {
                    SFTPv3FileAttributes fileAttributes = sftpClient._stat(workingDirectory);
                    if (fileAttributes == null) {
                        listener.getLogger().println(Messages.SSHLauncher_RemoteFSDoesNotExist(SSHLauncher.getTimestamp(), workingDirectory));
                        sftpClient.mkdirs(workingDirectory, 448);
                    } else if (fileAttributes.isRegularFile()) {
                        throw new IOException(Messages.SSHLauncher_RemoteFSIsAFile(workingDirectory));
                    }
                    try {
                        sftpClient.rm(fileName);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    listener.getLogger().println(Messages.SSHLauncher_CopyingAgentJar(SSHLauncher.getTimestamp()));
                    try {
                        byte[] agentJar = new Slave.JnlpJar(AGENT_JAR).readFully();
                        try (OutputStream os = sftpClient.writeToFile(fileName);){
                            os.write(agentJar);
                        }
                        listener.getLogger().println(Messages.SSHLauncher_CopiedXXXBytes(SSHLauncher.getTimestamp(), agentJar.length));
                    }
                    catch (Error error) {
                        throw error;
                    }
                    catch (Throwable e) {
                        throw new IOException(Messages.SSHLauncher_ErrorCopyingAgentJarTo(fileName), e);
                    }
                }
                catch (Error error) {
                    throw error;
                }
                catch (Throwable e) {
                    throw new IOException(Messages.SSHLauncher_ErrorCopyingAgentJarInto(workingDirectory), e);
                }
            }
        }
    }

    private void copySlaveJarUsingSCP(TaskListener listener, String workingDirectory) throws IOException, InterruptedException {
        SCPClient scp = new SCPClient(this.connection);
        try {
            if (this.connection.exec("test -d " + workingDirectory, (OutputStream)listener.getLogger()) != 0) {
                listener.getLogger().println(Messages.SSHLauncher_RemoteFSDoesNotExist(SSHLauncher.getTimestamp(), workingDirectory));
                if (this.connection.exec("mkdir -p " + workingDirectory, (OutputStream)listener.getLogger()) != 0) {
                    listener.getLogger().println("Failed to create " + workingDirectory);
                }
            }
            this.connection.exec("rm " + workingDirectory + SLASH_AGENT_JAR, (OutputStream)new NullStream());
            listener.getLogger().println(Messages.SSHLauncher_CopyingAgentJar(SSHLauncher.getTimestamp()));
            scp.put(new Slave.JnlpJar(AGENT_JAR).readFully(), AGENT_JAR, workingDirectory, "0644");
        }
        catch (IOException e) {
            throw new IOException(Messages.SSHLauncher_ErrorCopyingAgentJarInto(workingDirectory), e);
        }
    }

    protected void reportEnvironment(TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println(Messages._SSHLauncher_RemoteUserEnvironment(SSHLauncher.getTimestamp()));
        this.connection.exec("set", (OutputStream)listener.getLogger());
    }

    protected void openConnection(final TaskListener listener, final SlaveComputer computer) throws IOException, InterruptedException {
        StandardUsernameCredentials credentials;
        PrintStream logger = listener.getLogger();
        logger.println(Messages.SSHLauncher_OpeningSSHConnection(SSHLauncher.getTimestamp(), this.host + ":" + this.port));
        this.connection.setTCPNoDelay(this.getTcpNoDelay());
        int maxNumRetries = this.getMaxNumRetries();
        for (int i = 0; i <= maxNumRetries; ++i) {
            try {
                int launchTimeoutMillis = (int)this.getLaunchTimeoutMillis();
                this.connection.connect(new ServerHostKeyVerifier(){

                    public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
                        HostKey key = new HostKey(serverHostKeyAlgorithm, serverHostKey);
                        return SSHLauncher.this.getSshHostKeyVerificationStrategyDefaulted().verify(computer, key, listener);
                    }
                }, launchTimeoutMillis, 0, launchTimeoutMillis);
                break;
            }
            catch (IOException ioexception) {
                String message = "";
                Throwable cause = ioexception.getCause();
                if (cause != null) {
                    message = cause.getMessage();
                    logger.println(message);
                }
                if (cause == null || !this.isRecoverable(message)) {
                    throw ioexception;
                }
                if (maxNumRetries - i <= 0) {
                    logger.println("SSH Connection failed with IOException: \"" + message + "\".");
                    throw ioexception;
                }
                logger.println("SSH Connection failed with IOException: \"" + message + "\", retrying in " + this.getRetryWaitTime() + " seconds.  There are " + (maxNumRetries - i) + " more retries left.");
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.getRetryWaitTime().intValue()));
                continue;
            }
        }
        if ((credentials = this.getCredentials()) == null) {
            throw new AbortException("Cannot find SSH User credentials with id: " + this.credentialsId);
        }
        if (!SSHAuthenticator.newInstance((Object)this.connection, (StandardUsernameCredentials)credentials).authenticate(listener) || !this.connection.isAuthenticationComplete()) {
            logger.println(Messages.SSHLauncher_AuthenticationFailed(SSHLauncher.getTimestamp()));
            throw new AbortException(Messages.SSHLauncher_AuthenticationFailedException());
        }
        logger.println(Messages.SSHLauncher_AuthenticationSuccessful(SSHLauncher.getTimestamp()));
    }

    private boolean isRecoverable(@CheckForNull String message) {
        if (message == null) {
            return false;
        }
        for (String s : RECOVERABLE_FAILURES) {
            if (!message.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public void afterDisconnect(SlaveComputer slaveComputer, TaskListener listener) {
        if (this.connection == null) {
            return;
        }
        ExecutorService srv = this.launcherExecutorService;
        if (srv != null) {
            srv.shutdown();
        }
        if (this.tearingDownConnection) {
            LOGGER.log(Level.FINE, "There is already a tear down operation in progress for connection {0}. Skipping the call", this.connection);
            return;
        }
        this.tearDownConnection(slaveComputer, listener);
    }

    private synchronized void tearDownConnection(@NonNull SlaveComputer slaveComputer, @NonNull TaskListener listener) {
        if (this.connection != null) {
            this.tearDownConnectionImpl(slaveComputer, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tearDownConnectionImpl(@NonNull SlaveComputer slaveComputer, final @NonNull TaskListener listener) {
        try {
            Slave n;
            this.tearingDownConnection = true;
            boolean connectionLost = this.reportTransportLoss(this.connection, listener);
            if (this.session != null) {
                try {
                    listener.getLogger().println(this.getSessionOutcomeMessage(this.session, connectionLost));
                    this.session.getStdout().close();
                    this.session.close();
                }
                catch (Throwable t) {
                    t.printStackTrace(listener.error(Messages.SSHLauncher_ErrorWhileClosingConnection()));
                }
                this.session = null;
            }
            if ((n = slaveComputer.getNode()) != null && !connectionLost) {
                String workingDirectory = SSHLauncher.getWorkingDirectory(n);
                final String fileName = workingDirectory + SLASH_AGENT_JAR;
                Future<?> tidyUp = Computer.threadPoolForRemoting.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block10: {
                            try (SFTPv3Client sftpClient = null;){
                                sftpClient = new SFTPv3Client(SSHLauncher.this.connection);
                                sftpClient.rm(fileName);
                            }
                        }
                    }
                });
                try {
                    tidyUp.get(this.getLaunchTimeoutMillis(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace(listener.error(Messages.SSHLauncher_ErrorDeletingFile(SSHLauncher.getTimestamp())));
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    e.printStackTrace(listener.error(Messages.SSHLauncher_ErrorDeletingFile(SSHLauncher.getTimestamp())));
                }
                catch (TimeoutException e) {
                    e.printStackTrace(listener.error(Messages.SSHLauncher_ErrorDeletingFile(SSHLauncher.getTimestamp())));
                }
                finally {
                    if (!tidyUp.isDone()) {
                        tidyUp.cancel(true);
                    }
                }
            }
            PluginImpl.unregister(this.connection);
            this.cleanupConnection(listener);
        }
        finally {
            this.tearingDownConnection = false;
        }
    }

    private boolean reportTransportLoss(Connection c, TaskListener listener) {
        Throwable cause = c.getReasonClosedCause();
        if (cause != null) {
            cause.printStackTrace(listener.error("Socket connection to SSH server was lost"));
        }
        return cause != null;
    }

    private String getSessionOutcomeMessage(Session session, boolean isConnectionLost) throws InterruptedException {
        session.waitForCondition(96, 3000L);
        Integer exitCode = session.getExitStatus();
        if (exitCode != null) {
            return "Slave JVM has terminated. Exit code=" + exitCode;
        }
        String sig = session.getExitSignal();
        if (sig != null) {
            return "Slave JVM has terminated. Exit signal=" + sig;
        }
        if (isConnectionLost) {
            return "Slave JVM has not reported exit code before the socket was lost";
        }
        return "Slave JVM has not reported exit code. Is it still running?";
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Deprecated
    public String getUsername() {
        return this.username;
    }

    @Deprecated
    public String getPassword() {
        return this.password != null ? Secret.toString((Secret)this.password) : null;
    }

    @Deprecated
    public String getPrivatekey() {
        return this.privatekey;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @NonNull
    public String getPrefixStartSlaveCmd() {
        return Util.fixNull((String)this.prefixStartSlaveCmd);
    }

    @NonNull
    public String getSuffixStartSlaveCmd() {
        return Util.fixNull((String)this.suffixStartSlaveCmd);
    }

    @NonNull
    public Integer getLaunchTimeoutSeconds() {
        return this.launchTimeoutSeconds;
    }

    private long getLaunchTimeoutMillis() {
        return this.launchTimeoutSeconds == null || this.launchTimeoutSeconds < 0 ? (long)DEFAULT_LAUNCH_TIMEOUT_SECONDS.intValue() : TimeUnit.SECONDS.toMillis(this.launchTimeoutSeconds.intValue());
    }

    @NonNull
    public Integer getMaxNumRetries() {
        return this.maxNumRetries == null || this.maxNumRetries < 0 ? DEFAULT_MAX_NUM_RETRIES : this.maxNumRetries;
    }

    @NonNull
    public Integer getRetryWaitTime() {
        return this.retryWaitTime == null || this.retryWaitTime == 0 ? DEFAULT_RETRY_WAIT_TIME : this.retryWaitTime;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay != null ? this.tcpNoDelay : true;
    }

    @DataBoundSetter
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean getTrackCredentials() {
        String trackCredentials = System.getProperty(SSHLauncher.class.getName() + ".trackCredentials");
        return !"false".equalsIgnoreCase(trackCredentials);
    }

    public String getWorkDir() {
        return this.workDir;
    }

    @DataBoundSetter
    public void setWorkDir(String workDir) {
        this.workDir = Util.fixEmptyAndTrim((String)workDir);
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public String getWorkDirParam(@NonNull String workingDirectory) {
        String ret = this.getSuffixStartSlaveCmd().contains(WORK_DIR_PARAM) ? "" : (StringUtils.isNotBlank((String)this.getWorkDir()) ? WORK_DIR_PARAM + this.getWorkDir() : WORK_DIR_PARAM + workingDirectory);
        return ret;
    }

    public String logConfiguration() {
        StringBuilder sb = new StringBuilder("SSHLauncher{");
        sb.append("host='").append(this.getHost()).append('\'');
        sb.append(", port=").append(this.getPort());
        sb.append(", credentialsId='").append(Util.fixNull((String)this.credentialsId)).append('\'');
        sb.append(", jvmOptions='").append(this.getJvmOptions()).append('\'');
        sb.append(", javaPath='").append(Util.fixNull((String)this.javaPath)).append('\'');
        sb.append(", prefixStartSlaveCmd='").append(this.getPrefixStartSlaveCmd()).append('\'');
        sb.append(", suffixStartSlaveCmd='").append(this.getSuffixStartSlaveCmd()).append('\'');
        sb.append(", launchTimeoutSeconds=").append(this.getLaunchTimeoutSeconds());
        sb.append(", maxNumRetries=").append(this.getMaxNumRetries());
        sb.append(", retryWaitTime=").append(this.getRetryWaitTime());
        sb.append(", sshHostKeyVerificationStrategy=").append(this.sshHostKeyVerificationStrategy != null ? this.sshHostKeyVerificationStrategy.getClass().getName() : "None");
        sb.append(", tcpNoDelay=").append(this.getTcpNoDelay());
        sb.append(", trackCredentials=").append(this.getTrackCredentials());
        sb.append('}');
        return sb.toString();
    }

    private static class DelegateNoCloseOutputStream
    extends OutputStream {
        private OutputStream out;

        public DelegateNoCloseOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.out != null) {
                this.out.write(b);
            }
        }

        @Override
        public void close() throws IOException {
            this.out = null;
        }

        @Override
        public void flush() throws IOException {
            if (this.out != null) {
                this.out.flush();
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.out != null) {
                this.out.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.out != null) {
                this.out.write(b, off, len);
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public String getDisplayName() {
            return Messages.SSHLauncher_DescriptorDisplayName();
        }

        public Class getSshConnectorClass() {
            return SSHConnector.class;
        }

        public String getHelpFile(String fieldName) {
            String n = super.getHelpFile(fieldName);
            if (n == null) {
                n = Jenkins.getActiveInstance().getDescriptorOrDie(SSHConnector.class).getHelpFile(fieldName);
            }
            return n;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context, @QueryParameter String host, @QueryParameter String port, @QueryParameter String credentialsId) {
            Jenkins _context;
            Object object = _context = context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance();
            if (_context == null || !_context.hasPermission(Computer.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
            }
            try {
                int portValue = Integer.parseInt(port);
                return new StandardUsernameListBoxModel().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.getActiveInstance(), StandardUsernameCredentials.class, Collections.singletonList(new HostnamePortRequirement(host, portValue)), SSHAuthenticator.matcher(Connection.class)).includeCurrentValue(credentialsId);
            }
            catch (NumberFormatException ex) {
                return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
            }
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath ItemGroup context, @QueryParameter String host, @QueryParameter String port, @QueryParameter String value) {
            Jenkins _context;
            Object object = _context = context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance();
            if (_context == null || !_context.hasPermission(Computer.CONFIGURE)) {
                return FormValidation.ok();
            }
            try {
                int portValue = Integer.parseInt(port);
                for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernameCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, Collections.singletonList(new HostnamePortRequirement(host, portValue)), (CredentialsMatcher)SSHAuthenticator.matcher(Connection.class))) {
                    if (!StringUtils.equals((String)value, (String)o.value)) continue;
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.warning((Throwable)e, (String)Messages.SSHLauncher_PortNotANumber());
            }
            return FormValidation.error((String)Messages.SSHLauncher_SelectedCredentialsMissing());
        }

        public FormValidation doCheckPort(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)Messages.SSHLauncher_PortNotSpecified());
            }
            try {
                int portValue = Integer.parseInt(value);
                if (portValue <= 0) {
                    return FormValidation.error((String)Messages.SSHLauncher_PortLessThanZero());
                }
                if (portValue >= 65536) {
                    return FormValidation.error((String)Messages.SSHLauncher_PortMoreThan65535());
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((Throwable)e, (String)Messages.SSHLauncher_PortNotANumber());
            }
        }
    }
}

