/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sqlplus.script.runner;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.sqlplus.script.runner.SQLPlusRunner;
import org.jenkinsci.plugins.sqlplus.script.runner.ScriptType;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

@Symbol(value={"sqlplusrunner"})
@SuppressFBWarnings
public class SQLPlusRunnerBuilder
extends Builder
implements SimpleBuildStep {
    private final String credentialsId;
    private final String user;
    private final String password;
    private final String instance;
    private final String scriptType;
    private final String script;
    private final String scriptContent;
    private String customOracleHome;
    private String customSQLPlusHome;
    private String customTNSAdmin;

    @DataBoundConstructor
    public SQLPlusRunnerBuilder(String credentialsId, String instance, String scriptType, String script, String scriptContent) {
        this.credentialsId = credentialsId;
        this.user = null;
        this.password = null;
        this.instance = instance;
        this.scriptType = scriptType;
        this.script = script;
        this.scriptContent = scriptContent;
    }

    public SQLPlusRunnerBuilder(String credentialsId, String instance, String scriptType, String script, String scriptContent, String customOracleHome, String customSQLPlusHome, String customTNSAdmin) {
        this.credentialsId = credentialsId;
        this.user = null;
        this.password = null;
        this.instance = instance;
        this.scriptType = scriptType;
        this.script = script;
        this.scriptContent = scriptContent;
        this.customOracleHome = customOracleHome;
        this.customSQLPlusHome = customSQLPlusHome;
        this.customTNSAdmin = customTNSAdmin;
    }

    @DataBoundSetter
    public void setCustomOracleHome(String customOracleHome) {
        this.customOracleHome = customOracleHome;
    }

    @DataBoundSetter
    public void setCustomSQLPlusHome(String customSQLPlusHome) {
        this.customSQLPlusHome = customSQLPlusHome;
    }

    @DataBoundSetter
    public void setCustomTNSAdmin(String customTNSAdmin) {
        this.customTNSAdmin = customTNSAdmin;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getScriptType() {
        return this.scriptType;
    }

    public String getScript() {
        return this.script;
    }

    public String getScriptContent() {
        return this.scriptContent;
    }

    public String getCustomOracleHome() {
        return this.customOracleHome;
    }

    public String getCustomSQLPlusHome() {
        return this.customSQLPlusHome;
    }

    public String getCustomTNSAdmin() {
        return this.customTNSAdmin;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        CredentialsMatcher credentialsMatcher;
        String sqlScript = ScriptType.userDefined.name().equals(this.scriptType) ? this.scriptContent : this.script;
        List lookupCredentials = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{null, null});
        StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)lookupCredentials, (CredentialsMatcher)(credentialsMatcher = CredentialsMatchers.withId((String)this.credentialsId)));
        if (credentials == null && this.user == null) {
            throw new AbortException("Invalid credentials " + this.credentialsId + ". Failed to initialize credentials or load user and pass");
        }
        Secret password = credentials.getPassword();
        String usr = credentials == null ? this.user : credentials.getUsername();
        String pwd = credentials == null ? this.password : password.getPlainText();
        EnvVars env = build.getEnvironment(listener);
        SQLPlusRunner sqlPlusRunner = new SQLPlusRunner(build, listener, launcher, workspace, this.getDescriptor().isHideSQLPlusVersion(), usr, pwd, env.expand(this.instance), env.expand(sqlScript), this.getDescriptor().globalOracleHome, this.getDescriptor().globalSQLPlusHome, this.getDescriptor().globalTNSAdmin, this.scriptType, this.customOracleHome, this.customSQLPlusHome, this.customTNSAdmin, this.getDescriptor().tryToDetectOracleHome, this.getDescriptor().isDebug());
        try {
            sqlPlusRunner.run();
        }
        catch (Exception e) {
            e.printStackTrace(listener.getLogger());
            throw new AbortException(e.getMessage());
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private static final String DISPLAY_MESSAGE = "SQLPlus Script Runner";
        private static final String GLOBAL_ORACLE_HOME = "globalOracleHome";
        private static final String GLOBAL_SQLPLUS_HOME = "globalSQLPlusHome";
        private static final String GLOBAL_TNS_ADMIN = "globalTNSAdmin";
        private static final String HIDE_SQL_PLUS_VERSION = "hideSQLPlusVersion";
        private static final String TRY_TO_DETECT_ORACLE_HOME = "tryToDetectOracleHome";
        private static final String DEBUG = "debug";
        private boolean hideSQLPlusVersion;
        private boolean tryToDetectOracleHome;
        private boolean debug;
        private String globalOracleHome;
        private String globalSQLPlusHome;
        private String globalTNSAdmin;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return DISPLAY_MESSAGE;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.hideSQLPlusVersion = formData.getBoolean(HIDE_SQL_PLUS_VERSION);
            this.globalOracleHome = formData.getString(GLOBAL_ORACLE_HOME);
            this.globalSQLPlusHome = formData.getString(GLOBAL_SQLPLUS_HOME);
            this.globalTNSAdmin = formData.getString(GLOBAL_TNS_ADMIN);
            this.tryToDetectOracleHome = formData.getBoolean(TRY_TO_DETECT_ORACLE_HOME);
            this.debug = formData.getBoolean(DEBUG);
            this.save();
            return super.configure(req, formData);
        }

        public boolean isHideSQLPlusVersion() {
            return this.hideSQLPlusVersion;
        }

        public void setHideSQLPlusVersion(boolean hideSQLPlusVersion) {
            this.hideSQLPlusVersion = hideSQLPlusVersion;
        }

        public boolean isTryToDetectOracleHome() {
            return this.tryToDetectOracleHome;
        }

        public void setTryToDetectOracleHome(boolean tryToDetectOracleHome) {
            this.tryToDetectOracleHome = tryToDetectOracleHome;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public String getOracleHome() {
            return this.globalOracleHome;
        }

        public void setOracleHome(String globalOracleHome) {
            this.globalOracleHome = globalOracleHome;
        }

        public String getGlobalSQLPlusHome() {
            return this.globalSQLPlusHome;
        }

        public void setGlobalSQLPlusHome(String globalSQLPlusHome) {
            this.globalSQLPlusHome = globalSQLPlusHome;
        }

        public String getGlobalTNSAdmin() {
            return this.globalTNSAdmin;
        }

        public void setGlobalTNSAdmin(String globalTNSAdmin) {
            this.globalTNSAdmin = globalTNSAdmin;
        }

        public String getGlobalOracleHome() {
            return this.globalOracleHome;
        }

        public void setGlobalOracleHome(String globalOracleHome) {
            this.globalOracleHome = globalOracleHome;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup<?> context) {
            if (!(context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance()).hasPermission(Computer.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardUsernameListBoxModel().withMatching(new CredentialsMatcher(){
                private static final long serialVersionUID = 1L;

                public boolean matches(Credentials item) {
                    return item instanceof UsernamePasswordCredentialsImpl;
                }
            }, (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{null, null}));
        }
    }
}

