/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sqlplus.script.runner;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.LocalChannel;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.jenkinsci.plugins.sqlplus.script.runner.FileUtil;
import org.jenkinsci.plugins.sqlplus.script.runner.Messages;
import org.jenkinsci.plugins.sqlplus.script.runner.NetUtil;
import org.jenkinsci.plugins.sqlplus.script.runner.ScriptType;

@SuppressFBWarnings
public class SQLPlusRunner
implements Serializable {
    private static final String FOUND_SQL_PLUS_ON = "found SQL*Plus on ";
    private static final String WINDOWS_FILE_SEPARATOR = "\\";
    private static final long serialVersionUID = -310945626014565712L;
    private static final String WINDOWS_OS = "win";
    private static final String OPERATION_SYSTEM = "os.name";
    private static final String OPERATION_SYSTEM_SLAVE = "OS";
    private static final String MSG_TEMP_SCRIPT = Messages.SQLPlusRunner_tempScript();
    private static final String ON = Messages.SQLPlusRunner_on();
    private static final String MSG_ORACLE_HOME = Messages.SQLPlusRunner_usingOracleHome();
    private static final String MSG_SCRIPT = Messages.SQLPlusRunner_runningScript();
    private static final String MSG_DEFINED_SCRIPT = Messages.SQLPlusRunner_runningDefinedScript();
    private static final String AT = "@";
    private static final String SLASH = "/";
    private static final String DOUBLE_QUOTES = "\"";
    private static final String MSG_ERROR = Messages.SQLPlusRunner_error();
    private static final String MSG_GET_SQL_PLUS_VERSION = Messages.SQLPlusRunner_gettingSQLPlusVersion();
    private static final String MSG_ORACLE_HOME_MISSING = Messages.SQLPlusRunner_missingOracleHome();
    private static final String MSG_GET_ORACLE_HOME = Messages.SQLPlusRunner_gettingOracleHome();
    private static final String MSG_CUSTOM_ORACLE_HOME = Messages.SQLPlusRunner_usingCustomOracleHome();
    private static final String MSG_CUSTOM_SQLPLUS_HOME = Messages.SQLPlusRunner_usingCustomSQLPlusHome();
    private static final String MSG_CUSTOM_TNS_ADMIN = Messages.SQLPlusRunner_usingCustomTNSAdmin();
    private static final String MSG_GLOBAL_ORACLE_HOME = Messages.SQLPlusRunner_usingGlobalOracleHome();
    private static final String MSG_GLOBAL_SQLPLUS_HOME = Messages.SQLPlusRunner_usingGlobalSQLPlusHome();
    private static final String MSG_GLOBAL_TNS_ADMIN = Messages.SQLPlusRunner_usingGlobalTNSAdmin();
    private static final String MSG_USING_DETECTED_ORACLE_HOME = Messages.SQLPlusRunner_usingDetectedOracleHome();
    private static final String MSG_GLOBAL_ORACLE_HOME_SELECTED = Messages.SQLPlusRunner_globalOracleHomeSelected();
    private static final String MSG_GLOBAL_SQLPLUS_HOME_SELECTED = Messages.SQLPlusRunner_globalSQLPlusHomeSelected();
    private static final String MSG_GLOBAL_TNS_ADMIN_SELECTED = Messages.SQLPlusRunner_globalTNSAdminSelected();
    private static final String MSG_TRY_DETECTED_ORACLE_HOME = Messages.SQLPlusRunner_tryToDetectOracleHome();
    private static final String MSG_GLOBAL_ORACLE_HOME_SELECTED_ANYWAY = Messages.SQLPlusRunner_globalOracleHomeSelectedAnyway();
    private static final String LOCAL_DATABASE_MSG = "local";
    private static final String DEBUG_MSG = "[DEBUG] ";
    private static final String HIDDEN_PASSWORD = "********";
    private static final String LINE = Messages.SQLPlusRunner_line();
    private static final String LIB_DIR = "lib";
    private static final String BIN_DIR = "bin";
    private static final String NET_DIR = "network";
    private static final String NET_ADM_DIR = "admin";
    private static final String ENV_LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String ENV_ORACLE_HOME = "ORACLE_HOME";
    private static final String ENV_TNS_ADMIN = "TNS_ADMIN";
    private static final String SQLPLUS_TRY_LOGIN_JUST_ONCE = "-L";
    private static final String SQLPLUS_VERSION = "-v";
    private static final String SQLPLUS = "sqlplus";
    private static final String SQLPLUS_FOR_WINDOWS = "sqlplus.exe";
    private static final String TNSNAMES_ORA = "tnsnames.ora";
    private static final int PROCESS_EXIT_CODE_SUCCESSFUL = 0;
    private final Run<?, ?> build;
    private final TaskListener listener;
    private final Launcher launcher;
    private final FilePath workspace;
    private final boolean isHideSQLPlusVersion;
    private final String user;
    private final String password;
    private final String instance;
    private String script;
    private String globalOracleHome;
    private String globalSQLPlusHome;
    private String globalTNSAdmin;
    private String customOracleHome;
    private String customSQLPlusHome;
    private String customTNSAdmin;
    private String scriptType;
    private final boolean tryToDetectOracleHome;
    private final boolean debug;

    public SQLPlusRunner(Run<?, ?> build, TaskListener listener, Launcher launcher, FilePath workspace, boolean isHideSQLPlusVersion, String user, String password, String instance, String script, String globalOracleHome, String globalSQLPlusHome, String globalTNSAdmin, String scriptType, String customOracleHome, String customSQLPlusHome, String customTNSAdmin, boolean tryToDetectOracleHome, boolean debug) {
        this.build = build;
        this.listener = listener;
        this.launcher = launcher;
        this.workspace = workspace;
        this.isHideSQLPlusVersion = isHideSQLPlusVersion;
        this.user = user;
        this.password = password;
        this.instance = instance;
        this.script = script;
        this.globalOracleHome = globalOracleHome;
        this.globalSQLPlusHome = globalSQLPlusHome;
        this.globalTNSAdmin = globalTNSAdmin;
        this.scriptType = scriptType;
        this.customOracleHome = customOracleHome;
        this.customSQLPlusHome = customSQLPlusHome;
        this.customTNSAdmin = customTNSAdmin;
        this.tryToDetectOracleHome = tryToDetectOracleHome;
        this.debug = debug;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() throws IOException, InterruptedException {
        String selectedOracleHome = null;
        String detectedOracleHome = null;
        boolean slaveMachine = this.isSlaveMachine(this.launcher);
        this.listener.getLogger().println(LINE);
        this.listener.getLogger().println(MSG_GET_ORACLE_HOME);
        if (this.customSQLPlusHome != null && this.customSQLPlusHome.length() > 0) {
            this.listener.getLogger().println(MSG_CUSTOM_SQLPLUS_HOME);
            this.listener.getLogger().println("SQL*Plus >>> " + this.customSQLPlusHome);
        } else if (this.globalSQLPlusHome != null && this.globalSQLPlusHome.length() > 0) {
            if (this.debug) {
                this.listener.getLogger().println(DEBUG_MSG + MSG_GLOBAL_SQLPLUS_HOME_SELECTED);
            }
            this.listener.getLogger().println(LINE);
            this.listener.getLogger().println(MSG_GLOBAL_SQLPLUS_HOME);
            this.customSQLPlusHome = this.globalSQLPlusHome;
        }
        boolean hasCustomTNSAdmin = false;
        if (this.customTNSAdmin != null && this.customTNSAdmin.length() > 0) {
            this.listener.getLogger().println(MSG_CUSTOM_TNS_ADMIN);
            this.listener.getLogger().println("TNS_ADMIN >>> " + this.customTNSAdmin);
            hasCustomTNSAdmin = true;
        } else if (this.globalTNSAdmin != null && this.globalTNSAdmin.length() > 0) {
            if (this.debug) {
                this.listener.getLogger().println(DEBUG_MSG + MSG_GLOBAL_TNS_ADMIN_SELECTED);
            }
            this.listener.getLogger().println(LINE);
            this.listener.getLogger().println(MSG_GLOBAL_TNS_ADMIN);
            this.customTNSAdmin = this.globalTNSAdmin;
            hasCustomTNSAdmin = true;
            this.listener.getLogger().println("TNS_ADMIN >>> " + this.customTNSAdmin);
        }
        detectedOracleHome = (String)this.build.getEnvironment(this.listener).get((Object)ENV_ORACLE_HOME);
        if (this.customOracleHome != null && this.customOracleHome.length() > 0) {
            if (this.debug) {
                this.listener.getLogger().println(DEBUG_MSG + MSG_CUSTOM_ORACLE_HOME);
            }
            this.listener.getLogger().println(LINE);
            this.listener.getLogger().println(MSG_CUSTOM_ORACLE_HOME);
            selectedOracleHome = this.customOracleHome;
        } else if (this.globalOracleHome != null && this.globalOracleHome.length() > 0) {
            if (this.debug) {
                this.listener.getLogger().println(DEBUG_MSG + MSG_GLOBAL_ORACLE_HOME_SELECTED);
            }
            this.listener.getLogger().println(LINE);
            this.listener.getLogger().println(MSG_GLOBAL_ORACLE_HOME);
            selectedOracleHome = this.globalOracleHome;
        } else if (this.tryToDetectOracleHome && detectedOracleHome != null) {
            if (this.debug) {
                this.listener.getLogger().println(DEBUG_MSG + MSG_TRY_DETECTED_ORACLE_HOME);
            }
            this.listener.getLogger().println(LINE);
            this.listener.getLogger().println(MSG_USING_DETECTED_ORACLE_HOME);
            selectedOracleHome = detectedOracleHome;
        } else {
            if (this.debug) {
                this.listener.getLogger().println(DEBUG_MSG + MSG_GLOBAL_ORACLE_HOME_SELECTED_ANYWAY);
            }
            selectedOracleHome = this.globalOracleHome;
        }
        if (!this.isHideSQLPlusVersion) {
            this.runGetSQLPLusVersion(this.customSQLPlusHome, selectedOracleHome, this.listener, this.launcher);
        }
        if (this.debug) {
            this.listener.getLogger().println(" detected host = " + NetUtil.getHostName());
        }
        if (selectedOracleHome == null || selectedOracleHome.length() < 1) {
            throw new RuntimeException(MSG_ORACLE_HOME_MISSING);
        }
        boolean hasCustomSQLPlusHome = false;
        if (this.customSQLPlusHome != null && this.customSQLPlusHome.length() > 0) {
            hasCustomSQLPlusHome = true;
        }
        if (!slaveMachine && !hasCustomSQLPlusHome) {
            File directoryAccessTest = new File(selectedOracleHome);
            if (this.debug) {
                this.listener.getLogger().println("[DEBUG] testing directory " + directoryAccessTest.getAbsolutePath());
            }
            if (!directoryAccessTest.exists()) {
                throw new RuntimeException(Messages.SQLPlusRunner_wrongOracleHome(selectedOracleHome));
            }
        }
        if (this.script == null || this.script.length() < 1) {
            throw new RuntimeException(Messages.SQLPlusRunner_missingScript(this.workspace));
        }
        String instanceStr = LOCAL_DATABASE_MSG;
        if (this.instance != null) {
            instanceStr = this.instance;
        }
        this.listener.getLogger().println(LINE);
        this.listener.getLogger().println(MSG_ORACLE_HOME + selectedOracleHome);
        this.listener.getLogger().println(LINE);
        String sqlplus = SQLPLUS;
        String fileSeparator = File.separator;
        if (this.isWindowsOS(slaveMachine)) {
            sqlplus = SQLPLUS_FOR_WINDOWS;
            fileSeparator = WINDOWS_FILE_SEPARATOR;
        }
        FilePath tempScript = null;
        FilePath scriptFilePath = null;
        if (ScriptType.userDefined.name().equals(this.scriptType)) {
            this.listener.getLogger().println(MSG_DEFINED_SCRIPT + " " + this.user + SLASH + HIDDEN_PASSWORD + AT + instanceStr);
            tempScript = scriptFilePath = FileUtil.createTempScript(this.build, this.workspace, this.script, slaveMachine);
            this.listener.getLogger().println(MSG_TEMP_SCRIPT + " " + scriptFilePath.absolutize().toURI());
        } else {
            String strScript = null;
            if (slaveMachine) {
                scriptFilePath = new FilePath(new File(this.workspace.getRemote() + fileSeparator + this.script));
            } else if (this.workspace != null && (strScript = this.workspace + fileSeparator + this.script) != null) {
                scriptFilePath = new FilePath(new File(strScript));
            }
            if (scriptFilePath != null) {
                this.listener.getLogger().println(MSG_SCRIPT + " " + scriptFilePath.getRemote() + " " + ON + " " + this.user + SLASH + HIDDEN_PASSWORD + AT + instanceStr);
            }
            if (this.debug) {
                this.listener.getLogger().println("[DEBUG] testing script " + scriptFilePath.getRemote());
            }
            if (!slaveMachine && scriptFilePath != null && !scriptFilePath.exists()) {
                throw new RuntimeException(Messages.SQLPlusRunner_missingScript(scriptFilePath.getRemote()));
            }
            if (!slaveMachine && scriptFilePath != null && !FileUtil.hasExitCode(scriptFilePath)) {
                FileUtil.addExitInTheEnd(scriptFilePath);
            }
        }
        this.listener.getLogger().println(LINE);
        int exitCode = 0;
        try {
            EnvVars envVars = new EnvVars();
            envVars.put(ENV_ORACLE_HOME, selectedOracleHome);
            if (this.debug) {
                this.listener.getLogger().println("[DEBUG] ORACLE_HOME = " + selectedOracleHome);
            }
            envVars.put(ENV_LD_LIBRARY_PATH, selectedOracleHome + fileSeparator + LIB_DIR + File.pathSeparator + selectedOracleHome);
            if (this.debug) {
                this.listener.getLogger().println("[DEBUG] LD_LIBRARY_PATH = " + selectedOracleHome + fileSeparator + LIB_DIR + File.pathSeparator + selectedOracleHome);
            }
            if (hasCustomTNSAdmin) {
                envVars.put(ENV_TNS_ADMIN, this.customTNSAdmin);
                boolean findTNSNAMES = FileUtil.findFile(TNSNAMES_ORA, new File(this.customTNSAdmin));
                if (!findTNSNAMES) throw new RuntimeException(Messages.SQLPlusRunner_missingTNSNAMES());
                if (this.debug) {
                    this.listener.getLogger().println("[DEBUG] found TNSNAMES.ORA on " + new File(this.customTNSAdmin).getAbsolutePath());
                }
            } else if (slaveMachine) {
                envVars.put(ENV_TNS_ADMIN, selectedOracleHome);
            } else {
                boolean findTNSNAMESOracleHome = FileUtil.findFile(TNSNAMES_ORA, new File(selectedOracleHome));
                boolean findTNSNAMESOracleHomeNetworkAdmin = FileUtil.findFile(TNSNAMES_ORA, new File(selectedOracleHome + fileSeparator + NET_DIR + fileSeparator + NET_ADM_DIR));
                if (findTNSNAMESOracleHomeNetworkAdmin) {
                    envVars.put(ENV_TNS_ADMIN, selectedOracleHome + fileSeparator + NET_DIR + fileSeparator + NET_ADM_DIR);
                    if (this.debug) {
                        this.listener.getLogger().println("[DEBUG] found TNSNAMES.ORA on " + new File(selectedOracleHome + fileSeparator + NET_DIR + fileSeparator + NET_ADM_DIR).getAbsolutePath());
                        this.listener.getLogger().println("[DEBUG] TNS_ADMIN = " + selectedOracleHome + fileSeparator + NET_DIR + fileSeparator + NET_ADM_DIR);
                    }
                } else {
                    if (!findTNSNAMESOracleHome) throw new RuntimeException(Messages.SQLPlusRunner_missingTNSNAMES());
                    envVars.put(ENV_TNS_ADMIN, selectedOracleHome);
                    if (this.debug) {
                        this.listener.getLogger().println("[DEBUG] found TNSNAMES.ORA on " + new File(selectedOracleHome).getAbsolutePath());
                        this.listener.getLogger().println("[DEBUG] TNS_ADMIN = " + selectedOracleHome);
                    }
                }
            }
            ArgumentListBuilder args = new ArgumentListBuilder();
            String arg1 = this.user + SLASH + DOUBLE_QUOTES + this.password + DOUBLE_QUOTES;
            if (this.instance != null) {
                arg1 = arg1 + AT + this.instance;
            }
            String arg2 = scriptFilePath.getRemote();
            if (this.debug) {
                this.listener.getLogger().println("Master Work Directory = " + this.workspace);
            }
            if (hasCustomSQLPlusHome) {
                args.add(this.customSQLPlusHome);
            } else {
                this.listener.getLogger().println("SQL*Plus exec file = " + sqlplus);
                boolean findSQLPlusOnOracleHomeBin = FileUtil.findFile(sqlplus, new File(selectedOracleHome + fileSeparator + BIN_DIR));
                boolean findSQLPlusOnOracleHome = FileUtil.findFile(sqlplus, new File(selectedOracleHome));
                if (findSQLPlusOnOracleHomeBin) {
                    if (this.debug) {
                        this.listener.getLogger().println("[DEBUG] found SQL*Plus on " + new File(selectedOracleHome + fileSeparator + BIN_DIR).getAbsolutePath());
                    }
                    args.add(selectedOracleHome + fileSeparator + BIN_DIR + fileSeparator + sqlplus);
                } else if (findSQLPlusOnOracleHome) {
                    if (this.debug) {
                        this.listener.getLogger().println("[DEBUG] found SQL*Plus on " + new File(selectedOracleHome).getAbsolutePath());
                    }
                    args.add(selectedOracleHome + fileSeparator + sqlplus);
                } else {
                    if (!slaveMachine) throw new RuntimeException(Messages.SQLPlusRunner_missingSQLPlus());
                    this.listener.getLogger().println("SQL*Plus directory: " + selectedOracleHome + fileSeparator + BIN_DIR);
                    args.add(selectedOracleHome + fileSeparator + BIN_DIR + fileSeparator + sqlplus);
                }
            }
            args.add(SQLPLUS_TRY_LOGIN_JUST_ONCE);
            args.add(arg1);
            args.add(AT + arg2);
            if (this.debug) {
                this.listener.getLogger().println("[DEBUG]  Statement: ");
                this.listener.getLogger().println(LINE);
                for (String a : args.toList()) {
                    this.listener.getLogger().print(a + " ");
                }
                this.listener.getLogger().println(" ");
                this.listener.getLogger().println(LINE);
                this.listener.getLogger().println(" ");
            }
            if (slaveMachine) {
                FilePath pwdDir = this.workspace;
                exitCode = this.launcher.launch().cmds(args).envs((Map)this.build.getEnvironment(this.listener).overrideAll((Map)envVars)).stdout(this.listener).pwd(pwdDir).join();
            } else {
                exitCode = this.launcher.launch().cmds(args).envs((Map)this.build.getEnvironment(this.listener).overrideAll((Map)envVars)).stdout(this.listener).pwd(this.workspace).join();
            }
            this.listener.getLogger().printf(Messages.SQLPlusRunner_processEnd() + " %d%n", exitCode);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.listener.getLogger().println(MSG_ERROR + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            if (tempScript != null) {
                try {
                    boolean removed = tempScript.delete();
                    if (!removed) {
                        this.listener.getLogger().printf(Messages.SQLPlusRunner_tempFileNotRemoved(), new Object[0]);
                    }
                }
                catch (Exception e) {
                    this.listener.getLogger().println(MSG_ERROR + e.getMessage());
                }
            }
        }
        if (exitCode != 0) {
            this.listener.getLogger().println(LINE);
            this.listener.getLogger().println("Exit code: " + exitCode);
            this.listener.getLogger().println(LINE);
            throw new RuntimeException(Messages.SQLPlusRunner_processErrorEnd());
        }
        this.listener.getLogger().println(LINE);
    }

    public void runGetSQLPLusVersion(String customSQLPlusHome, String oracleHome, TaskListener listener, Launcher launcher) {
        File directoryAccessTest;
        if (oracleHome == null || oracleHome.length() < 1) {
            throw new RuntimeException(MSG_ORACLE_HOME_MISSING);
        }
        boolean slaveMachine = this.isSlaveMachine(launcher);
        if (this.debug) {
            listener.getLogger().println(" detected host = " + NetUtil.getHostName());
            listener.getLogger().println(" slave machine ? " + slaveMachine);
        }
        boolean hasCustomSQLPlusHome = false;
        if (customSQLPlusHome != null && customSQLPlusHome.length() > 0) {
            hasCustomSQLPlusHome = true;
        }
        if (!(slaveMachine || hasCustomSQLPlusHome || (directoryAccessTest = new File(oracleHome)).exists())) {
            throw new RuntimeException(Messages.SQLPlusRunner_wrongOracleHome(oracleHome));
        }
        listener.getLogger().println(LINE);
        listener.getLogger().println(MSG_ORACLE_HOME + oracleHome);
        listener.getLogger().println(LINE);
        listener.getLogger().println(MSG_GET_SQL_PLUS_VERSION);
        try {
            String sqlplus = SQLPLUS;
            String fileSeparator = File.separator;
            if (this.isWindowsOS(slaveMachine)) {
                sqlplus = SQLPLUS_FOR_WINDOWS;
                fileSeparator = WINDOWS_FILE_SEPARATOR;
            }
            EnvVars envVars = new EnvVars();
            envVars.put(ENV_ORACLE_HOME, oracleHome);
            if (this.debug) {
                listener.getLogger().println("[DEBUG] ORACLE_HOME = " + oracleHome);
            }
            envVars.put(ENV_LD_LIBRARY_PATH, oracleHome + fileSeparator + LIB_DIR);
            if (this.debug) {
                listener.getLogger().println("[DEBUG] LD_LIBRARY_PATH = " + oracleHome + fileSeparator + LIB_DIR);
            }
            ArgumentListBuilder args = new ArgumentListBuilder();
            if (this.debug) {
                listener.getLogger().println("SQL*Plus exec file = " + sqlplus);
            }
            if (hasCustomSQLPlusHome) {
                args.add(customSQLPlusHome);
            } else {
                boolean findSQLPlusOnOracleHomeBin = FileUtil.findFile(sqlplus, new File(oracleHome + fileSeparator + BIN_DIR));
                boolean findSQLPlusOnOracleHome = FileUtil.findFile(sqlplus, new File(oracleHome));
                if (findSQLPlusOnOracleHomeBin) {
                    listener.getLogger().println(FOUND_SQL_PLUS_ON + new File(oracleHome + fileSeparator + BIN_DIR).getAbsolutePath());
                    args.add(oracleHome + fileSeparator + BIN_DIR + fileSeparator + sqlplus);
                } else if (findSQLPlusOnOracleHome) {
                    listener.getLogger().println(FOUND_SQL_PLUS_ON + new File(oracleHome).getAbsolutePath());
                    args.add(oracleHome + fileSeparator + sqlplus);
                } else if (slaveMachine) {
                    listener.getLogger().println("SQL*Plus directory: " + oracleHome + fileSeparator + BIN_DIR);
                    args.add(oracleHome + fileSeparator + BIN_DIR + fileSeparator + sqlplus);
                } else {
                    throw new RuntimeException(Messages.SQLPlusRunner_missingSQLPlus());
                }
            }
            args.add(SQLPLUS_VERSION);
            if (this.debug) {
                listener.getLogger().println(LINE);
                listener.getLogger().println("[DEBUG] Statement:");
                for (String a : args.toList()) {
                    listener.getLogger().print(a + " ");
                }
                listener.getLogger().println(" ");
                listener.getLogger().println(LINE);
            }
            int exitCode = 0;
            if (slaveMachine) {
                FilePath pwdDir = this.workspace;
                exitCode = launcher.launch().cmds(args).envs((Map)this.build.getEnvironment(listener).overrideAll((Map)envVars)).stdout(listener).pwd(pwdDir).join();
            } else {
                exitCode = launcher.launch().cmds(args).envs((Map)this.build.getEnvironment(listener).overrideAll((Map)envVars)).stdout(listener).pwd(this.workspace).join();
            }
            listener.getLogger().printf(Messages.SQLPlusRunner_processEnd() + " %d%n", exitCode);
        }
        catch (RuntimeException e) {
            listener.getLogger().println(MSG_ERROR + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            listener.getLogger().println(MSG_ERROR + e.getMessage());
            throw new RuntimeException(e);
        }
        listener.getLogger().println(LINE);
    }

    private boolean isSlaveMachine(Launcher launcher) {
        VirtualChannel vc = launcher.getChannel();
        boolean slaveMachine = true;
        if (vc instanceof LocalChannel) {
            slaveMachine = false;
        }
        return slaveMachine;
    }

    private boolean isWindowsOS(boolean slaveMachine) throws IOException, InterruptedException {
        boolean isWindows = false;
        if (slaveMachine) {
            String osSlave = (String)this.build.getEnvironment(this.listener).get((Object)OPERATION_SYSTEM_SLAVE);
            if (osSlave != null) {
                isWindows = osSlave.toLowerCase().indexOf(WINDOWS_OS) >= 0;
            }
        } else {
            String osMaster = System.getProperty(OPERATION_SYSTEM);
            if (osMaster != null) {
                isWindows = osMaster.toLowerCase().indexOf(WINDOWS_OS) >= 0;
            }
        }
        return isWindows;
    }
}

