/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.hudson.sounds;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import net.hurstfrost.hudson.sounds.HudsonSoundsNotifier;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoundsBuildTask
extends Builder {
    private final Integer afterDelayMs;
    private final SoundSource soundSource;

    @DataBoundConstructor
    public SoundsBuildTask(String afterDelayMs, SoundSource soundSource) {
        this.afterDelayMs = SoundsBuildTask.nonNegativeOrNull(afterDelayMs);
        this.soundSource = soundSource;
    }

    protected static Integer nonNegativeOrNull(String longString) {
        Integer d = null;
        try {
            d = Integer.parseInt(longString);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return d;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars vars = build.getEnvironment((TaskListener)listener);
        switch (this.soundSource.sourceType) {
            case INTERNAL: {
                listener.getLogger().format("Playing internal sound '%s'\n", this.soundSource.soundId);
                try {
                    HudsonSoundsNotifier.getSoundsDescriptor().playSound(this.soundSource.soundId, this.afterDelayMs, vars);
                    break;
                }
                catch (Exception e) {
                    listener.error(e.toString());
                    return false;
                }
            }
            case URL: {
                listener.getLogger().format("Playing sound at '%s'\n", this.soundSource.url);
                try {
                    HudsonSoundsNotifier.getSoundsDescriptor().playSoundFromUrl(this.soundSource.url, this.afterDelayMs, vars);
                    break;
                }
                catch (Exception e) {
                    listener.error(e.toString());
                    return false;
                }
            }
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public SoundSource.SourceType getSourceType() {
        return this.soundSource.sourceType;
    }

    public String getSoundId() {
        return this.soundSource.soundId;
    }

    public URL getSoundUrl() {
        return this.soundSource.url;
    }

    public Integer getAfterDelayMs() {
        return this.afterDelayMs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        protected DescriptorImpl(Class<? extends SoundsBuildTask> clazz) {
            super(clazz);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckSoundUrl(@QueryParameter String soundUrl) {
            block6: {
                if (StringUtils.isEmpty((String)soundUrl)) {
                    return FormValidation.warning((String)"Missing URL");
                }
                try {
                    URL url = new URL(HudsonSoundsNotifier.toUri(soundUrl));
                    if (!url.getProtocol().toLowerCase().equals("file")) break block6;
                    URI uri = new URI(HudsonSoundsNotifier.toUri(soundUrl));
                    File file = new File(uri);
                    if (!file.exists() || !file.isFile()) {
                        return FormValidation.error((String)"File not found or not readable");
                    }
                    try {
                        FileInputStream inputStream = new FileInputStream(file);
                        inputStream.close();
                    }
                    catch (IOException e) {
                        return FormValidation.error((String)"File not found or not readable");
                    }
                }
                catch (Exception e) {
                    return FormValidation.error((String)"Invalid URL");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAfterDelayMs(@QueryParameter String afterDelayMs) {
            Integer delayMsLong = null;
            try {
                delayMsLong = Integer.parseInt(afterDelayMs);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (delayMsLong != null) {
                if (delayMsLong < 0) {
                    return FormValidation.error((String)"Invalid delay, must be non-negative.");
                }
                if (delayMsLong <= 2200) {
                    return FormValidation.warning((String)"Setting a short delay can disrupt sound auto-synchronisation, leave blank to play soon");
                }
            }
            return FormValidation.ok();
        }

        public List<HudsonSoundsNotifier.HudsonSoundsDescriptor.SoundBite> getSounds() {
            HudsonSoundsNotifier.HudsonSoundsDescriptor hudsonSoundsDescriptor = HudsonSoundsNotifier.getSoundsDescriptor();
            return hudsonSoundsDescriptor.getSounds();
        }

        public FormValidation doTestSound(@QueryParameter String selectedSound) {
            try {
                HudsonSoundsNotifier.getSoundsDescriptor().playSound(selectedSound, null);
                return FormValidation.ok((String)String.format("Sound played successfully", new Object[0]));
            }
            catch (Exception e) {
                return FormValidation.error((String)String.format("Sound failed : " + e, new Object[0]));
            }
        }

        public FormValidation doTestUrl(@QueryParameter String soundUrl) {
            try {
                URL url = new URL(HudsonSoundsNotifier.toUri(soundUrl));
                HudsonSoundsNotifier.getSoundsDescriptor().playSoundFromUrl(url, null, null);
                return FormValidation.ok((String)String.format("Sound played successfully", new Object[0]));
            }
            catch (Exception e) {
                return FormValidation.error((String)String.format("Sound failed : " + e, new Object[0]));
            }
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            this.save();
            return true;
        }

        public String getHelpFile() {
            return "/plugin/sounds/help-soundsTask.html";
        }

        public String getDisplayName() {
            return "Play a sound";
        }

        public SoundsBuildTask newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            SoundsBuildTask soundsBuildTask = (SoundsBuildTask)((Object)req.bindJSON(this.clazz, formData));
            return soundsBuildTask;
        }
    }

    public static class SoundSource {
        protected final SourceType sourceType;
        protected final URL url;
        protected final String soundId;

        @DataBoundConstructor
        public SoundSource(String selectedSound, SourceType value, String soundUrl) {
            this.soundId = selectedSound;
            this.sourceType = value;
            URL url = null;
            try {
                url = new URL(HudsonSoundsNotifier.toUri(soundUrl));
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            this.url = url;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SourceType {
            INTERNAL,
            URL;

        }
    }
}

