/*
 * Decompiled with CFR 0.152.
 */
package net.hurstfrost.hudson.sounds;

import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.VersionNumber;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.hurstfrost.hudson.sounds.SoundsAgentAction;
import net.hurstfrost.hudson.sounds.UnplayableSoundBiteException;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jfree.util.Log;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonSoundsNotifier
extends Notifier {
    private List<SoundEvent> soundEvents;

    @DataBoundConstructor
    public HudsonSoundsNotifier() {
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public HudsonSoundsDescriptor getDescriptor() {
        return (HudsonSoundsDescriptor)super.getDescriptor();
    }

    public static HudsonSoundsDescriptor getSoundsDescriptor() {
        HudsonSoundsDescriptor hudsonSoundsDescriptor = (HudsonSoundsDescriptor)Hudson.getInstance().getDescriptorByType(HudsonSoundsDescriptor.class);
        return hudsonSoundsDescriptor;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        SoundEvent event = this.getSoundEventFor(build.getResult(), build.getPreviousBuild() != null ? ((AbstractBuild)build.getPreviousBuild()).getResult() : null);
        EnvVars vars = build.getEnvironment((TaskListener)listener);
        if (event != null) {
            try {
                this.getDescriptor().playSound(event.getSoundId(), vars);
            }
            catch (UnplayableSoundBiteException e) {
                listener.getLogger().println("Failed to play sound '" + event.getSoundId() + "' : " + e.toString());
            }
        }
        return true;
    }

    public List<SoundEvent> getSoundEvents() {
        return this.soundEvents;
    }

    public void setSoundEvents(List<SoundEvent> newSounds) {
        ArrayList<SoundEvent> validatedList = new ArrayList<SoundEvent>();
        for (SoundEvent sound : newSounds) {
            if (sound.toResult == null || sound.getSoundId() == null || sound.getFromResults().isEmpty()) continue;
            validatedList.add(sound);
        }
        this.soundEvents = validatedList;
    }

    public SoundEvent getSoundEventFor(Result result, Result previousResult) {
        if (CollectionUtils.isEmpty(this.soundEvents)) {
            return null;
        }
        SoundEvent foundEvent = null;
        for (SoundEvent event : this.soundEvents) {
            if (!event.toResult.equals(result) || CollectionUtils.isEmpty((Collection)event.fromResults) || !event.fromResults.contains(previousResult != null ? previousResult : Result.NOT_BUILT)) continue;
            foundEvent = event;
            if (this.getDescriptor().getSound(foundEvent.getSoundId()) == null) continue;
            break;
        }
        return foundEvent;
    }

    protected static String toUri(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return "";
        }
        if (path.startsWith("http://") || path.startsWith("file:/")) {
            return path;
        }
        return new File(path).toURI().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class HudsonSoundsDescriptor
    extends BuildStepDescriptor<Publisher> {
        private static final String INTERNAL_ARCHIVE = HudsonSoundsNotifier.class.getResource("/sound-archive.zip").toString();
        private static final int MAX_PIPE_TIMEOUT_SECS = 60;
        private static final int MIN_PIPE_TIMEOUT_SECS = 5;
        private static final int PIPE_TIMEOUT_EXTENDS_SECS = 5;
        public static final VersionNumber STAPLER_JSON_BREAKING_CHANGE_VERSION_NUMBER = new VersionNumber("1.445");
        private String soundArchive = INTERNAL_ARCHIVE;
        private PLAY_METHOD playMethod = PLAY_METHOD.BROWSER;
        private String systemCommand;
        private int pipeTimeoutSecs = 5;
        private transient TreeMap<String, SoundBite> sounds;
        private transient boolean needsReindex;

        public HudsonSoundsDescriptor() {
            this.load();
            this.needsReindex = true;
        }

        public List<SoundBite> getSounds() {
            this.checkIndex();
            return new ArrayList<SoundBite>(this.sounds.values());
        }

        private void checkIndex() {
            if (this.needsReindex) {
                this.needsReindex = false;
                this.sounds = HudsonSoundsDescriptor.rebuildSoundsIndex(this.soundArchive);
            }
        }

        public SoundBite getSound(String id) {
            this.checkIndex();
            if (this.sounds != null && id != null) {
                return this.sounds.get(id);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static TreeMap<String, SoundBite> rebuildSoundsIndex(String urlString) {
            TreeMap<String, SoundBite> index = new TreeMap<String, SoundBite>();
            try {
                URL url = new URL(urlString);
                URLConnection connection = url.openConnection();
                ZipInputStream zipInputStream = new ZipInputStream(connection.getInputStream());
                try {
                    ZipEntry entry;
                    while ((entry = zipInputStream.getNextEntry()) != null) {
                        if (entry.isDirectory()) continue;
                        String id = HudsonSoundsDescriptor.getBiteName(entry.getName());
                        AudioFileFormat f = null;
                        try {
                            f = AudioSystem.getAudioFileFormat(new BufferedInputStream(zipInputStream));
                        }
                        catch (UnsupportedAudioFileException e) {
                            // empty catch block
                        }
                        index.put(id, new SoundBite(id, entry.getName(), urlString, f));
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)zipInputStream);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return index;
        }

        protected static String getBiteName(String path) {
            int dot;
            int slash = path.lastIndexOf(47);
            if (slash != -1) {
                path = path.substring(slash + 1);
            }
            if ((dot = path.lastIndexOf(46)) != -1) {
                path = path.substring(0, dot);
            }
            return path;
        }

        public String getSoundArchive() {
            return this.soundArchive;
        }

        public void setSoundArchive(String archive) {
            this.soundArchive = !StringUtils.isEmpty((String)archive) ? HudsonSoundsNotifier.toUri(archive) : INTERNAL_ARCHIVE;
            this.needsReindex = true;
            this.sounds = null;
        }

        public PLAY_METHOD getPlayMethod() {
            return this.playMethod;
        }

        public void setPlayMethod(PLAY_METHOD playMethod) {
            this.playMethod = playMethod;
        }

        public String getSystemCommand() {
            return this.systemCommand;
        }

        public void setSystemCommand(String systemCommand) {
            this.systemCommand = systemCommand;
        }

        public int getPipeTimeoutSecs() {
            return this.pipeTimeoutSecs;
        }

        public void setPipeTimeoutSecs(int pipeTimeout) {
            this.pipeTimeoutSecs = Math.max(5, Math.min(60, pipeTimeout));
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            this.setSoundArchive(json.optString("soundArchive"));
            JSONObject playMethod = json.optJSONObject("playMethod");
            if (playMethod != null) {
                try {
                    PLAY_METHOD method = PLAY_METHOD.valueOf(playMethod.getString("value"));
                    this.setPlayMethod(method);
                    if (method == PLAY_METHOD.PIPE) {
                        JSONObject pipeConfig = playMethod;
                        if (Hudson.getVersion().isOlderThan(STAPLER_JSON_BREAKING_CHANGE_VERSION_NUMBER)) {
                            pipeConfig = json;
                        }
                        this.setSystemCommand(pipeConfig.optString("systemCommand"));
                        this.setPipeTimeoutSecs(pipeConfig.optInt("pipeTimeoutSecs"));
                    }
                }
                catch (Exception e) {
                    Log.debug((Object)"Exception setting play method", (Exception)e);
                }
            }
            this.save();
            return true;
        }

        public String getDisplayName() {
            return "Jenkins Sounds";
        }

        public HudsonSoundsNotifier newInstance(StaplerRequest req, JSONObject formData) {
            HudsonSoundsNotifier m = new HudsonSoundsNotifier();
            m.setSoundEvents(req.bindJSONToList(SoundEvent.class, formData.get("soundEvents")));
            return m;
        }

        public FormValidation doTestSound(@QueryParameter String selectedSound, @QueryParameter String soundArchive, @QueryParameter String playMethod, @QueryParameter String systemCommand, @QueryParameter int pipeTimeoutSecs) {
            if (StringUtils.isEmpty((String)selectedSound)) {
                return FormValidation.error((String)"Please choose a sound to test.");
            }
            this.setSoundArchive(soundArchive);
            this.setPipeTimeoutSecs(pipeTimeoutSecs);
            this.setSystemCommand(systemCommand);
            try {
                this.playSound(selectedSound);
            }
            catch (UnplayableSoundBiteException e) {
                String message = e.getMessage();
                if (StringUtils.isEmpty((String)message)) {
                    message = e.toString();
                }
                return FormValidation.error((String)("Failed to make sound '" + selectedSound + "' : " + message));
            }
            return FormValidation.ok((String)("Jenkins made sound '" + selectedSound + "' successfully."));
        }

        public FormValidation doCheckPipeTimeout(@QueryParameter int value) {
            if (value > 60 || value < 5) {
                return FormValidation.warning((String)String.format("Pipe timeout is invalid, valid range %d - %ds.", 5, 60));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSystemCommand(@QueryParameter String systemCommand) {
            if (StringUtils.isEmpty((String)systemCommand)) {
                return FormValidation.warning((String)String.format("Enter a system command to pipe the sound file to", new Object[0]));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSoundArchive(@QueryParameter String value) {
            URI uri;
            try {
                uri = new URI(HudsonSoundsNotifier.toUri(value));
            }
            catch (URISyntaxException e) {
                return FormValidation.warning((String)("The URL '" + value + "' is invalid (" + e.toString() + ")"));
            }
            if ("file".equals(uri.getScheme())) {
                if (new File(uri).exists()) {
                    return FormValidation.ok();
                }
                return FormValidation.warning((String)("File not found '" + uri + "'"));
            }
            if ("http".equals(uri.getScheme())) {
                try {
                    URLConnection openConnection = uri.toURL().openConnection();
                    if (openConnection instanceof HttpURLConnection) {
                        HttpURLConnection httpUrlConnection = (HttpURLConnection)openConnection;
                        int responseCode = httpUrlConnection.getResponseCode();
                        if (responseCode == 200) {
                            return FormValidation.ok();
                        }
                        return FormValidation.warning((String)("The URL '" + value + "' is invalid (" + httpUrlConnection.getResponseMessage() + ")"));
                    }
                    return FormValidation.warning((String)("The URL '" + value + "' is invalid"));
                }
                catch (IOException e) {
                    return FormValidation.warning((String)("The URL '" + value + "' is invalid (" + e.toString() + ")"));
                }
            }
            return FormValidation.warning((String)("The URI '" + value + "' is invalid"));
        }

        protected void playSoundFromUrl(URL url, Integer afterDelayMs, EnvVars vars) throws UnplayableSoundBiteException {
            switch (this.playMethod) {
                case BROWSER: {
                    ExtensionList<SoundsAgentAction> soundsAgents = SoundsAgentAction.all();
                    if (soundsAgents.isEmpty()) {
                        throw new RuntimeException("No SoundsAgentAction Extension found.");
                    }
                    SoundsAgentAction soundsAgentAction = (SoundsAgentAction)soundsAgents.get(0);
                    soundsAgentAction.playSound(url, afterDelayMs);
                    break;
                }
                default: {
                    try {
                        this.playSoundFromInputStream(url.openStream(), vars);
                        break;
                    }
                    catch (Exception e) {
                        throw new UnplayableSoundBiteException(url.toString(), e);
                    }
                }
            }
        }

        protected void playSound(String id) throws UnplayableSoundBiteException {
            this.playSound(id, null, null);
        }

        protected void playSound(String id, EnvVars vars) throws UnplayableSoundBiteException {
            this.playSound(id, null, vars);
        }

        protected void playSound(String id, Integer afterDelayMs, EnvVars vars) throws UnplayableSoundBiteException {
            SoundBite soundBite = this.getSound(id);
            if (soundBite != null) {
                switch (this.playMethod) {
                    case BROWSER: {
                        ExtensionList<SoundsAgentAction> soundsAgents = SoundsAgentAction.all();
                        if (!soundsAgents.isEmpty()) {
                            SoundsAgentAction soundsAgentAction = (SoundsAgentAction)soundsAgents.get(0);
                            soundsAgentAction.playSound(soundBite, afterDelayMs);
                            return;
                        }
                        throw new RuntimeException("No SoundsAgentAction Extension found.");
                    }
                }
                InputStream soundBiteInputStream = null;
                try {
                    soundBiteInputStream = this.getSoundBiteInputStream(soundBite);
                    if (soundBiteInputStream != null) {
                        this.playSoundFromInputStream(soundBiteInputStream, vars);
                        return;
                    }
                }
                catch (Exception e) {
                    throw new UnplayableSoundBiteException(soundBite, e);
                }
            }
            throw new UnplayableSoundBiteException("No such sound.");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void playSoundFromInputStream(InputStream soundBiteInputStream, EnvVars vars) throws LineUnavailableException, IOException, UnsupportedAudioFileException, Exception {
            try {
                switch (this.playMethod) {
                    case LOCAL: {
                        this.playSoundBite(AudioSystem.getAudioInputStream(soundBiteInputStream));
                        return;
                    }
                    case PIPE: {
                        this.playSoundBite(soundBiteInputStream, vars != null ? vars.expand(this.systemCommand) : this.systemCommand);
                        return;
                    }
                }
                return;
            }
            finally {
                IOUtils.closeQuietly((InputStream)soundBiteInputStream);
            }
        }

        protected InputStream getSoundBiteInputStream(SoundBite soundBite) throws IOException {
            ZipEntry entry;
            URL url = new URL(soundBite.url);
            URLConnection connection = url.openConnection();
            ZipInputStream zipInputStream = new ZipInputStream(connection.getInputStream());
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (!entry.getName().equals(soundBite.entryName)) continue;
                return new BufferedInputStream(zipInputStream);
            }
            throw new IOException("Unable to get input stream for " + soundBite);
        }

        private void playSoundBite(InputStream soundIn, String systemCommand) throws Exception {
            Process p = Runtime.getRuntime().exec(systemCommand);
            OutputStream soundOut = p.getOutputStream();
            ProcessKiller processKiller = new ProcessKiller(p, this.pipeTimeoutSecs);
            IOException playException = null;
            try {
                int read;
                byte[] buffer = new byte[131072];
                while ((read = soundIn.read(buffer)) > 0) {
                    soundOut.write(buffer, 0, read);
                    processKiller.progressing(5);
                }
                IOUtils.copy((InputStream)soundIn, (OutputStream)soundOut);
                IOUtils.closeQuietly((OutputStream)soundOut);
            }
            catch (IOException e) {
                playException = e;
            }
            processKiller.progressing(5);
            p.waitFor();
            if (processKiller.didDestroy()) {
                throw new RuntimeException("Sound pipe was unresponsive and was killed after " + this.pipeTimeoutSecs + "s");
            }
            if (p.exitValue() != 0) {
                throw new RuntimeException("Sound pipe process returned non-zero exit status (" + p.exitValue() + ")");
            }
            if (playException != null) {
                throw playException;
            }
        }

        protected void playSoundBite(AudioInputStream in) throws LineUnavailableException, IOException {
            int read;
            AudioFormat baseFormat;
            AudioFormat decodedFormat = baseFormat = in.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, decodedFormat);
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(decodedFormat);
            line.start();
            byte[] buffer = new byte[8096];
            while ((read = in.read(buffer)) > 0) {
                line.write(buffer, 0, read);
            }
            line.drain();
            line.stop();
            line.close();
        }

        private class ProcessKiller
        extends Thread {
            private final Process p;
            private long killAfter;
            private boolean didDestroy;

            public ProcessKiller(Process p, int timeoutSecs) {
                this.p = p;
                this.killAfter = System.currentTimeMillis() + (long)(timeoutSecs * 1000);
                this.start();
            }

            public void run() {
                try {
                    do {
                        long sleep;
                        if ((sleep = this.killAfter - System.currentTimeMillis()) <= 0L) continue;
                        Thread.sleep(sleep);
                    } while (System.currentTimeMillis() < this.killAfter);
                    try {
                        this.p.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        this.didDestroy = true;
                        this.p.destroy();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            public void progressing(int extendBySecs) {
                this.killAfter = Math.max(this.killAfter, System.currentTimeMillis() + (long)(extendBySecs * 1000));
            }

            public boolean didDestroy() {
                return this.didDestroy;
            }
        }

        public static class SoundBite {
            public final String id;
            public final String entryName;
            public final String url;
            public final AudioFileFormat format;

            public SoundBite(String _id, String _entryName, String _url, AudioFileFormat _format) {
                this.id = _id;
                this.entryName = _entryName;
                this.url = _url;
                this.format = _format;
            }

            public String getId() {
                return this.id;
            }

            public String getEntryName() {
                return this.entryName;
            }

            public String getUrl() {
                return this.url;
            }

            public AudioFileFormat getFormat() {
                return this.format;
            }

            public String getDescription() {
                if (this.format == null) {
                    return this.id + " (unsupported format)";
                }
                return this.id + " (" + this.format.getType() + ")";
            }

            public String toString() {
                return this.getDescription();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SoundEvent {
        private final String soundId;
        private final Result toResult;
        private final Set<Result> fromResults;

        @DataBoundConstructor
        public SoundEvent(String soundId, String toResult, boolean fromNotBuilt, boolean fromAborted, boolean fromFailure, boolean fromUnstable, boolean fromSuccess) {
            Result result;
            this.soundId = soundId;
            Result result2 = result = toResult != null ? Result.fromString((String)toResult) : null;
            if (result != null && !result.toString().equals(toResult)) {
                result = null;
            }
            this.toResult = result;
            this.fromResults = new HashSet<Result>();
            this.setFromNotBuilt(fromNotBuilt);
            this.setFromAborted(fromAborted);
            this.setFromFailure(fromFailure);
            this.setFromUnstable(fromUnstable);
            this.setFromSuccess(fromSuccess);
        }

        public String getSoundId() {
            return this.soundId;
        }

        public Result getToBuildResult() {
            return this.toResult;
        }

        public boolean isFromNotBuilt() {
            return this.fromResults.isEmpty() || this.fromResults.contains(Result.NOT_BUILT);
        }

        public void setFromNotBuilt(boolean b) {
            if (b) {
                this.fromResults.add(Result.NOT_BUILT);
            } else {
                this.fromResults.remove(Result.NOT_BUILT);
            }
        }

        public boolean isFromAborted() {
            return this.fromResults.isEmpty() || this.fromResults.contains(Result.ABORTED);
        }

        public void setFromAborted(boolean b) {
            if (b) {
                this.fromResults.add(Result.ABORTED);
            } else {
                this.fromResults.remove(Result.ABORTED);
            }
        }

        public boolean isFromFailure() {
            return this.fromResults.isEmpty() || this.fromResults.contains(Result.FAILURE);
        }

        public void setFromFailure(boolean b) {
            if (b) {
                this.fromResults.add(Result.FAILURE);
            } else {
                this.fromResults.remove(Result.FAILURE);
            }
        }

        public boolean isFromUnstable() {
            return this.fromResults.isEmpty() || this.fromResults.contains(Result.UNSTABLE);
        }

        public void setFromUnstable(boolean b) {
            if (b) {
                this.fromResults.add(Result.UNSTABLE);
            } else {
                this.fromResults.remove(Result.UNSTABLE);
            }
        }

        public boolean isFromSuccess() {
            return this.fromResults.isEmpty() || this.fromResults.contains(Result.SUCCESS);
        }

        public void setFromSuccess(boolean b) {
            if (b) {
                this.fromResults.add(Result.SUCCESS);
            } else {
                this.fromResults.remove(Result.SUCCESS);
            }
        }

        public Set<Result> getFromResults() {
            return this.fromResults;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PLAY_METHOD {
        LOCAL,
        PIPE,
        BROWSER;

    }
}

