/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.persistence;

import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MetricId
implements Serializable {
    private static final long serialVersionUID = 4950947267793381336L;
    private final String id;
    private final String providerId;
    private final String name;
    private final boolean isFloat;
    private final Set<String> m_categories = new HashSet<String>();

    public MetricId(String id, String providerId, String name, boolean isFloat, String ... categories) {
        this.id = id;
        this.providerId = providerId;
        this.name = name;
        this.isFloat = isFloat;
        if (categories != null && categories.length > 0) {
            for (String category : categories) {
                this.m_categories.add(category);
            }
        }
    }

    public MetricId(String id, String providerId, String name, boolean isFloat, List<String> categories) {
        this.id = id;
        this.providerId = providerId;
        this.name = name;
        this.isFloat = isFloat;
        if (categories != null) {
            this.m_categories.addAll(categories);
        }
    }

    public Set<String> getCategories() {
        return this.m_categories;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public boolean isFloat() {
        return this.isFloat;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_categories == null ? 0 : this.m_categories.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.isFloat ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricId)) {
            return false;
        }
        MetricId other = (MetricId)obj;
        if (this.m_categories == null ? other.m_categories != null : !this.m_categories.equals(other.m_categories)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.isFloat != other.isFloat) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static MetricId from(IMetricId metricId) {
        List<String> categories = metricId.getCategories().stream().map(x -> x.getPresentationName()).collect(Collectors.toList());
        MetricId result = new MetricId(metricId.getName(), metricId.getProvider().getName(), metricId.getPresentationName(), metricId.isFloat(), categories);
        return result;
    }
}

