/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.access.controller.ControllerFactory;
import com.hello2morrow.sonargraph.integration.access.controller.IMetaDataController;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.foundation.ResultWithOutcome;
import com.hello2morrow.sonargraph.integration.access.model.IExportMetaData;
import com.hello2morrow.sonargraph.integration.jenkins.controller.AbstractBuildStepDescriptor;
import com.hello2morrow.sonargraph.integration.jenkins.controller.AbstractSonargraphRecorder;
import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import com.hello2morrow.sonargraph.integration.jenkins.controller.IReportPathProvider;
import com.hello2morrow.sonargraph.integration.jenkins.controller.Metric;
import com.hello2morrow.sonargraph.integration.jenkins.controller.SonargraphChartAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.SonargraphHTMLReportAction;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphUtil;
import com.hello2morrow.sonargraph.integration.jenkins.model.IMetricIdsHistoryProvider;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.ConfigurationFileWriter;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricId;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricIds;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricIdsHistory;
import com.hello2morrow.sonargraph.integration.jenkins.tool.SonargraphBuild;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.RelativePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.JDK;
import hudson.model.Project;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public final class SonargraphReportBuilder
extends AbstractSonargraphRecorder
implements IReportPathProvider {
    private static final String ORG_ECLIPSE_OSGI_JAR = "org.eclipse.osgi_*.jar";
    private static final String SONARGRAPH_BUILD_CLIENT_JAR = "com.hello2morrow.sonargraph.build.client_*.jar";
    private static final String DEFAULT_META_DATA_XML = "MetaData.xml";
    private static final String SONARGRAPH_BUILD_MAIN_CLASS = "com.hello2morrow.sonargraph.build.client.SonargraphBuildRunner";
    public static final int MAX_PORT_NUMBER = 65535;
    private static IMetricIdsHistoryProvider s_metricIdsHistory;
    private final String systemDirectory;
    private final String qualityModelFile;
    private final String virtualModel;
    private final String reportPath;
    private final String baselineReportPath;
    private final String reportGeneration;
    private final String chartConfiguration;
    private final List<Metric> metrics;
    private final String metaDataFile;
    private final boolean languageJava;
    private final boolean languageCSharp;
    private final boolean languageCPlusPlus;
    private final boolean languagePython;
    private final String sonargraphBuildJDK;
    private final String sonargraphBuildVersion;
    private final String activationCode;
    private final String licenseFile;
    private final String workspaceProfile;
    private final String snapshotDirectory;
    private final String snapshotFileName;
    private final String logLevel;
    private final String logFile;
    private final boolean splitByModule;
    private final String elementCountToSplitHtmlReport;
    private final String maxElementCountForHtmlDetailsPage;

    @DataBoundConstructor
    public SonargraphReportBuilder(List<Metric> metrics, String metaDataFile, String systemDirectory, String qualityModelFile, String virtualModel, String reportPath, String baselineReportPath, String reportGeneration, String chartConfiguration, String architectureViolationsAction, String unassignedTypesAction, String cyclicElementsAction, String thresholdViolationsAction, String architectureWarningsAction, String workspaceWarningsAction, String workItemsAction, String emptyWorkspaceAction, boolean languageJava, boolean languageCSharp, boolean languageCPlusPlus, boolean languagePython, String sonargraphBuildJDK, String sonargraphBuildVersion, String activationCode, String licenseFile, String workspaceProfile, String snapshotDirectory, String snapshotFileName, String logLevel, String logFile, String elementCountToSplitHtmlReport, String maxElementCountForHtmlDetailsPage, boolean splitByModule) {
        super(architectureViolationsAction, unassignedTypesAction, cyclicElementsAction, thresholdViolationsAction, architectureWarningsAction, workspaceWarningsAction, workItemsAction, emptyWorkspaceAction);
        this.systemDirectory = systemDirectory;
        this.qualityModelFile = qualityModelFile;
        this.virtualModel = virtualModel;
        this.reportPath = reportPath;
        this.baselineReportPath = baselineReportPath;
        this.reportGeneration = reportGeneration;
        this.chartConfiguration = chartConfiguration;
        this.metaDataFile = metaDataFile;
        this.metrics = metrics;
        this.languageJava = languageJava;
        this.languageCSharp = languageCSharp;
        this.languageCPlusPlus = languageCPlusPlus;
        this.languagePython = languagePython;
        this.sonargraphBuildJDK = sonargraphBuildJDK;
        this.sonargraphBuildVersion = sonargraphBuildVersion;
        this.activationCode = activationCode;
        this.licenseFile = licenseFile;
        this.workspaceProfile = workspaceProfile;
        this.snapshotDirectory = snapshotDirectory;
        this.snapshotFileName = snapshotFileName;
        this.logFile = logFile;
        this.logLevel = logLevel;
        this.splitByModule = splitByModule;
        this.elementCountToSplitHtmlReport = elementCountToSplitHtmlReport;
        this.maxElementCountForHtmlDetailsPage = maxElementCountForHtmlDetailsPage;
    }

    public Collection<Action> getProjectActions(AbstractProject<?, ?> project) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (project instanceof Project || project instanceof TopLevelItem && !(project instanceof Queue.FlyweightTask)) {
            ResultWithOutcome<MetricIds> result = SonargraphReportBuilder.getMetricIds(project);
            if (result.isSuccess()) {
                ArrayList<String> metricList = new ArrayList<String>();
                MetricIds exportMetaData = (MetricIds)result.getOutcome();
                if (this.isAllCharts()) {
                    metricList.addAll(exportMetaData.getMetricIds().keySet());
                } else if (this.isJavaCharts()) {
                    metricList.addAll(exportMetaData.getMetricIds("JavaLanguageProvider").keySet());
                } else if (this.isCplusplusCharts()) {
                    metricList.addAll(exportMetaData.getMetricIds("CPlusPlusLanguageProvider").keySet());
                } else if (this.isCsharpCharts()) {
                    metricList.addAll(exportMetaData.getMetricIds("CSharpLanguageProvider").keySet());
                } else if (this.isPythonCharts()) {
                    metricList.addAll(exportMetaData.getMetricIds("PythonLanguageProvider").keySet());
                } else if (this.metrics != null) {
                    for (Metric metric : this.metrics) {
                        metricList.add(metric.getMetricName());
                    }
                }
                actions.add(new SonargraphChartAction(project, metricList, exportMetaData));
            } else {
                SonargraphLogger.INSTANCE.log(Level.SEVERE, "Cannot add SonargraphChartAction, no Meta Data found.");
            }
            actions.add(new SonargraphHTMLReportAction(project));
        }
        return actions;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        super.logExecutionStart(build, listener, SonargraphReportBuilder.class);
        if (this.isGeneratedBySonargraphBuild() && !this.callSonargraphBuild(build, launcher, listener)) {
            return false;
        }
        FilePath sonargraphReportDirectory = new FilePath(build.getWorkspace(), this.getReportDirectory());
        if (super.processSonargraphReport(build, sonargraphReportDirectory, this.getReportFileName(), listener.getLogger())) {
            this.addActions(build);
        }
        return true;
    }

    private boolean callSonargraphBuild(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        FilePath clientJar;
        SonargraphBuild sonargraphBuild;
        JDK jdk;
        SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "Calling Sonargraph Build.", null);
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return false;
        }
        String jdkName = this.getSonargraphBuildJDK();
        if (jdkName == null || jdkName.isEmpty()) {
            List allJDKs = jenkins.getJDKs();
            if (allJDKs.size() == 0) {
                jdk = new JDK("default", System.getProperty("java.home"));
                SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.WARNING, "Must try to use JDK Jenkins is running with for Sonargraph Build.", null);
            } else if (allJDKs.size() == 1) {
                jdk = (JDK)allJDKs.get(0);
                SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "Using default JDK '" + jdk.getName() + "' for Sonargraph Build.", null);
            } else {
                jdk = (JDK)allJDKs.get(0);
                SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.WARNING, "There are multiple JDKs, please configure one of them. Using JDK '" + jdk.getName() + "' (the first one) for Sonargraph Build.", null);
            }
        } else {
            jdk = jenkins.getJDK(jdkName);
            SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "Using configured JDK '" + jdkName + "' for Sonargraph Build.", null);
        }
        if (jdk == null) {
            SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.SEVERE, "Unknown JDK '" + jdkName + "' configured for Sonargraph Build.", null);
            return false;
        }
        jdk = jdk.forNode(build.getBuiltOn(), (TaskListener)listener);
        FilePath javaDir = new FilePath(launcher.getChannel(), jdk.getHome());
        FilePath javaBinDir = new FilePath(javaDir, "bin");
        FilePath javaExe = new FilePath(javaBinDir, File.separatorChar == '\\' ? "java.exe" : "java");
        SonargraphBuild.DescriptorImpl descriptor = (SonargraphBuild.DescriptorImpl)jenkins.getDescriptorByType(SonargraphBuild.DescriptorImpl.class);
        String version = this.getSonargraphBuildVersion();
        if (version == null || version.isEmpty()) {
            SonargraphBuild[] allSonargraphBuildInstallations = (SonargraphBuild[])descriptor.getInstallations();
            if (allSonargraphBuildInstallations.length != 1) {
                SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.SEVERE, "Sonargraph Build not configured.", null);
                return false;
            }
            sonargraphBuild = allSonargraphBuildInstallations[0];
        } else {
            sonargraphBuild = descriptor.getSonargraphBuild(version);
        }
        if (sonargraphBuild == null) {
            SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.SEVERE, "Unknown Sonargraph Build configured.", null);
            return false;
        }
        sonargraphBuild = sonargraphBuild.forNode(build.getBuiltOn(), (TaskListener)listener);
        FilePath installationDirectory = new FilePath(launcher.getChannel(), sonargraphBuild.getHome());
        FilePath pluginsDirectory = new FilePath(installationDirectory, "plugins");
        FilePath clientDirectory = new FilePath(installationDirectory, "client");
        FilePath[] osgiJars = pluginsDirectory.list(ORG_ECLIPSE_OSGI_JAR);
        FilePath osgiJar = osgiJars.length == 1 ? osgiJars[0] : null;
        FilePath[] clientJars = pluginsDirectory.list(SONARGRAPH_BUILD_CLIENT_JAR);
        FilePath filePath = clientJar = clientJars.length == 1 ? clientJars[0] : null;
        if (clientJar == null) {
            clientJars = clientDirectory.list(SONARGRAPH_BUILD_CLIENT_JAR);
            FilePath filePath2 = clientJar = clientJars.length == 1 ? clientJars[0] : null;
        }
        if (osgiJar == null || clientJar == null) {
            SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.SEVERE, "Missing plugins in Sonargraph Build installation.", null);
            return false;
        }
        VersionNumber clientVersion = SonargraphUtil.getVersionFromJarName(clientJar.getName());
        SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "SonargraphBuild client jar version is " + clientVersion, null);
        File configurationFileMaster = File.createTempFile("sonargraphBuildConfigurationMaster", ".xml");
        SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "Writing SonargraphBuild temporary configuration file on master to " + configurationFileMaster.getAbsolutePath(), null);
        ConfigurationFileWriter writer = new ConfigurationFileWriter(configurationFileMaster);
        EnumMap<ConfigurationFileWriter.MandatoryParameter, String> parameters = new EnumMap<ConfigurationFileWriter.MandatoryParameter, String>(ConfigurationFileWriter.MandatoryParameter.class);
        parameters.put(ConfigurationFileWriter.MandatoryParameter.ACTIVATION_CODE, this.getActivationCode());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.INSTALLATION_DIRECTORY, sonargraphBuild.getHome());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.LANGUAGES, SonargraphReportBuilder.getLanguages(this.languageJava, this.languageCPlusPlus, this.languageCSharp, this.languagePython));
        parameters.put(ConfigurationFileWriter.MandatoryParameter.SYSTEM_DIRECTORY, this.getSystemDirectory());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.REPORT_DIRECTORY, this.getReportDirectory());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.REPORT_FILENAME, this.getReportFileName());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.REPORT_TYPE, this.getReportType());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.REPORT_FORMAT, this.getReportFormat());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.QUALITY_MODEL_FILE, this.getQualityModelFile());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.VIRTUAL_MODEL, this.getVirtualModel());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.LICENSE_FILE, this.getLicenseFile());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.LICENSE_SERVER_HOST, this.getDescriptor().getLicenseServerHost());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.LICENSE_SERVER_PORT, this.getDescriptor().getLicenseServerPort());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.WORKSPACE_PROFILE, this.getWorkspaceProfile());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.SNAPSHOT_DIRECTORY, this.getSnapshotDirectory());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.SNAPSHOT_FILE_NAME, this.getSnapshotFileName());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.LOG_LEVEL, this.getLogLevel());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.LOG_FILE, this.getLogFile());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.SPLIT_BY_MODULE, this.isSplitByModule() ? "true" : "false");
        parameters.put(ConfigurationFileWriter.MandatoryParameter.ELEMENT_COUNT_TO_SPLIT_HTML_REPORT, this.getElementCountToSplitHtmlReport());
        parameters.put(ConfigurationFileWriter.MandatoryParameter.MAX_ELEMENT_COUNT_FOR_HTML_DETEILS_PAGE, this.getMaxElementCountForHtmlDetailsPage());
        VersionNumber since = new VersionNumber("9.12");
        if (clientVersion.isNewerThan(since)) {
            parameters.put(ConfigurationFileWriter.MandatoryParameter.PROGRESS_INFO, "basic");
        }
        if (clientVersion.isNewerThan(since = new VersionNumber("9.13"))) {
            parameters.put(ConfigurationFileWriter.MandatoryParameter.REPORT_BASELINE, this.getBaselineReportPath() + ".xml");
        }
        writer.createConfigurationFile(parameters, listener.getLogger());
        String content = new FilePath(configurationFileMaster).readToString();
        FilePath configurationFileSlave = javaDir.createTextTempFile("sonargraphBuildConfigurationSlave", ".xml", content, false);
        String classpathSeparator = launcher.isUnix() ? ":" : ";";
        String sonargraphBuildCommand = this.handleBlanksForConsoleCommand(javaExe.getRemote()) + " -ea -cp " + this.handleBlanksForConsoleCommand(clientJar.getRemote()) + classpathSeparator + this.handleBlanksForConsoleCommand(osgiJar.getRemote()) + " " + SONARGRAPH_BUILD_MAIN_CLASS + " " + configurationFileSlave.getRemote();
        Launcher.ProcStarter procStarter = new Launcher.ProcStarter(launcher);
        procStarter.cmdAsSingleString(sonargraphBuildCommand);
        procStarter.stdout((OutputStream)listener.getLogger());
        FilePath workspace = build.getWorkspace();
        SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "Setting working directory for Sonargraph Build to " + workspace, null);
        procStarter = procStarter.pwd(workspace);
        Proc proc = launcher.launch(procStarter);
        int processExitCode = proc.join();
        if (processExitCode != 0) {
            SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.SEVERE, "There was an error when executing Sonargraph Build. Check the global configuration parameters and the relative paths to make sure that everything is in place.", null);
            return false;
        }
        return true;
    }

    private String handleBlanksForConsoleCommand(String partOfCommand) {
        if (partOfCommand.contains(" ")) {
            return "\"" + partOfCommand + "\"";
        }
        return partOfCommand;
    }

    private String getReportType() {
        return "standard";
    }

    @Override
    public String getReportPath() {
        if (this.isGeneratedBySonargraphBuild()) {
            return ConfigParameters.SONARGRAPH_REPORT_TARGET_DIRECTORY.getValue() + ConfigParameters.SONARGRAPH_REPORT_FILE_NAME.getValue();
        }
        return this.reportPath;
    }

    public String getBaselineReportPath() {
        return this.baselineReportPath;
    }

    public String getMetaDataFile() {
        return this.metaDataFile;
    }

    public boolean getLanguageJava() {
        return this.languageJava;
    }

    public boolean getLanguageCSharp() {
        return this.languageCSharp;
    }

    public boolean getLanguageCPlusPlus() {
        return this.languageCPlusPlus;
    }

    public boolean getLanguagePython() {
        return this.languagePython;
    }

    protected static String getLanguages(boolean languageJava, boolean languageCPlusPlus, boolean languageCSharp, boolean languagePython) {
        boolean allLanguages = !languageJava && !languageCPlusPlus && !languageCSharp && !languagePython;
        ArrayList<String> languages = new ArrayList<String>();
        if (allLanguages || languageJava) {
            languages.add("Java");
        }
        if (allLanguages || languageCPlusPlus) {
            languages.add("CPlusPlus");
        }
        if (allLanguages || languageCSharp) {
            languages.add("CSharp");
        }
        if (allLanguages || languagePython) {
            languages.add("Python");
        }
        return languages.stream().collect(Collectors.joining(","));
    }

    public String getSonargraphBuildJDK() {
        return this.sonargraphBuildJDK;
    }

    public String getSonargraphBuildVersion() {
        return this.sonargraphBuildVersion;
    }

    public String getActivationCode() {
        return this.activationCode;
    }

    public String getLicenseFile() {
        return this.licenseFile;
    }

    public String getWorkspaceProfile() {
        return this.workspaceProfile;
    }

    public String getSnapshotDirectory() {
        return this.snapshotDirectory;
    }

    public String getSnapshotFileName() {
        return this.snapshotFileName;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getLogFile() {
        return this.logFile;
    }

    private String getReportFileName() {
        if (this.isGeneratedBySonargraphBuild()) {
            return ConfigParameters.SONARGRAPH_REPORT_FILE_NAME.getValue();
        }
        return new File(this.getReportPath()).getName();
    }

    @Override
    public String getReportDirectory() {
        if (this.isGeneratedBySonargraphBuild()) {
            return ConfigParameters.SONARGRAPH_REPORT_TARGET_DIRECTORY.getValue();
        }
        return new File(this.getReportPath()).getParent();
    }

    private String getReportFormat() {
        return "xml,html";
    }

    public String getSystemDirectory() {
        return this.systemDirectory;
    }

    public String getReportGeneration() {
        return this.reportGeneration;
    }

    public String getChartConfiguration() {
        return this.chartConfiguration;
    }

    public String getQualityModelFile() {
        return this.qualityModelFile;
    }

    public String getVirtualModel() {
        return this.virtualModel;
    }

    public String getMaxElementCountForHtmlDetailsPage() {
        return this.maxElementCountForHtmlDetailsPage;
    }

    public String getElementCountToSplitHtmlReport() {
        return this.elementCountToSplitHtmlReport;
    }

    public boolean isSplitByModule() {
        return this.splitByModule;
    }

    public boolean isGeneratedBySonargraphBuild() {
        return !this.isPreGenerated();
    }

    public boolean isPreGenerated() {
        return "preGenerated".equals(this.getReportGeneration());
    }

    public boolean isAllCharts() {
        return "allCharts".equals(this.getChartConfiguration());
    }

    public boolean isJavaCharts() {
        return "javaCharts".equals(this.getChartConfiguration());
    }

    public boolean isCplusplusCharts() {
        return "cplusplusCharts".equals(this.getChartConfiguration());
    }

    public boolean isCsharpCharts() {
        return "csharpCharts".equals(this.getChartConfiguration());
    }

    public boolean isPythonCharts() {
        return "pythonCharts".equals(this.getChartConfiguration());
    }

    public boolean isSelectedCharts() {
        return "selectedCharts".equals(this.getChartConfiguration());
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    protected static ResultWithOutcome<MetricIds> getMetricIds(AbstractProject<?, ?> project) {
        InputStream is;
        ResultWithOutcome<MetricIds> historyResult;
        ResultWithOutcome overallResult = new ResultWithOutcome("Get stored MetricIds");
        if (s_metricIdsHistory == null) {
            File metricIdsHistoryFile = new File(project.getRootDir(), ConfigParameters.METRICIDS_HISTORY_JSON_FILE_PATH.getValue());
            s_metricIdsHistory = new MetricIdsHistory(metricIdsHistoryFile);
        }
        if ((historyResult = s_metricIdsHistory.readMetricIds()).isFailure()) {
            overallResult.addMessagesFrom(historyResult);
            return overallResult;
        }
        IMetaDataController controller = ControllerFactory.createMetaDataController();
        ResultWithOutcome exportMetaDataResult = controller.loadExportMetaData(is = SonargraphReportBuilder.class.getResourceAsStream(DEFAULT_META_DATA_XML), DEFAULT_META_DATA_XML);
        if (exportMetaDataResult.isFailure()) {
            overallResult.addMessagesFrom((Result)exportMetaDataResult);
            return overallResult;
        }
        MetricIds defaultMetricIds = MetricIds.fromExportMetaData((IExportMetaData)exportMetaDataResult.getOutcome());
        MetricIds historyMetricIds = (MetricIds)historyResult.getOutcome();
        overallResult.setOutcome((Serializable)defaultMetricIds.addAll(historyMetricIds));
        return overallResult;
    }

    public static boolean validateNotNullAndRegexp(String value, String pattern) {
        if (value == null) {
            return false;
        }
        return value.matches(pattern);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractBuildStepDescriptor {
        static final List<String> DEFAULT_QUALITY_MODELS = Arrays.asList("Sonargraph:Default.sgqm", "Sonargraph:Java.sgqm", "Sonargraph:CSharp.sgqm", "Sonargraph:CPlusPlus.sgqm");
        static final List<String> LOG_LEVELS = Arrays.asList("info", "off", "error", "warn", "debug", "trace", "all");
        private String licenseServerHost;
        private String licenseServerPort;

        public DescriptorImpl() {
            this.load();
        }

        public String getLicenseServerHost() {
            return this.licenseServerHost;
        }

        public String getLicenseServerPort() {
            return this.licenseServerPort;
        }

        public void setLicenseServerHost(String licenseServerHost) {
            this.licenseServerHost = licenseServerHost;
            SonargraphLogger.INSTANCE.log(Level.INFO, "License Server Host is " + licenseServerHost);
        }

        public void setLicenseServerPort(String licenseServerPort) {
            this.licenseServerPort = licenseServerPort;
            SonargraphLogger.INSTANCE.log(Level.INFO, "License Server Port is " + licenseServerPort);
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            json = json.getJSONObject("sonargraph");
            this.setLicenseServerHost(json.getString("licenseServerHost"));
            this.setLicenseServerPort(json.getString("licenseServerPort"));
            this.save();
            return true;
        }

        public String getDisplayName() {
            return ConfigParameters.REPORT_BUILDER_DISPLAY_NAME.getValue();
        }

        public ListBoxModel doFillSonargraphBuildJDKItems() {
            ListBoxModel items = new ListBoxModel();
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return items;
            }
            for (JDK jdk : jenkins.getJDKs()) {
                items.add(jdk.getName(), jdk.getName());
            }
            return items;
        }

        public ListBoxModel doFillSonargraphBuildVersionItems() {
            ListBoxModel items = new ListBoxModel();
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return items;
            }
            SonargraphBuild.DescriptorImpl descriptor = (SonargraphBuild.DescriptorImpl)jenkins.getDescriptorByType(SonargraphBuild.DescriptorImpl.class);
            for (SonargraphBuild sonargraphBuild : (SonargraphBuild[])descriptor.getInstallations()) {
                items.add(sonargraphBuild.getName(), sonargraphBuild.getName());
            }
            return items;
        }

        public ListBoxModel doFillMetricCategoryItems(@AncestorInPath AbstractProject<?, ?> project) {
            ListBoxModel items = new ListBoxModel();
            ResultWithOutcome<MetricIds> result = SonargraphReportBuilder.getMetricIds(project);
            if (result.isSuccess()) {
                MetricIds metaData = (MetricIds)result.getOutcome();
                metaData.getMetricCategories().stream().sorted().forEachOrdered(category -> items.add(category, category));
            }
            return items;
        }

        public ListBoxModel doFillMetricNameItems(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String metricCategory, @QueryParameter(value="metaDataFile") @RelativePath(value="..") String metaDataFile) {
            if (metricCategory == null || metricCategory.isEmpty()) {
                SonargraphLogger.INSTANCE.log(Level.WARNING, "metric category is unset, assume 'Architecture'");
                metricCategory = "Architecture";
            }
            ListBoxModel items = new ListBoxModel();
            ResultWithOutcome<MetricIds> result = SonargraphReportBuilder.getMetricIds(project);
            if (result.isSuccess()) {
                MetricIds metaData = (MetricIds)result.getOutcome();
                for (MetricId metric : metaData.getMetricIdsForCategory(metricCategory)) {
                    items.add(metric.getName(), metric.getId());
                }
            }
            return items;
        }

        public ComboBoxModel doFillQualityModelFileItems() {
            return new ComboBoxModel(DEFAULT_QUALITY_MODELS);
        }

        public FormValidation doCheckLicenseFile(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) {
            return this.checkAbsoluteFile(value, "license");
        }

        public FormValidation doCheckElementCountToSplitHtmlReport(@QueryParameter String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.ok();
            }
            return this.checkSplitIntegerParameter(value);
        }

        public FormValidation doCheckMaxElementCountForHtmlDetailsPage(@QueryParameter String value) {
            return this.checkSplitIntegerParameter(value);
        }

        public FormValidation doCheckLicenseServerPort(@QueryParameter String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.ok();
            }
            try {
                int parsed = Integer.parseUnsignedInt(value);
                if (parsed > 0 && parsed <= 65535) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Please enter a valid port number.");
        }

        public FormValidation doCheckLogFile(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
            FilePath ws = project.getSomeWorkspace();
            if (ws == null) {
                return FormValidation.error((String)"Please run build at least once to get a workspace.");
            }
            FormValidation validateRelativePath = ws.validateRelativePath(value, false, true);
            if (validateRelativePath.kind != FormValidation.Kind.OK) {
                return validateRelativePath;
            }
            FilePath logfile = new FilePath(ws, value);
            String logfileURL = project.getAbsoluteUrl() + "ws/" + value;
            return FormValidation.okWithMarkup((String)("Logfile is <a href='" + logfileURL + "'>" + logfile.getRemote() + "</a>"));
        }

        public FormValidation doCheckQualityModelFile(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
            if (DEFAULT_QUALITY_MODELS.contains(value)) {
                return FormValidation.ok();
            }
            return this.checkFileInWorkspace(project, value, "sgqm");
        }

        public FormValidation doCheckReportPath(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
            if (value != null && !value.isEmpty()) {
                File withParent = new File(value);
                File parent = withParent.getParentFile();
                if (parent == null) {
                    return FormValidation.error((String)"Please enter a path with at least one directory.");
                }
                if (value.endsWith(".xml")) {
                    return FormValidation.error((String)"Please enter a path without extension \".xml\".");
                }
            }
            return this.checkFileInWorkspace(project, value + ".xml", null);
        }

        public FormValidation doCheckBaselineReportPath(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
            if (value != null && !value.isEmpty()) {
                if (value.endsWith(".xml")) {
                    return FormValidation.error((String)"Please enter a path without extension \".xml\".");
                }
                return this.checkFileInWorkspace(project, value + ".xml", null);
            }
            return FormValidation.ok();
        }

        private FormValidation checkSplitIntegerParameter(String value) {
            try {
                int parsed = Integer.parseInt(value);
                if (parsed >= -1) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Please enter either '-1' (never split), or '0' (use default), or a positive integer value.");
        }

        private FormValidation checkFileInWorkspace(AbstractProject<?, ?> project, String file, String extension) throws IOException {
            if (file != null && !file.isEmpty()) {
                if (extension != null && !extension.isEmpty() && !file.endsWith(extension)) {
                    return FormValidation.error((String)("Please enter a valid filename. Extension must be '" + extension + "'."));
                }
                FilePath ws = project.getSomeWorkspace();
                if (ws == null) {
                    return FormValidation.error((String)"Please run build at least once to get a workspace.");
                }
                FormValidation validateRelativePath = ws.validateRelativePath(file, true, true);
                if (validateRelativePath.kind != FormValidation.Kind.OK) {
                    return validateRelativePath;
                }
            }
            return FormValidation.ok();
        }

        private FormValidation checkAbsoluteFile(String file, String extension) {
            if (file != null && !file.isEmpty()) {
                if (extension != null && !extension.isEmpty() && !file.endsWith(extension)) {
                    return FormValidation.error((String)("Please enter a valid filename. Extension must be '" + extension + "'."));
                }
                File f = new File(file);
                if (!f.exists()) {
                    return FormValidation.error((String)"Please enter an existing file.");
                }
                if (!f.canRead()) {
                    return FormValidation.error((String)"Please enter a readable file.");
                }
                if (!f.isAbsolute()) {
                    return FormValidation.error((String)"Please enter an absolute file path.");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSystemDirectory(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
            if (value == null || value.length() == 0) {
                return FormValidation.ok();
            }
            if (!SonargraphReportBuilder.validateNotNullAndRegexp(value, "([a-zA-Z]:\\\\)?[\\/\\\\a-zA-Z0-9_.-]+.sonargraph$")) {
                return FormValidation.error((String)"Please enter a valid system directory");
            }
            FilePath ws = project.getSomeWorkspace();
            if (ws == null) {
                return FormValidation.error((String)"Please run build at least once to get a workspace.");
            }
            return ws.validateRelativeDirectory(value, true);
        }

        public ListBoxModel doFillLogLevelItems() {
            ListBoxModel items = new ListBoxModel();
            LOG_LEVELS.forEach(level -> items.add(level));
            return items;
        }
    }
}

