/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.jenkins.pipeline;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.RootAction;
import hudson.model.UnprotectedRootAction;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class SonarQubeWebHook
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(SonarQubeWebHook.class.getName());
    public static final String URLNAME = "sonarqube-webhook";
    @VisibleForTesting
    List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URLNAME;
    }

    @RequirePOST
    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String payload = IOUtils.toString((Reader)req.getReader());
        LOGGER.info("Received POST from " + req.getRemoteHost());
        try {
            JSONObject o = JSONObject.fromObject((Object)payload);
            LOGGER.fine(() -> "Full details of the POST was " + o.toString());
            String taskId = o.getString("taskId");
            String status = o.getString("status");
            String qgStatus = null;
            if ("SUCCESS".equals(status)) {
                qgStatus = o.has("qualityGate") ? o.getJSONObject("qualityGate").getString("status") : "NONE";
            }
            for (Listener listener : this.listeners) {
                listener.onTaskCompleted(taskId, status, qgStatus);
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.WARNING, e, () -> "Invalid payload " + payload);
            rsp.sendError(400, "Invalid JSON Payload");
        }
        rsp.setStatus(200);
    }

    public static SonarQubeWebHook get() {
        return (SonarQubeWebHook)Jenkins.getInstance().getExtensionList(RootAction.class).get(SonarQubeWebHook.class);
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    @FunctionalInterface
    public static interface Listener {
        public void onTaskCompleted(String var1, String var2, @Nullable String var3);
    }
}

