/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.utils;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.EnvironmentSpecific;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolInstallation;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.triggers.SCMTriggerItem;

public class BuilderUtils {
    private BuilderUtils() {
    }

    @CheckForNull
    public static <T extends ToolInstallation & NodeSpecific<T>> T getBuildTool(@Nullable T tool, EnvVars env, TaskListener listener, FilePath workspace) throws IOException, InterruptedException {
        Computer computer = workspace.toComputer();
        if (computer == null) {
            return null;
        }
        Node node = computer.getNode();
        if (tool == null || node == null) {
            return null;
        }
        ToolInstallation t = (ToolInstallation)((NodeSpecific<T>)tool).forNode(node, listener);
        t = (ToolInstallation)((EnvironmentSpecific)t).forEnvironment(env);
        return (T)t;
    }

    public static EnvVars getEnvAndBuildVars(Run<?, ?> run, TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = run.getEnvironment(listener);
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
        }
        return env;
    }

    public static FilePath getModuleRoot(Run<?, ?> run, FilePath workspace) {
        FilePath moduleRoot = null;
        if (run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            moduleRoot = build.getModuleRoot();
        } else {
            SCMTriggerItem scmTrigger;
            Collection scms;
            Job parent = run.getParent();
            if (parent instanceof SCMTriggerItem && !(scms = (scmTrigger = (SCMTriggerItem)parent).getSCMs()).isEmpty()) {
                SCM scm = (SCM)scms.iterator().next();
                FilePath[] moduleRoots = scm.getModuleRoots(workspace, null);
                FilePath filePath = moduleRoot = moduleRoots != null && moduleRoots.length > 0 ? moduleRoots[0] : null;
            }
            if (moduleRoot == null) {
                moduleRoot = workspace;
            }
        }
        return moduleRoot;
    }
}

