/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.client;

import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.client.HttpClient;
import hudson.plugins.sonar.client.ProjectInformation;
import hudson.plugins.sonar.client.WsClient;
import hudson.plugins.sonar.utils.Logger;
import hudson.plugins.sonar.utils.Version;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class SQProjectResolver {
    private final HttpClient client;

    public SQProjectResolver(HttpClient client) {
        this.client = client;
    }

    @CheckForNull
    public ProjectInformation resolve(@Nullable String serverUrl, @Nullable String projectDashboardUrl, String ceTaskId, String installationName) {
        SonarInstallation inst = SonarInstallation.get(installationName);
        if (inst == null) {
            Logger.LOG.info(() -> "Invalid installation name: " + installationName);
            return null;
        }
        if (serverUrl == null) {
            Logger.LOG.info("No server url.");
            return null;
        }
        try {
            WsClient wsClient = new WsClient(this.client, serverUrl, inst.getServerAuthenticationToken());
            Version version = new Version(wsClient.getServerVersion());
            if (version.compareTo(new Version("5.6")) < 0) {
                Logger.LOG.info(() -> "SQ < 5.6 is not supported");
                return null;
            }
            ProjectInformation projectInfo = new ProjectInformation();
            projectInfo.setUrl(projectDashboardUrl);
            String analysisId = SQProjectResolver.requestCETaskDetails(wsClient, projectInfo, ceTaskId);
            if (analysisId != null) {
                projectInfo.setStatus(wsClient.requestQualityGateStatus(analysisId));
            }
            return projectInfo;
        }
        catch (Exception e) {
            Logger.LOG.log(Level.WARNING, "Error fetching project information", e);
            return null;
        }
    }

    @CheckForNull
    private static String requestCETaskDetails(WsClient wsClient, ProjectInformation projectInfo, String ceTaskId) {
        WsClient.CETask ceTask = wsClient.getCETask(ceTaskId);
        projectInfo.setCeStatus(ceTask.getStatus());
        projectInfo.setCeUrl(ceTask.getUrl());
        projectInfo.setName(ceTask.getComponentName());
        return ceTask.getAnalysisId();
    }
}

