/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarPublisher;
import hudson.plugins.sonar.utils.Logger;
import hudson.util.FormValidation;
import java.util.List;
import java.util.Optional;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=100.0)
public class SonarGlobalConfiguration
extends GlobalConfiguration {
    private volatile SonarInstallation[] installations = new SonarInstallation[0];
    private volatile boolean buildWrapperEnabled = false;
    boolean dataMigrated = false;

    public SonarGlobalConfiguration() {
        this.load();
    }

    public SonarInstallation[] getInstallations() {
        return this.installations;
    }

    public boolean isBuildWrapperEnabled() {
        return this.buildWrapperEnabled;
    }

    public void setInstallations(SonarInstallation ... installations) {
        this.installations = installations;
        this.save();
    }

    public void setBuildWrapperEnabled(boolean enabled) {
        this.buildWrapperEnabled = enabled;
        this.save();
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public void migrateData() {
        if (this.dataMigrated) {
            return;
        }
        Optional<SonarPublisher.DescriptorImpl> publisherOpt = ExtensionList.lookup(SonarPublisher.DescriptorImpl.class).stream().findFirst();
        publisherOpt.ifPresent(publisher -> {
            if (publisher.getDeprecatedInstallations() != null && publisher.getDeprecatedInstallations().length > 0) {
                if (ArrayUtils.isEmpty((Object[])this.installations)) {
                    this.installations = publisher.getDeprecatedInstallations();
                    this.buildWrapperEnabled = publisher.isDeprecatedBuildWrapperEnabled();
                    this.save();
                } else {
                    Logger.LOG.warning("SonarQube server configurations exist in both deprecated SonarPublisher and SonarGlobalConfiguration. Deleting deprecated configuration..");
                }
                publisher.deleteGlobalConfiguration();
            }
        });
        this.dataMigrated = true;
        this.save();
    }

    public boolean configure(StaplerRequest req, JSONObject json) {
        List list = req.bindJSONToList(SonarInstallation.class, json.get("inst"));
        boolean enableBuildWrapper = json.getBoolean("enableBuildWrapper");
        this.setInstallations(list.toArray(new SonarInstallation[list.size()]));
        this.setBuildWrapperEnabled(enableBuildWrapper);
        return true;
    }

    public FormValidation doCheckMandatory(@QueryParameter String value) {
        return StringUtils.isBlank((String)value) ? FormValidation.error((String)Messages.SonarGlobalConfiguration_MandatoryProperty()) : FormValidation.ok();
    }

    public static SonarGlobalConfiguration get() {
        return (SonarGlobalConfiguration)((Object)GlobalConfiguration.all().get(SonarGlobalConfiguration.class));
    }
}

