/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import com.google.common.annotations.VisibleForTesting;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.SonarGlobalConfiguration;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.action.SonarMarkerAction;
import hudson.plugins.sonar.utils.Logger;
import hudson.plugins.sonar.utils.MaskPasswordsOutputStream;
import hudson.plugins.sonar.utils.SonarUtils;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import jenkins.tasks.SimpleBuildWrapper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class SonarBuildWrapper
extends SimpleBuildWrapper {
    private String installationName = null;

    @DataBoundConstructor
    public SonarBuildWrapper(@Nullable String installationName) {
        this.installationName = installationName;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        SonarInstallation.checkValid(this.getInstallationName());
        SonarInstallation installation = SonarInstallation.get(this.getInstallationName());
        String msg = Messages.SonarBuildWrapper_Injecting(installation.getName());
        Logger.LOG.info(msg);
        listener.getLogger().println(msg);
        context.getEnv().putAll(SonarBuildWrapper.createVars(installation, initialEnvironment));
        context.setDisposer((SimpleBuildWrapper.Disposer)new AddBuildInfo(installation));
        build.addAction((Action)new SonarMarkerAction());
    }

    @VisibleForTesting
    static Map<String, String> createVars(SonarInstallation inst, EnvVars initialEnvironment) {
        String additionalAnalysisProperties;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("SONAR_CONFIG_NAME", inst.getName());
        String hostUrl = SonarBuildWrapper.getOrDefault(initialEnvironment.expand(inst.getServerUrl()), "http://localhost:9000");
        map.put("SONAR_HOST_URL", hostUrl);
        String token = SonarBuildWrapper.getOrDefault(initialEnvironment.expand(inst.getServerAuthenticationToken()), "");
        map.put("SONAR_AUTH_TOKEN", token);
        String mojoVersion = inst.getMojoVersion();
        if (StringUtils.isEmpty((String)mojoVersion)) {
            map.put("SONAR_MAVEN_GOAL", "sonar:sonar");
        } else {
            map.put("SONAR_MAVEN_GOAL", SonarUtils.getMavenGoal(mojoVersion));
        }
        map.put("SONAR_EXTRA_PROPS", SonarBuildWrapper.getOrDefault(initialEnvironment.expand(SonarBuildWrapper.getAdditionalProps(inst)), ""));
        EnvVars.resolve(map);
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"sonar.host.url\" : \"").append(StringEscapeUtils.escapeJson((String)hostUrl)).append("\"");
        if (!token.isEmpty()) {
            sb.append(", \"sonar.login\" : \"").append(StringEscapeUtils.escapeJson((String)token)).append("\"");
        }
        if ((additionalAnalysisProperties = inst.getAdditionalAnalysisProperties()) != null) {
            for (String pair : StringUtils.split((String)additionalAnalysisProperties)) {
                String[] keyValue = StringUtils.split((String)pair, (String)"=");
                if (keyValue.length != 2) continue;
                sb.append(", \"").append(StringEscapeUtils.escapeJson((String)keyValue[0])).append("\" : \"").append(StringEscapeUtils.escapeJson((String)initialEnvironment.expand(keyValue[1]))).append("\"");
            }
        }
        sb.append("}");
        map.put("SONARQUBE_SCANNER_PARAMS", sb.toString());
        return map;
    }

    private static String getAdditionalProps(SonarInstallation inst) {
        ArgumentListBuilder builder = new ArgumentListBuilder();
        builder.add(inst.getAdditionalAnalysisPropertiesUnix());
        builder.add(inst.getAdditionalProperties());
        return StringUtils.join((Collection)builder.toList(), (char)' ');
    }

    private static String getOrDefault(String value, String defaultValue) {
        return !StringUtils.isEmpty((String)value) ? value : defaultValue;
    }

    public ConsoleLogFilter createLoggerDecorator(Run<?, ?> build) {
        SonarInstallation inst = SonarInstallation.get(this.getInstallationName());
        if (inst == null) {
            return null;
        }
        Logger.LOG.info(Messages.SonarBuildWrapper_MaskingPasswords());
        ArrayList<String> passwords = new ArrayList<String>();
        if (!StringUtils.isBlank((String)inst.getServerAuthenticationToken())) {
            passwords.add(inst.getServerAuthenticationToken());
        }
        return new SonarQubePasswordLogFilter(passwords, build.getCharset().name());
    }

    @Nullable
    public String getInstallationName() {
        return this.installationName;
    }

    public void setInstallationName(@Nullable String installationName) {
        this.installationName = installationName;
    }

    @Symbol(value={"withSonarQubeEnv"})
    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return Messages.SonarBuildWrapper_DisplayName();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return SonarGlobalConfiguration.get().isBuildWrapperEnabled();
        }

        public SonarInstallation[] getSonarInstallations() {
            return SonarInstallation.all();
        }

        public String getHelpFile() {
            return "/plugin/sonar/help-buildWrapper.html";
        }
    }

    private static class SonarQubePasswordLogFilter
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> passwords;
        private final String consoleCharset;

        public SonarQubePasswordLogFilter(List<String> passwords, String consoleCharset) {
            this.passwords = passwords;
            this.consoleCharset = consoleCharset;
        }

        public OutputStream decorateLogger(Run ignore, OutputStream logger) throws IOException, InterruptedException {
            return new MaskPasswordsOutputStream(logger, Charset.forName(this.consoleCharset), this.passwords);
        }
    }

    private static final class AddBuildInfo
    extends SimpleBuildWrapper.Disposer {
        private static final long serialVersionUID = 1L;
        private final SonarInstallation installation;

        public AddBuildInfo(SonarInstallation installation) {
            this.installation = installation;
        }

        public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            SonarUtils.addBuildInfoTo(build, listener, workspace, this.installation.getName(), build.getResult() == null);
        }
    }
}

