/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.client;

import hudson.model.Run;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.client.HttpClient;
import hudson.plugins.sonar.client.ProjectInformation;
import hudson.plugins.sonar.client.WsClient;
import hudson.plugins.sonar.utils.Logger;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarqube.ws.client.HttpException;

public class SQProjectResolver {
    private final HttpClient client;

    public SQProjectResolver(HttpClient client) {
        this.client = client;
    }

    @CheckForNull
    public ProjectInformation resolve(@Nullable String serverUrl, @Nullable String projectDashboardUrl, String ceTaskId, String installationName, Run<?, ?> build) {
        SonarInstallation inst = SonarInstallation.get(installationName);
        if (inst == null) {
            Logger.LOG.info(() -> "Invalid installation name: " + installationName);
            return null;
        }
        if (serverUrl == null) {
            Logger.LOG.info("No server url.");
            return null;
        }
        ProjectInformation action = (ProjectInformation)build.getAction(ProjectInformation.class);
        if (action != null) {
            return action;
        }
        try {
            String serverAuthenticationToken = inst.getServerAuthenticationToken(build);
            WsClient wsClient = new WsClient(this.client, serverUrl, serverAuthenticationToken);
            ProjectInformation projectInfo = new ProjectInformation();
            projectInfo.setUrl(projectDashboardUrl);
            String analysisId = SQProjectResolver.requestCETaskDetails(wsClient, projectInfo, ceTaskId);
            if (analysisId != null) {
                projectInfo.setStatus(wsClient.requestQualityGateStatus(analysisId));
            }
            return projectInfo;
        }
        catch (HttpException e) {
            if (e.code() == 404) {
                Logger.LOG.log(Level.FINE, "Error fetching project information: {0}", e.getMessage());
            } else {
                Logger.LOG.log(Level.WARNING, "Error fetching project information", e);
            }
            return null;
        }
        catch (Exception e) {
            Logger.LOG.log(Level.WARNING, "Error fetching project information", e);
            return null;
        }
    }

    @CheckForNull
    private static String requestCETaskDetails(WsClient wsClient, ProjectInformation projectInfo, String ceTaskId) {
        WsClient.CETask ceTask = wsClient.getCETask(ceTaskId);
        projectInfo.setCeStatus(ceTask.getStatus());
        projectInfo.setCeUrl(ceTask.getUrl());
        projectInfo.setName(ceTask.getComponentName());
        return ceTask.getAnalysisId();
    }
}

