/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.client;

import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.sonarqube.ws.client.HttpException;

public class HttpClient {
    private final OkHttpClient okHttpClient;

    public HttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public String getHttp(String url, @Nullable String token) {
        Request request = HttpClient.newRequest(url, token);
        Response response = this.httpCall(request);
        String content = HttpClient.getContent(response);
        if (HttpClient.isSuccessful(response)) {
            return content;
        }
        throw new HttpException(url, response.code(), content);
    }

    private static Request newRequest(String url, @Nullable String token) {
        Request.Builder builder = new Request.Builder().url(url);
        if (!Strings.isNullOrEmpty((String)token)) {
            builder.addHeader("Authorization", Credentials.basic((String)token, (String)"", (Charset)StandardCharsets.UTF_8));
        }
        return builder.build();
    }

    private static String getContent(Response response) {
        String string;
        block8: {
            ResponseBody body = response.body();
            try {
                string = body.string();
                if (body == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Fail to read response of " + response.request().url(), e);
                }
            }
            body.close();
        }
        return string;
    }

    private Response httpCall(Request request) {
        try {
            return this.okHttpClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to request " + request.url(), e);
        }
    }

    private static boolean isSuccessful(Response response) {
        return response.code() >= 200 && response.code() < 300;
    }
}

