/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.utils;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.AbstractMavenBuild;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.local_repo.DefaultLocalRepositoryLocator;
import hudson.maven.local_repo.LocalRepositoryLocator;
import hudson.maven.local_repo.PerJobLocalRepositoryLocator;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.JDK;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarPublisher;
import hudson.plugins.sonar.client.HttpClient;
import hudson.plugins.sonar.client.OkHttpClientSingleton;
import hudson.plugins.sonar.utils.ExtendedArgumentListBuilder;
import hudson.plugins.sonar.utils.SonarUtils;
import hudson.tasks.Maven;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.mvn.GlobalSettingsProvider;
import jenkins.mvn.SettingsProvider;
import org.apache.commons.lang.StringUtils;

public final class SonarMaven
extends Maven {
    private static final String TARGET = "-e -B";
    private final SonarPublisher publisher;
    private final String additionalProperties;
    private JDK jdk;
    private final BuildListener listener;
    private final LocalRepositoryLocator locaRepository;
    private final HttpClient client;

    public SonarMaven(String additionalProperties, String name, String pom, String jvmOptions, LocalRepositoryLocator locaRepository, SonarPublisher publisher, BuildListener listener, JDK jdk, SettingsProvider settings, GlobalSettingsProvider globalSettings, HttpClient client) {
        super(SonarMaven.getTarget(publisher.getInstallation()), name, pom, "", jvmOptions, false, settings, globalSettings);
        this.additionalProperties = additionalProperties;
        this.locaRepository = locaRepository;
        this.publisher = publisher;
        this.jdk = jdk;
        this.listener = listener;
        this.client = client;
    }

    static String getTarget(SonarInstallation installation) {
        String mojoVersion = installation.getMojoVersion();
        if (StringUtils.isBlank((String)mojoVersion)) {
            return "-e -B sonar:sonar";
        }
        return "-e -B " + SonarUtils.getMavenGoal(mojoVersion);
    }

    private SonarInstallation getInstallation() {
        return this.publisher.getInstallation();
    }

    protected void wrapUpArguments(ArgumentListBuilder args, String normalizedTarget, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        FilePath workspace;
        args.addTokenized(this.additionalProperties);
        ExtendedArgumentListBuilder argsBuilder = new ExtendedArgumentListBuilder(args, launcher.isUnix());
        argsBuilder.append("sonar.host.url", this.getInstallation().getServerUrl());
        argsBuilder.append("sonar.branch", this.publisher.getBranch());
        String token = this.getInstallation().getServerAuthenticationToken((Run<?, ?>)build);
        if (StringUtils.isNotBlank((String)token)) {
            argsBuilder.appendMasked(SonarUtils.getTokenProperty(this.getInstallation(), build, this.client), token);
        }
        if (build instanceof MavenModuleSetBuild) {
            FilePath localRepo = this.locaRepository.locate((AbstractMavenBuild)((MavenModuleSetBuild)build));
            if (localRepo != null) {
                args.add("-Dmaven.repo.local=" + localRepo.getRemote());
            }
        } else if (this.locaRepository instanceof PerJobLocalRepositoryLocator && (workspace = build.getWorkspace()) != null) {
            args.add("-Dmaven.repo.local=" + workspace.child(".repository"));
        }
    }

    public Maven.DescriptorImpl getDescriptor() {
        return (Maven.DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(Maven.class);
    }

    public static boolean executeMaven(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, String mavenName, String pom, SonarInstallation sonarInstallation, SonarPublisher sonarPublisher, JDK jdk, SettingsProvider settings, GlobalSettingsProvider globalSettings, boolean usesLocalRepository) throws IOException, InterruptedException {
        MavenModuleSet mavenModuleProject = sonarPublisher.getMavenProject(build);
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        String mvnOptions = sonarPublisher.getMavenOpts();
        if (StringUtils.isEmpty((String)mvnOptions) && mavenModuleProject != null && StringUtils.isNotEmpty((String)mavenModuleProject.getMavenOpts())) {
            mvnOptions = mavenModuleProject.getMavenOpts();
        }
        PerJobLocalRepositoryLocator locaRepositoryToUse = usesLocalRepository ? new PerJobLocalRepositoryLocator() : new DefaultLocalRepositoryLocator();
        SettingsProvider settingsToUse = settings;
        GlobalSettingsProvider globalSettingsToUse = globalSettings;
        if (mavenModuleProject != null) {
            locaRepositoryToUse = mavenModuleProject.getLocalRepository();
            settingsToUse = mavenModuleProject.getSettings();
            globalSettingsToUse = mavenModuleProject.getGlobalSettings();
        }
        String additionalArguments = sonarInstallation.getAdditionalProperties();
        String analysisProperties = StringUtils.join((Object[])sonarInstallation.getAdditionalAnalysisPropertiesUnix(), (char)' ');
        String jobProperties = envVars.expand(sonarPublisher.getJobAdditionalProperties());
        String additionalProperties = (StringUtils.isNotBlank((String)additionalArguments) ? additionalArguments : "") + " " + (StringUtils.isNotBlank((String)analysisProperties) ? analysisProperties : "") + " " + (StringUtils.isNotBlank((String)jobProperties) ? jobProperties : "");
        String pomPath = build.getModuleRoot().child(pom).getRemote();
        return new SonarMaven(additionalProperties, mavenName, pomPath, mvnOptions, (LocalRepositoryLocator)locaRepositoryToUse, sonarPublisher, listener, jdk, settingsToUse, globalSettingsToUse, new HttpClient(OkHttpClientSingleton.getInstance())).perform(build, launcher, listener);
    }

    protected void buildEnvVars(EnvVars env, Maven.MavenInstallation mi) throws IOException, InterruptedException {
        super.buildEnvVars(env, mi);
        if (this.jdk != null) {
            Computer computer = Computer.currentComputer();
            if (computer != null) {
                this.jdk = this.jdk.forNode(computer.getNode(), (TaskListener)this.listener);
            }
            this.jdk.buildEnvVars(env);
        }
    }
}

