/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.AbortException;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sonar.GlobalCredentialMigrator;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.SonarGlobalConfiguration;
import hudson.plugins.sonar.model.TriggersConfig;
import hudson.util.Secret;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;

public class SonarInstallation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String serverUrl;
    private String credentialsId;
    private String webhookSecretId;
    @Deprecated
    private Secret serverAuthenticationToken;
    private String mojoVersion;
    private final String additionalProperties;
    private final String additionalAnalysisProperties;
    private TriggersConfig triggers;
    private String[] split;

    @Deprecated
    public SonarInstallation(String name, String serverUrl, String serverAuthenticationToken, String mojoVersion, String additionalProperties, TriggersConfig triggers, String additionalAnalysisProperties) {
        this(name, serverUrl, null, Secret.fromString((String)StringUtils.trimToNull((String)serverAuthenticationToken)), null, mojoVersion, additionalProperties, additionalAnalysisProperties, triggers);
    }

    @DataBoundConstructor
    public SonarInstallation(String name, String serverUrl, @Nullable String credentialsId, @Nullable Secret serverAuthenticationToken, @Nullable String webhookSecretId, String mojoVersion, String additionalProperties, String additionalAnalysisProperties, TriggersConfig triggers) {
        this.name = name;
        this.serverUrl = serverUrl;
        this.credentialsId = credentialsId;
        this.serverAuthenticationToken = serverAuthenticationToken;
        this.webhookSecretId = webhookSecretId;
        this.additionalAnalysisProperties = additionalAnalysisProperties;
        this.mojoVersion = mojoVersion;
        this.additionalProperties = additionalProperties;
        this.triggers = triggers;
    }

    public static final SonarInstallation[] all() {
        return SonarGlobalConfiguration.get().getInstallations();
    }

    public static boolean isValid(String sonarInstallationName, TaskListener listener) {
        String failureMsg = SonarInstallation.validationMsg(sonarInstallationName);
        if (failureMsg != null) {
            listener.fatalError(failureMsg);
            return false;
        }
        return true;
    }

    public static void checkValid(String sonarInstallationName) throws AbortException {
        String failureMsg = SonarInstallation.validationMsg(sonarInstallationName);
        if (failureMsg != null) {
            throw new AbortException(failureMsg);
        }
    }

    private static String validationMsg(String sonarInstallationName) {
        String failureMsg;
        SonarInstallation sonarInstallation = SonarInstallation.get(sonarInstallationName);
        if (sonarInstallation == null) {
            failureMsg = StringUtils.isBlank((String)sonarInstallationName) ? Messages.SonarInstallation_NoInstallation(SonarInstallation.all().length) : Messages.SonarInstallation_NoMatchInstallation(sonarInstallationName, SonarInstallation.all().length);
            failureMsg = failureMsg + "\n" + Messages.SonarInstallation_FixInstallationTip();
        } else {
            failureMsg = null;
        }
        return failureMsg;
    }

    public static final SonarInstallation get(String name) {
        SonarInstallation[] available = SonarInstallation.all();
        if (StringUtils.isEmpty((String)name) && available.length > 0) {
            return available[0];
        }
        for (SonarInstallation si : available) {
            if (!StringUtils.equals((String)name, (String)si.getName())) continue;
            return si;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    @CheckForNull
    public String getServerAuthenticationToken(Run<?, ?> build) {
        if (this.credentialsId == null || build == null) {
            return null;
        }
        StringCredentials cred = this.getCredentials(build);
        if (cred == null) {
            return null;
        }
        return cred.getSecret().getPlainText();
    }

    public StringCredentials getCredentials(Run<?, ?> build) {
        return (StringCredentials)CredentialsProvider.findCredentialById((String)this.credentialsId, StringCredentials.class, build, (DomainRequirement[])new DomainRequirement[0]);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getWebhookSecretId() {
        return this.webhookSecretId;
    }

    @CheckForNull
    public String getMojoVersion() {
        return this.mojoVersion;
    }

    @CheckForNull
    public String getAdditionalProperties() {
        return this.additionalProperties;
    }

    @CheckForNull
    public String getAdditionalAnalysisProperties() {
        return this.additionalAnalysisProperties;
    }

    public String[] getAdditionalAnalysisPropertiesWindows() {
        if (this.additionalAnalysisProperties == null) {
            return new String[0];
        }
        this.split = StringUtils.split((String)this.additionalAnalysisProperties);
        for (int i = 0; i < this.split.length; ++i) {
            this.split[i] = "/d:" + this.split[i];
        }
        return this.split;
    }

    public String[] getAdditionalAnalysisPropertiesUnix() {
        if (this.additionalAnalysisProperties == null) {
            return new String[0];
        }
        this.split = StringUtils.split((String)this.additionalAnalysisProperties);
        for (int i = 0; i < this.split.length; ++i) {
            this.split[i] = "-D" + this.split[i];
        }
        return this.split;
    }

    public TriggersConfig getTriggers() {
        if (this.triggers == null) {
            this.triggers = new TriggersConfig();
        }
        return this.triggers;
    }

    void migrateTokenToCredential() {
        if (this.serverAuthenticationToken != null) {
            if (Util.fixEmpty((String)this.serverAuthenticationToken.getPlainText()) != null) {
                this.credentialsId = new GlobalCredentialMigrator().migrate(this.serverAuthenticationToken.getPlainText()).getId();
            }
            this.serverAuthenticationToken = null;
        }
    }
}

