/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar;

import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import org.jenkinsci.plugins.sonargerrit.SonarToGerritPublisher;
import org.jenkinsci.plugins.sonargerrit.sonar.Severity;
import org.jenkinsci.plugins.sonargerrit.util.DataHelper;
import org.jenkinsci.plugins.sonargerrit.util.Localization;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class IssueFilterConfig
extends AbstractDescribableImpl<IssueFilterConfig> {
    private String severity;
    private boolean newIssuesOnly;
    private boolean changedLinesOnly;
    private String includedPathsGlobPattern;
    private String excludedPathsGlobPattern;

    public IssueFilterConfig(String severity, boolean newIssuesOnly, boolean changedLinesOnly) {
        this.setSeverity(severity);
        this.setNewIssuesOnly(newIssuesOnly);
        this.setChangedLinesOnly(changedLinesOnly);
    }

    @DataBoundConstructor
    public IssueFilterConfig() {
        this(DescriptorImpl.SEVERITY, false, false);
    }

    public String getSeverity() {
        return this.severity;
    }

    @DataBoundSetter
    public void setSeverity(String severity) {
        severity = DataHelper.checkEnumValueCorrect(Severity.class, severity);
        this.severity = (String)MoreObjects.firstNonNull((Object)severity, (Object)DescriptorImpl.SEVERITY);
    }

    public boolean isNewIssuesOnly() {
        return this.newIssuesOnly;
    }

    @DataBoundSetter
    public void setNewIssuesOnly(boolean newIssuesOnly) {
        this.newIssuesOnly = newIssuesOnly;
    }

    public boolean isChangedLinesOnly() {
        return this.changedLinesOnly;
    }

    @DataBoundSetter
    public void setChangedLinesOnly(boolean changedLinesOnly) {
        this.changedLinesOnly = changedLinesOnly;
    }

    @Nullable
    public String getIncludedPathsGlobPattern() {
        return this.includedPathsGlobPattern;
    }

    @DataBoundSetter
    public void setIncludedPathsGlobPattern(String includedPathsGlobPattern) {
        this.includedPathsGlobPattern = includedPathsGlobPattern;
    }

    @Nullable
    public String getExcludedPathsGlobPattern() {
        return this.excludedPathsGlobPattern;
    }

    @DataBoundSetter
    public void setExcludedPathsGlobPattern(String excludedPathsGlobPattern) {
        this.excludedPathsGlobPattern = excludedPathsGlobPattern;
    }

    public DescriptorImpl getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<IssueFilterConfig> {
        public static final String SEVERITY = SonarToGerritPublisher.DescriptorImpl.SEVERITY;
        public static final boolean NEW_ISSUES_ONLY = false;
        public static final boolean CHANGED_LINES_ONLY = false;

        public FormValidation doCheckSeverity(@QueryParameter String value) {
            if (value == null) {
                return FormValidation.error((String)Localization.getLocalized("jenkins.plugin.error.review.filter.severity.unknown"));
            }
            Severity.valueOf(value);
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "IssueFilterConfig";
        }
    }
}

