/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar;

import com.google.common.base.Predicate;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.sonargerrit.sonar.Issue;

public class ByGlobPatternPredicate
implements Predicate<Issue> {
    private final PathMatcher pathMatcher;
    private final boolean negated;

    public ByGlobPatternPredicate(String pattern) {
        this(pattern, false);
    }

    public ByGlobPatternPredicate(String pattern, boolean negated) {
        this(FileSystems.getDefault().getPathMatcher("glob:" + pattern), negated);
    }

    public ByGlobPatternPredicate(PathMatcher pathMatcher, boolean negated) {
        this.pathMatcher = pathMatcher;
        this.negated = negated;
    }

    public ByGlobPatternPredicate negate() {
        return new ByGlobPatternPredicate(this.pathMatcher, !this.negated);
    }

    public boolean apply(Issue input) {
        String filepath = StringUtils.prependIfMissing((String)input.getFilepath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        boolean matched = this.pathMatcher.matches(Paths.get(filepath, new String[0]));
        if (this.negated) {
            return !matched;
        }
        return matched;
    }
}

